/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.CellSelectionType;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractHandler;
import io.keikai.ui.impl.undo.ClearCellAction;
import io.keikai.ui.sys.UndoableActionManager;
import org.zkoss.util.resource.Labels;

public class ClearCellHandler
extends AbstractHandler {
    private static final long serialVersionUID = -3759122452949257087L;
    ClearCellAction.Type _type;

    public ClearCellHandler(ClearCellAction.Type type) {
        this._type = type;
    }

    @Override
    protected boolean processAction(UserActionContext ctx) {
        Sheet sheet = ctx.getSheet();
        AreaRef selection = ctx.getSelection();
        CellSelectionType type = ctx.getSelectionType();
        Range range = Ranges.range(sheet, selection);
        if (range.isProtected()) {
            switch (type) {
                case ROW: {
                    if (!range.getSheetProtection().isFormatRowsAllowed()) break;
                    this.showProtectMessage();
                    return true;
                }
                case COLUMN: 
                case ALL: {
                    if (range.getSheetProtection().isFormatColumnsAllowed()) break;
                    this.showProtectMessage();
                    return true;
                }
                case CELL: {
                    if (range.getSheetProtection().isFormatCellsAllowed()) break;
                    this.showProtectMessage();
                    return true;
                }
            }
        }
        switch (type) {
            case ROW: {
                range = range.toRowRange();
                break;
            }
            case COLUMN: {
                range = range.toColumnRange();
                break;
            }
            case ALL: {
                range = range.toColumnRange();
            }
        }
        selection = new AreaRef(range.getRow(), range.getColumn(), range.getLastRow(), range.getLastColumn());
        String label = null;
        switch (this._type) {
            case ALL: {
                label = Labels.getLabel((String)"zss.undo.clearAll");
                break;
            }
            case CONTENT: {
                label = Labels.getLabel((String)"zss.undo.clearContents");
                break;
            }
            case STYLE: {
                label = Labels.getLabel((String)"zss.undo.clearStyles");
            }
        }
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        uam.doAction(new ClearCellAction(label, sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), this._type));
        return true;
    }
}

