/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.model.SSheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.au.in.SelectSheetCommand;
import io.keikai.ui.sys.FreezeInfoLoader;
import io.keikai.ui.sys.SpreadsheetCtrl;
import java.util.Map;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class FetchActiveRangeCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, FetchActiveRangeCommand.class);
        }
        Map data = request.getData();
        if (data == null || data.size() != 5) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), SelectSheetCommand.class});
        }
        Spreadsheet spreadsheet = (Spreadsheet)comp;
        String sheetId = (String)data.get("sheetId");
        int left = (Integer)data.get("left");
        int right = (Integer)data.get("right");
        int top = (Integer)data.get("top");
        int bottom = (Integer)data.get("bottom");
        SSheet sheet = spreadsheet.getSelectedSSheet();
        if (sheetId.equals(sheet.getId())) {
            SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)spreadsheet.getExtraCtrl();
            FreezeInfoLoader freezeInfo = spreadsheetCtrl.getFreezeInfoLoader();
            JSONObject mainBlock = spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, left, top, right, bottom);
            int fzc = freezeInfo.getColumnFreeze(sheet);
            int fzr = freezeInfo.getRowFreeze(sheet);
            if (fzc > -1) {
                mainBlock.put((Object)"leftFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, 0, top, fzc, bottom));
            }
            if (fzr > -1) {
                mainBlock.put((Object)"topFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, left, 0, right, fzr));
            }
            spreadsheet.smartUpdate("activeRangeUpdate", mainBlock);
        }
    }
}

