/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColor;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractBorderAdv;
import io.keikai.model.impl.AbstractCellStyleAdv;
import io.keikai.model.impl.AbstractFillAdv;
import io.keikai.model.impl.AbstractFontAdv;
import io.keikai.model.impl.BookImpl;
import io.keikai.model.impl.BorderImpl;
import io.keikai.model.impl.ColorImpl;
import io.keikai.model.impl.FillImpl;
import io.keikai.model.impl.FontImpl;
import io.keikai.model.util.Validations;
import org.zkoss.lang.Objects;

public class CellStyleImpl
extends AbstractCellStyleAdv {
    private static final long serialVersionUID = 1L;
    protected AbstractFontAdv _font;
    protected AbstractFillAdv _fill;
    protected AbstractBorderAdv _border;
    protected SCellStyle.Alignment _alignment = SCellStyle.Alignment.GENERAL;
    protected SCellStyle.VerticalAlignment _verticalAlignment = SCellStyle.VerticalAlignment.BOTTOM;
    protected boolean _wrapText = false;
    protected String _dataFormat;
    protected boolean _directFormat = false;
    protected boolean _locked = true;
    protected boolean _hidden = false;
    protected int _rotation;
    protected int _indention;
    public static final SCellStyle BLANK_STYLE = new CellStyleImpl((AbstractFontAdv)FontImpl.BLANK_FONT, (AbstractFillAdv)FillImpl.BLANK_FILL, null);

    CellStyleImpl(CellStyleImpl src, BookImpl book) {
        this._font = (AbstractFontAdv)(src._font == null ? null : src._font.cloneFont(book));
        this._fill = (AbstractFillAdv)(src._fill == null ? null : src._fill.cloneFill(book));
        this._border = (AbstractBorderAdv)(src._border == null ? null : src._border.cloneBorder(book));
        this._alignment = src._alignment;
        this._verticalAlignment = src._verticalAlignment;
        this._wrapText = src._wrapText;
        this._dataFormat = src._dataFormat;
        this._directFormat = src._directFormat;
        this._locked = src._locked;
        this._hidden = src._hidden;
        this._rotation = src._rotation;
        this._indention = src._indention;
    }

    public CellStyleImpl(AbstractFontAdv font) {
        this._font = font;
    }

    public CellStyleImpl(AbstractFontAdv font, AbstractFillAdv fill, AbstractBorderAdv border) {
        this._font = font;
        this._fill = fill;
        this._border = border;
    }

    @Override
    public SFont getFont() {
        return this._font;
    }

    @Override
    public void setFont(SFont font) {
        Validations.argInstance(font, AbstractFontAdv.class);
        this._font = (AbstractFontAdv)font;
    }

    @Override
    public SColor getFillColor() {
        return this._fill == null ? ColorImpl.BLACK : this._fill.getFillColor();
    }

    @Override
    public void setFillColor(SColor fillColor) {
        Validations.argNotNull(fillColor);
        if (this._fill == null) {
            this._fill = new FillImpl();
        }
        this._fill.setFillColor(fillColor);
    }

    @Override
    public SFill.FillPattern getFillPattern() {
        return this._fill == null ? SFill.FillPattern.NONE : this._fill.getFillPattern();
    }

    @Override
    public void setFillPattern(SFill.FillPattern fillPattern) {
        Validations.argNotNull(new Object[]{fillPattern});
        if (this._fill == null) {
            this._fill = new FillImpl();
        }
        this._fill.setFillPattern(fillPattern);
    }

    @Override
    public SCellStyle.Alignment getAlignment() {
        return this._alignment;
    }

    @Override
    public void setAlignment(SCellStyle.Alignment alignment) {
        Validations.argNotNull(new Object[]{alignment});
        this._alignment = alignment;
    }

    @Override
    public SCellStyle.VerticalAlignment getVerticalAlignment() {
        return this._verticalAlignment;
    }

    @Override
    public void setVerticalAlignment(SCellStyle.VerticalAlignment verticalAlignment) {
        Validations.argNotNull(new Object[]{verticalAlignment});
        this._verticalAlignment = verticalAlignment;
    }

    @Override
    public boolean isWrapText() {
        return this._wrapText;
    }

    @Override
    public void setWrapText(boolean wrapText) {
        this._wrapText = wrapText;
    }

    @Override
    public SBorder.BorderType getBorderLeft() {
        return this._border == null ? SBorder.BorderType.NONE : this._border.getBorderLeft();
    }

    @Override
    public void setBorderLeft(SBorder.BorderType borderLeft) {
        Validations.argNotNull(new Object[]{borderLeft});
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderLeft(borderLeft);
    }

    @Override
    public SBorder.BorderType getBorderTop() {
        return this._border == null ? SBorder.BorderType.NONE : this._border.getBorderTop();
    }

    @Override
    public void setBorderTop(SBorder.BorderType type) {
        Validations.argNotNull(new Object[]{type});
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderTop(type);
    }

    @Override
    public SBorder.BorderType getBorderRight() {
        return this._border == null ? SBorder.BorderType.NONE : this._border.getBorderRight();
    }

    @Override
    public void setBorderRight(SBorder.BorderType type) {
        Validations.argNotNull(new Object[]{type});
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderRight(type);
    }

    @Override
    public SBorder.BorderType getBorderBottom() {
        return this._border == null ? SBorder.BorderType.NONE : this._border.getBorderBottom();
    }

    @Override
    public void setBorderBottom(SBorder.BorderType type) {
        Validations.argNotNull(new Object[]{type});
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderBottom(type);
    }

    @Override
    public SColor getBorderTopColor() {
        return this._border == null ? ColorImpl.BLACK : this._border.getBorderTopColor();
    }

    @Override
    public void setBorderTopColor(SColor color) {
        Validations.argNotNull(color);
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderTopColor(color);
    }

    @Override
    public SColor getBorderLeftColor() {
        return this._border == null ? ColorImpl.BLACK : this._border.getBorderLeftColor();
    }

    @Override
    public void setBorderLeftColor(SColor color) {
        Validations.argNotNull(color);
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderLeftColor(color);
    }

    @Override
    public SColor getBorderBottomColor() {
        return this._border == null ? ColorImpl.BLACK : this._border.getBorderBottomColor();
    }

    @Override
    public void setBorderBottomColor(SColor color) {
        Validations.argNotNull(color);
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderBottomColor(color);
    }

    @Override
    public SColor getBorderRightColor() {
        return this._border == null ? ColorImpl.BLACK : this._border.getBorderRightColor();
    }

    @Override
    public void setBorderRightColor(SColor color) {
        Validations.argNotNull(color);
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderRightColor(color);
    }

    @Override
    public String getDataFormat() {
        return this._dataFormat == null ? "General" : this._dataFormat;
    }

    @Override
    public boolean isDirectDataFormat() {
        return this._directFormat;
    }

    @Override
    public void setDataFormat(String dataFormat) {
        if (dataFormat == null || "".equals(dataFormat.trim())) {
            dataFormat = "General";
        }
        this._dataFormat = dataFormat;
        this._directFormat = false;
    }

    @Override
    public void setDirectDataFormat(String dataFormat) {
        this.setDataFormat(dataFormat);
        this._directFormat = true;
    }

    @Override
    public boolean isLocked() {
        return this._locked;
    }

    @Override
    public void setLocked(boolean locked) {
        this._locked = locked;
    }

    @Override
    public boolean isHidden() {
        return this._hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    @Override
    public void copyFrom(SCellStyle src) {
        if (src == this) {
            return;
        }
        Validations.argInstance(src, CellStyleImpl.class);
        this.setFont(src.getFont());
        this.setFillColor(src.getFillColor());
        this.setBackColor(src.getBackColor());
        this.setFillPattern(src.getFillPattern());
        this.setAlignment(src.getAlignment());
        this.setVerticalAlignment(src.getVerticalAlignment());
        this.setWrapText(src.isWrapText());
        this.setRotation(src.getRotation());
        this.setIndention(src.getIndention());
        this.setBorderLeft(src.getBorderLeft());
        this.setBorderTop(src.getBorderTop());
        this.setBorderRight(src.getBorderRight());
        this.setBorderBottom(src.getBorderBottom());
        this.setBorderTopColor(src.getBorderTopColor());
        this.setBorderLeftColor(src.getBorderLeftColor());
        this.setBorderBottomColor(src.getBorderBottomColor());
        this.setBorderRightColor(src.getBorderRightColor());
        this.setDataFormat(src.getDataFormat());
        this.setLocked(src.isLocked());
        this.setHidden(src.isHidden());
    }

    @Override
    String getStyleKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._font == null ? "" : this._font.getStyleKey()).append(".").append(this._fill == null ? "" : this._fill.getStyleKey()).append(".").append(this._border == null ? "" : this._border.getStyleKey()).append(".").append(this._alignment.ordinal()).append(".").append(this._verticalAlignment.ordinal()).append(".").append(this._wrapText ? "T" : "F").append(".").append(this.getDataFormat()).append(".").append(this._locked ? "T" : "F").append(".").append(this._hidden ? "T" : "F").append(".").append(this._rotation);
        return sb.toString();
    }

    @Override
    public void setBorderLeft(SBorder.BorderType borderLeft, SColor color) {
        this.setBorderLeft(borderLeft);
        this.setBorderLeftColor(color);
    }

    @Override
    public void setBorderTop(SBorder.BorderType borderTop, SColor color) {
        this.setBorderTop(borderTop);
        this.setBorderTopColor(color);
    }

    @Override
    public void setBorderRight(SBorder.BorderType borderRight, SColor color) {
        this.setBorderRight(borderRight);
        this.setBorderRightColor(color);
    }

    @Override
    public void setBorderBottom(SBorder.BorderType borderBottom, SColor color) {
        this.setBorderBottom(borderBottom);
        this.setBorderBottomColor(color);
    }

    @Override
    public SColor getBackColor() {
        return this._fill == null ? ColorImpl.WHITE : this._fill.getBackColor();
    }

    @Override
    @Deprecated
    public void setBackgroundColor(SColor backColor) {
        this.setBackColor(backColor);
    }

    @Override
    public void setBackColor(SColor backColor) {
        Validations.argNotNull(backColor);
        if (this._fill == null) {
            this._fill = new FillImpl();
        }
        this._fill.setBackColor(backColor);
    }

    @Override
    public String getFillPatternHtml() {
        return this._fill == null ? "" : ((FillImpl)this._fill).getFillPatternHtml();
    }

    public int hashCode() {
        int hash = this._font == null ? 0 : this._font.hashCode();
        hash = hash * 31 + (this._fill == null ? 0 : this._fill.hashCode());
        hash = hash * 31 + (this._alignment == null ? 0 : this._alignment.hashCode());
        hash = hash * 31 + (this._verticalAlignment == null ? 0 : this._verticalAlignment.hashCode());
        hash = hash * 31 + (this._wrapText ? 1 : 0);
        hash = hash * 31 + (this._border == null ? 0 : this._border.hashCode());
        hash = hash * 31 + (this.getDataFormat() == null ? 0 : this.getDataFormat().hashCode());
        hash = hash * 31 + (this._directFormat ? 1 : 0);
        hash = hash * 31 + (this._locked ? 1 : 0);
        hash = hash * 31 + (this._hidden ? 1 : 0);
        hash = hash * 31 + this._rotation;
        hash = hash * 31 + this._indention;
        return hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof CellStyleImpl)) {
            return false;
        }
        CellStyleImpl o = (CellStyleImpl)other;
        return Objects.equals((Object)this._font, (Object)o._font) && Objects.equals((Object)this._fill, (Object)o._fill) && Objects.equals((Object)((Object)this._alignment), (Object)((Object)o._alignment)) && Objects.equals((Object)((Object)this._verticalAlignment), (Object)((Object)o._verticalAlignment)) && Objects.equals((Object)this._wrapText, (Object)o._wrapText) && Objects.equals((Object)this._border, (Object)o._border) && Objects.equals((Object)this.getDataFormat(), (Object)o.getDataFormat()) && Objects.equals((Object)this._directFormat, (Object)o._directFormat) && Objects.equals((Object)this._locked, (Object)o._locked) && Objects.equals((Object)this._hidden, (Object)o._hidden) && Objects.equals((Object)this._rotation, (Object)o._rotation) && Objects.equals((Object)this._indention, (Object)o._indention);
    }

    @Override
    public int getRotation() {
        return this._rotation;
    }

    @Override
    public void setRotation(int rotation) {
        this._rotation = rotation;
    }

    @Override
    public int getIndention() {
        return this._indention;
    }

    @Override
    public void setIndention(int indention) {
        this._indention = indention;
    }

    @Override
    public SBorder getBorder() {
        return this._border;
    }

    @Override
    public SFill getFill() {
        return this._fill;
    }

    @Override
    public void setBorderVertical(SBorder.BorderType type) {
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderVertical(type);
    }

    @Override
    public void setBorderVertical(SBorder.BorderType type, SColor color) {
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderVertical(type);
        this._border.setBorderVerticalColor(color);
    }

    @Override
    public void setBorderHorizontal(SBorder.BorderType type) {
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderHorizontal(type);
    }

    @Override
    public void setBorderHorizontal(SBorder.BorderType type, SColor color) {
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderHorizontal(type);
        this._border.setBorderHorizontalColor(color);
    }

    @Override
    public void setBorderDiagonal(SBorder.BorderType type) {
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderDiagonal(type);
    }

    @Override
    public void setBorderDiagonal(SBorder.BorderType type, SColor color) {
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderDiagonal(type);
        this._border.setBorderDiagonalColor(color);
    }

    @Override
    public void setBorderVerticalColor(SColor color) {
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderVerticalColor(color);
    }

    @Override
    public void setBorderHorizontalColor(SColor color) {
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderHorizontalColor(color);
    }

    @Override
    public void setBorderDiagonalColor(SColor color) {
        if (this._border == null) {
            this._border = new BorderImpl();
        }
        this._border.setBorderDiagonalColor(color);
    }

    @Override
    public SBorder.BorderType getBorderVertical() {
        return this._border == null ? SBorder.BorderType.NONE : this._border.getBorderVertical();
    }

    @Override
    public SBorder.BorderType getBorderHorizontal() {
        return this._border == null ? SBorder.BorderType.NONE : this._border.getBorderHorizontal();
    }

    @Override
    public SBorder.BorderType getBorderDiagonal() {
        return this._border == null ? SBorder.BorderType.NONE : this._border.getBorderDiagonal();
    }

    @Override
    public SColor getBorderVerticalColor() {
        return this._border == null ? ColorImpl.BLACK : this._border.getBorderVerticalColor();
    }

    @Override
    public SColor getBorderHorizontalColor() {
        return this._border == null ? ColorImpl.BLACK : this._border.getBorderHorizontalColor();
    }

    @Override
    public SColor getBorderDiagonalColor() {
        return this._border == null ? ColorImpl.BLACK : this._border.getBorderDiagonalColor();
    }

    protected void setBorder(SBorder border) {
        this._border = (AbstractBorderAdv)border;
    }

    protected void setFill(SFill fill) {
        this._fill = (AbstractFillAdv)fill;
    }

    @Override
    public boolean isShowDiagonalUpBorder() {
        if (this._border == null) {
            return false;
        }
        return this._border.isShowDiagonalUpBorder();
    }

    @Override
    public boolean isShowDiagonalDownBorder() {
        if (this._border == null) {
            return false;
        }
        return this._border.isShowDiagonalDownBorder();
    }

    @Override
    SCellStyle cloneCellStyle(SBook book) {
        return book == null ? this : ((AbstractBookAdv)book).getOrCreateCellStyle(this);
    }

    @Override
    SCellStyle createCellStyle(SBook book) {
        return new CellStyleImpl(this, (BookImpl)book);
    }
}

