/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.LittleEndianOutput;

public class Compat12Record
extends StandardRecord {
    private static final BitField fNoCompatChk = BitFieldFactory.getInstance(1);
    public static final short sid = 2188;
    private FtrHeader futureHeader;
    int bits;

    public Compat12Record() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2188);
    }

    public Compat12Record(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.bits = in.readInt();
    }

    @Override
    public short getSid() {
        return 2188;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[COMPAT12]\n");
        buffer.append(this.futureHeader.toString());
        buffer.append("    .bits       = ").append(Integer.toHexString(this.bits)).append("\n");
        buffer.append("       .fNoCompatChk     = ").append(this.isNoCompatibleCheck()).append("\n");
        buffer.append("[/COMPAT12]\n");
        return buffer.toString();
    }

    public boolean isNoCompatibleCheck() {
        return fNoCompatChk.isSet(this.bits);
    }

    public void setNoCompatibleCheck(boolean flag) {
        this.bits = fNoCompatChk.setBoolean(this.bits, flag);
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.bits);
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected int getDataSize() {
        return 16;
    }
}

