/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hdgf.dev;

import java.io.FileInputStream;
import org.zkoss.poi.hdgf.HDGFDiagram;
import org.zkoss.poi.hdgf.chunks.Chunk;
import org.zkoss.poi.hdgf.pointers.Pointer;
import org.zkoss.poi.hdgf.streams.ChunkStream;
import org.zkoss.poi.hdgf.streams.PointerContainingStream;
import org.zkoss.poi.hdgf.streams.Stream;
import org.zkoss.poi.poifs.filesystem.POIFSFileSystem;

public final class VSDDumper {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("  VSDDumper <filename>");
            System.exit(1);
        }
        HDGFDiagram hdgf = new HDGFDiagram(new POIFSFileSystem(new FileInputStream(args[0])));
        System.out.println("Opened " + args[0]);
        System.out.println("The document claims a size of " + hdgf.getDocumentSize() + "   (" + Long.toHexString(hdgf.getDocumentSize()) + ")");
        System.out.println();
        VSDDumper.dumpStream(hdgf.getTrailerStream(), 0);
    }

    public static void dumpStream(Stream stream, int indent) {
        int i;
        String ind = "";
        for (int i2 = 0; i2 < indent; ++i2) {
            ind = ind + "    ";
        }
        String ind2 = ind + "    ";
        String ind3 = ind2 + "    ";
        Pointer ptr = stream.getPointer();
        System.out.println(ind + "Stream at\t" + ptr.getOffset() + " - " + Integer.toHexString(ptr.getOffset()));
        System.out.println(ind + "  Type is\t" + ptr.getType() + " - " + Integer.toHexString(ptr.getType()));
        System.out.println(ind + "  Format is\t" + ptr.getFormat() + " - " + Integer.toHexString(ptr.getFormat()));
        System.out.println(ind + "  Length is\t" + ptr.getLength() + " - " + Integer.toHexString(ptr.getLength()));
        if (ptr.destinationCompressed()) {
            int decompLen = stream._getContentsLength();
            System.out.println(ind + "  DC.Length is\t" + decompLen + " - " + Integer.toHexString(decompLen));
        }
        System.out.println(ind + "  Compressed is\t" + ptr.destinationCompressed());
        System.out.println(ind + "  Stream is\t" + stream.getClass().getName());
        byte[] db = stream._getStore()._getContents();
        String ds = "";
        if (db.length >= 8) {
            for (int i3 = 0; i3 < 8; ++i3) {
                if (i3 > 0) {
                    ds = ds + ", ";
                }
                ds = ds + db[i3];
            }
        }
        System.out.println(ind + "  First few bytes are\t" + ds);
        if (stream instanceof PointerContainingStream) {
            PointerContainingStream pcs = (PointerContainingStream)stream;
            System.out.println(ind + "  Has " + pcs.getPointedToStreams().length + " children:");
            for (i = 0; i < pcs.getPointedToStreams().length; ++i) {
                VSDDumper.dumpStream(pcs.getPointedToStreams()[i], indent + 1);
            }
        }
        if (stream instanceof ChunkStream) {
            ChunkStream cs = (ChunkStream)stream;
            System.out.println(ind + "  Has " + cs.getChunks().length + " chunks:");
            for (i = 0; i < cs.getChunks().length; ++i) {
                Chunk chunk = cs.getChunks()[i];
                System.out.println(ind2 + "" + chunk.getName());
                System.out.println(ind2 + "  Length is " + chunk._getContents().length + " (" + Integer.toHexString(chunk._getContents().length) + ")");
                System.out.println(ind2 + "  OD Size is " + chunk.getOnDiskSize() + " (" + Integer.toHexString(chunk.getOnDiskSize()) + ")");
                System.out.println(ind2 + "  T / S is " + chunk.getTrailer() + " / " + chunk.getSeparator());
                System.out.println(ind2 + "  Holds " + chunk.getCommands().length + " commands");
                for (int j = 0; j < chunk.getCommands().length; ++j) {
                    Chunk.Command command = chunk.getCommands()[j];
                    System.out.println(ind3 + "" + command.getDefinition().getName() + " " + command.getValue());
                }
            }
        }
    }
}

