/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.SSheetProtection;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractRowAdv;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.impl.HeaderPositionHelper;
import io.keikai.ui.impl.NonBlankCellsHelper;
import io.keikai.ui.sys.SpreadsheetCtrl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class CtrlArrowCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        int index;
        SSheet sheet;
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, CtrlArrowCommand.class);
        }
        Map data = request.getData();
        if (data == null || data.size() != 4) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), CtrlArrowCommand.class});
        }
        Spreadsheet spreadsheet = (Spreadsheet)comp;
        String sheetId = (String)data.get("sheetId");
        if (sheetId.equals((sheet = spreadsheet.getSelectedSSheet()).getId()) && (index = this.nonBlankIndex(spreadsheet, sheet, data)) >= 0) {
            SSheetProtection prot;
            String dir = (String)data.get("dir");
            int rowIdx = (Integer)data.get("row");
            int colIdx = (Integer)data.get("col");
            if ("up".equals(dir) || "down".equals(dir)) {
                rowIdx = index;
            } else {
                colIdx = index;
            }
            if (sheet.isProtected() && (prot = sheet.getSheetProtection()) != null) {
                if (prot.isSelectUnlockedCells()) {
                    SCellStyle style = sheet.getCell(rowIdx, colIdx).getCellStyle();
                    if (style.isLocked()) {
                        return;
                    }
                } else {
                    return;
                }
            }
            JSONObject param = new JSONObject();
            param.put((Object)"sheetId", (Object)sheetId);
            param.put((Object)"row", (Object)rowIdx);
            param.put((Object)"col", (Object)colIdx);
            spreadsheet.smartUpdate("ctrlArrowMoveFocus", param);
        }
    }

    private int nonBlankIndex(Spreadsheet spreadsheet, SSheet sheet, Map data) {
        SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)spreadsheet.getExtraCtrl();
        String sheetId = (String)data.get("sheetId");
        int rowIdx = (Integer)data.get("row");
        int colIdx = (Integer)data.get("col");
        String dir = (String)data.get("dir");
        if ("left".equals(dir)) {
            NonBlankCellsHelper helper = this.createRowNonBlankCellsHelper(sheet, rowIdx);
            HeaderPositionHelper phelper = spreadsheetCtrl.getColumnPositionHelper(sheetId);
            if (helper == null) {
                return phelper.getNextNonHidden(-1);
            }
            int prev = colIdx;
            while ((prev = helper.getPrevNonBlank(prev)) >= 0) {
                if (phelper.isHidden(prev)) continue;
                return prev;
            }
            return phelper.getNextNonHidden(-1);
        }
        if ("right".equals(dir)) {
            NonBlankCellsHelper helper = this.createRowNonBlankCellsHelper(sheet, rowIdx);
            HeaderPositionHelper phelper = spreadsheetCtrl.getColumnPositionHelper(sheetId);
            if (helper == null) {
                return phelper.getPrevNonHidden(spreadsheet.getCurrentMaxVisibleColumns());
            }
            int next = colIdx;
            while ((next = helper.getNextNonBlank(next)) >= 0) {
                if (phelper.isHidden(next)) continue;
                if (next >= spreadsheet.getCurrentMaxVisibleColumns()) {
                    return phelper.getPrevNonHidden(spreadsheet.getCurrentMaxVisibleColumns());
                }
                return next;
            }
            return phelper.getPrevNonHidden(spreadsheet.getCurrentMaxVisibleColumns());
        }
        if ("up".equals(dir)) {
            NonBlankCellsHelper helper = this.createColumnNonBlankCellsHelper(sheet, colIdx);
            HeaderPositionHelper phelper = spreadsheetCtrl.getRowPositionHelper(sheetId);
            if (helper == null) {
                return phelper.getNextNonHidden(-1);
            }
            int prev = rowIdx;
            while ((prev = helper.getPrevNonBlank(prev)) >= 0) {
                if (phelper.isHidden(prev)) continue;
                return prev;
            }
            return phelper.getNextNonHidden(-1);
        }
        if ("down".equals(dir)) {
            NonBlankCellsHelper helper = this.createColumnNonBlankCellsHelper(sheet, colIdx);
            HeaderPositionHelper phelper = spreadsheetCtrl.getRowPositionHelper(sheetId);
            if (helper == null) {
                return phelper.getPrevNonHidden(spreadsheet.getCurrentMaxVisibleRows());
            }
            int next = rowIdx;
            while ((next = helper.getNextNonBlank(next)) >= 0) {
                if (phelper.isHidden(next)) continue;
                if (next >= spreadsheet.getCurrentMaxVisibleRows()) {
                    return phelper.getPrevNonHidden(spreadsheet.getCurrentMaxVisibleRows());
                }
                return next;
            }
            return phelper.getPrevNonHidden(spreadsheet.getCurrentMaxVisibleRows());
        }
        throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), CtrlArrowCommand.class});
    }

    private NonBlankCellsHelper createRowNonBlankCellsHelper(SSheet sheet, int rowIdx) {
        int start = -1;
        int end = -1;
        SRow row = sheet.getRow(rowIdx);
        if (row == null) {
            return null;
        }
        ArrayList<NonBlankCellsHelper.NonBlankCellInfo> infos = new ArrayList<NonBlankCellsHelper.NonBlankCellInfo>();
        Iterator it = row.getCellIterator();
        while (it.hasNext()) {
            SCell cell = (SCell)it.next();
            if (cell == null || cell.isNull() || cell.getType() == SCell.CellType.BLANK) {
                if (start < 0) continue;
                infos.add(new NonBlankCellsHelper.NonBlankCellInfo(start, end));
                start = -1;
                end = -1;
                continue;
            }
            int colIdx = cell.getColumnIndex();
            if (start < 0) {
                start = end = colIdx;
                continue;
            }
            if (end + 1 == colIdx) {
                end = colIdx;
                continue;
            }
            infos.add(new NonBlankCellsHelper.NonBlankCellInfo(start, end));
            start = end = colIdx;
        }
        if (start >= 0) {
            infos.add(new NonBlankCellsHelper.NonBlankCellInfo(start, end));
        }
        return infos.isEmpty() ? null : new NonBlankCellsHelper(infos);
    }

    private NonBlankCellsHelper createColumnNonBlankCellsHelper(SSheet sheet, int columnIdx) {
        int start = -1;
        int end = -1;
        ArrayList<NonBlankCellsHelper.NonBlankCellInfo> infos = new ArrayList<NonBlankCellsHelper.NonBlankCellInfo>();
        Iterator it = sheet.getRowIterator();
        while (it.hasNext()) {
            SRow row = (SRow)it.next();
            AbstractCellAdv cell = ((AbstractRowAdv)row).getCell(columnIdx, false);
            if (cell == null || cell.isNull() || cell.getType() == SCell.CellType.BLANK) {
                if (start < 0) continue;
                infos.add(new NonBlankCellsHelper.NonBlankCellInfo(start, end));
                start = -1;
                end = -1;
                continue;
            }
            int rowIdx = row.getIndex();
            if (start < 0) {
                start = end = rowIdx;
                continue;
            }
            if (end + 1 == rowIdx) {
                end = rowIdx;
                continue;
            }
            infos.add(new NonBlankCellsHelper.NonBlankCellInfo(start, end));
            start = end = rowIdx;
        }
        if (start >= 0) {
            infos.add(new NonBlankCellsHelper.NonBlankCellInfo(start, end));
        }
        return infos.isEmpty() ? null : new NonBlankCellsHelper(infos);
    }
}

