/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.custom.CapacityCodec;
import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.memory.Capacity;

public final class MemoryTierConfigCodec {
    private MemoryTierConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, MemoryTierConfig memoryTierConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        CapacityCodec.encode(clientMessage, memoryTierConfig.getCapacity());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MemoryTierConfig decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        Capacity capacity = CapacityCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createMemoryTierConfig(capacity);
    }
}

