/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.ResettableSingletonTraverser;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.impl.processor.AbstractTransformUsingServiceP;
import com.hazelcast.jet.impl.processor.ProcessorSupplierWithService;
import com.hazelcast.jet.pipeline.ServiceFactory;
import javax.annotation.Nonnull;

public final class TransformUsingServiceP<C, S, T, R>
extends AbstractTransformUsingServiceP<C, S> {
    private final TriFunction<? super ResettableSingletonTraverser<R>, ? super S, ? super T, ? extends Traverser<R>> flatMapFn;
    private Traverser<? extends R> outputTraverser;
    private final ResettableSingletonTraverser<R> singletonTraverser = new ResettableSingletonTraverser();

    private TransformUsingServiceP(@Nonnull ServiceFactory<C, S> serviceFactory, @Nonnull C context, @Nonnull TriFunction<? super ResettableSingletonTraverser<R>, ? super S, ? super T, ? extends Traverser<R>> flatMapFn) {
        super(serviceFactory, context);
        this.flatMapFn = flatMapFn;
    }

    @Override
    protected boolean tryProcess(int ordinal, @Nonnull Object item) {
        if (this.outputTraverser == null) {
            this.outputTraverser = this.flatMapFn.apply(this.singletonTraverser, this.service, item);
        }
        if (this.emitFromTraverser(this.outputTraverser)) {
            this.outputTraverser = null;
            return true;
        }
        return false;
    }

    public static <C, S, T, R> ProcessorSupplier supplier(@Nonnull ServiceFactory<C, S> serviceFactory, @Nonnull TriFunction<? super ResettableSingletonTraverser<R>, ? super S, ? super T, ? extends Traverser<R>> flatMapFn) {
        return ProcessorSupplierWithService.supplierWithService(serviceFactory, (serviceFn, context) -> new TransformUsingServiceP(serviceFn, context, flatMapFn));
    }
}

