/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.Set;
import javax.security.auth.Subject;

public class JobRecord
implements IdentifiedDataSerializable {
    private Version clusterVersion;
    private long jobId;
    private long creationTime;
    private Data dag;
    private String dagJson;
    private JobConfig config;
    private Set<String> ownedObservables;
    private Subject subject;

    public JobRecord() {
    }

    public JobRecord(Version clusterVersion, long jobId, Data dag, String dagJson, JobConfig config, Set<String> ownedObservables, Subject subject) {
        this.clusterVersion = clusterVersion;
        this.jobId = jobId;
        this.creationTime = Clock.currentTimeMillis();
        this.dag = dag;
        this.dagJson = dagJson;
        this.config = config;
        this.ownedObservables = ownedObservables;
        this.subject = subject;
    }

    public Version getClusterVersion() {
        return this.clusterVersion;
    }

    public long getJobId() {
        return this.jobId;
    }

    public String getJobNameOrId() {
        return this.config.getName() != null ? this.config.getName() : com.hazelcast.jet.Util.idToString(this.jobId);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Data getDag() {
        return this.dag;
    }

    public String getDagJson() {
        return this.dagJson;
    }

    public JobConfig getConfig() {
        return this.config;
    }

    public Set<String> getOwnedObservables() {
        return this.ownedObservables;
    }

    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.clusterVersion);
        out.writeLong(this.jobId);
        out.writeLong(this.creationTime);
        IOUtil.writeData(out, this.dag);
        out.writeUTF(this.dagJson);
        out.writeObject(this.config);
        out.writeObject(this.ownedObservables);
        ImdgUtil.writeSubject(out, this.subject);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.clusterVersion = (Version)in.readObject();
        this.jobId = in.readLong();
        this.creationTime = in.readLong();
        this.dag = IOUtil.readData(in);
        this.dagJson = in.readUTF();
        this.config = (JobConfig)in.readObject();
        this.ownedObservables = (Set)in.readObject();
        this.subject = ImdgUtil.readSubject(in);
    }

    public String toString() {
        return "JobRecord{jobId=" + com.hazelcast.jet.Util.idToString(this.jobId) + ", name=" + this.getConfig().getName() + ", creationTime=" + Util.toLocalDateTime(this.creationTime) + ", dagJson=" + this.dagJson + ", config=" + this.config + ", ownedObservables=" + this.ownedObservables + '}';
    }
}

