/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.storage;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.ecs.storage.NoSuchObjectException;

public class Array
implements Enumeration<Object>,
Serializable {
    private static final long serialVersionUID = -7392079695735049505L;
    private int current = 0;
    private int size = 10;
    private int grow = 2;
    private int place = 0;
    private Object[] elements = null;
    private Object[] tmpElements = null;

    public Array() {
        this.init();
    }

    public Array(int size) {
        this.setSize(size);
        this.init();
    }

    public Array(int size, int grow) {
        this.setSize(size);
        this.setGrow(grow);
        this.init();
    }

    private void init() {
        this.elements = new Object[this.size];
    }

    @Override
    public Object nextElement() throws NoSuchElementException {
        if (this.elements[this.place] != null && this.place != this.current) {
            ++this.place;
            return this.elements[this.place - 1];
        }
        this.place = 0;
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasMoreElements() {
        return this.place < this.elements.length && this.current != this.place;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getCurrentSize() {
        return this.current;
    }

    public void rehash() {
        this.tmpElements = new Object[this.size];
        int count = 0;
        int x = 0;
        while (x < this.elements.length) {
            if (this.elements[x] != null) {
                this.tmpElements[count] = this.elements[x];
                ++count;
            }
            ++x;
        }
        this.elements = (Object[])this.tmpElements.clone();
        this.tmpElements = null;
        this.current = count;
    }

    public void setGrow(int grow) {
        this.grow = grow;
    }

    public void grow() {
        this.size = this.size += this.size / this.grow;
        this.rehash();
    }

    public void add(Object o) {
        if (this.current == this.elements.length) {
            this.grow();
        }
        try {
            this.elements[this.current] = o;
            ++this.current;
        }
        catch (ArrayStoreException arrayStoreException) {}
    }

    public void add(int location, Object o) {
        try {
            this.elements[location] = o;
        }
        catch (ArrayStoreException arrayStoreException) {}
    }

    public void remove(int location) {
        this.elements[location] = null;
    }

    public int location(Object o) throws NoSuchObjectException {
        int loc = -1;
        int x = 0;
        while (x < this.elements.length) {
            if (this.elements[x] != null && this.elements[x] == o || this.elements[x] != null && this.elements[x].equals(o)) {
                loc = x;
                break;
            }
            ++x;
        }
        if (loc == -1) {
            throw new NoSuchObjectException();
        }
        return loc;
    }

    public Object get(int location) {
        return this.elements[location];
    }

    public Enumeration<Object> elements() {
        return this;
    }
}

