/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.CreateFromBatch;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.model.MTable;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class CreateFromStatement
extends CreateFromBatch {
    public CreateFromStatement(GridTab mTab) {
        super(mTab);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(mTab.toString());
        }
    }

    @Override
    protected boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(Msg.getElement((Properties)Env.getCtx(), (String)"C_BankStatement_ID") + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    @Override
    protected Vector<Vector<Object>> getBankAccountData(Integer BankAccount, Integer BPartner, String DocumentNo, Timestamp DateFrom, Timestamp DateTo, BigDecimal AmtFrom, BigDecimal AmtTo, Integer DocType, String TenderType, String AuthCode, Integer Currency2) {
        Vector<Vector<Object>> data;
        block10: {
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder();
            sql.append("WITH Payments AS ( ");
            sql.append("SELECT p.DateTrx as DateTrx, p.C_Payment_ID, NULL AS C_DepositBatch_ID, p.DocumentNo, p.C_Currency_ID, c.ISO_Code, p.PayAmt,");
            sql.append(" currencyConvert(p.PayAmt,p.C_Currency_ID,ba.C_Currency_ID,p.DateAcct,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID) AS ConvAmount, bp.Name,");
            sql.append(" p.Processed, p.C_BankAccount_ID, p.C_DocType_ID, p.TenderType, p.R_AuthCode, p.C_BPartner_ID ");
            sql.append("FROM C_BankAccount ba");
            sql.append(" INNER JOIN C_Payment_v p ON (p.C_BankAccount_ID=ba.C_BankAccount_ID)");
            sql.append(" INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID)");
            sql.append(" LEFT OUTER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID) ");
            sql.append(" WHERE (p.C_DepositBatch_ID = 0 OR p.C_DepositBatch_ID IS NULL) ");
            sql.append(" AND p.IsReconciled = 'N'");
            sql.append(" AND p.DocStatus IN ('CO','CL') AND p.PayAmt<>0");
            sql.append(" AND NOT EXISTS (SELECT 1 FROM C_BankStatementLine l WHERE p.C_Payment_ID=l.C_Payment_ID AND l.StmtAmt <> 0)");
            sql.append("UNION ALL ");
            sql.append("SELECT db.DateDeposit AS DateTrx, NULL AS C_Payment_ID, db.C_DepositBatch_ID, db.DocumentNo, p.C_Currency_ID, c.ISO_Code, SUM(p.PayAmt) AS PayAmt,");
            sql.append(" SUM(currencyConvert(p.PayAmt,p.C_Currency_ID,ba.C_Currency_ID,p.DateAcct,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID)) AS ConvAmount, NULL As Name,");
            sql.append(" p.Processed, p.C_BankAccount_ID, p.C_DocType_ID, NULL AS TenderType, NULL AS R_AuthCode, NULL AS C_BPartner_ID ");
            sql.append(" FROM C_BankAccount ba");
            sql.append(" INNER JOIN C_DepositBatch db ON (db.C_BankAccount_ID=ba.C_BankAccount_ID)");
            sql.append(" INNER JOIN C_DepositBatchLine dbl ON (dbl.C_DepositBatch_ID = db.C_DepositBatch_ID)");
            sql.append(" INNER JOIN C_Payment_v p ON (p.C_Payment_ID=dbl.C_Payment_ID)");
            sql.append(" INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID)");
            sql.append(" WHERE db.DocStatus IN ('CO','CL') AND db.DepositAmt<>0");
            sql.append(" AND NOT EXISTS (SELECT 1 FROM C_BankStatementLine l WHERE p.C_Payment_ID=l.C_Payment_ID AND l.StmtAmt <> 0)");
            sql.append(" AND NOT EXISTS (SELECT 1 FROM C_BankStatementLine l WHERE db.C_DepositBatch_ID=l.C_DepositBatch_ID AND l.StmtAmt <> 0)");
            sql.append(" GROUP BY db.C_DepositBatch_ID,db.DocumentNo,p.C_Currency_ID, c.ISO_Code, db.DateDeposit, p.Processed, p.C_BankAccount_ID, p.C_DocType_ID ");
            sql.append(") SELECT DateTrx, C_Payment_ID, C_DepositBatch_ID, DocumentNo, C_Currency_ID, ISO_Code, PayAmt, ConvAmount, Name FROM Payments p ");
            sql.append(this.getSQLWhere(BPartner, DocumentNo, DateFrom, DateTo, AmtFrom, AmtTo, DocType, TenderType, AuthCode, Currency2, 0));
            sql.append(" ORDER BY DateTrx");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.getTrxName());
                    this.setParameters((PreparedStatement)pstmt, BankAccount, BPartner, DocumentNo, DateFrom, DateTo, AmtFrom, AmtTo, DocType, TenderType, AuthCode, Currency2, 0);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(7);
                        line.add(Boolean.FALSE);
                        line.add(rs.getTimestamp(1));
                        if (rs.getInt(2) > 0) {
                            line.add(new KeyNamePair(rs.getInt(2), rs.getString(4)));
                        } else {
                            line.add(null);
                        }
                        if (rs.getInt(3) > 0) {
                            line.add(new KeyNamePair(rs.getInt(3), rs.getString(4)));
                        } else {
                            line.add(null);
                        }
                        line.add(new KeyNamePair(rs.getInt(5), rs.getString(6)));
                        line.add(rs.getBigDecimal(7));
                        line.add(rs.getBigDecimal(8));
                        line.add(rs.getString(9));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, false);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, BigDecimal.class, true);
        miniTable.setColumnClass(6, BigDecimal.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        int C_BankStatement_ID = (Integer)this.getGridTab().getValue("C_BankStatement_ID");
        MBankStatement bs = (MBankStatement)MTable.get((Properties)Env.getCtx(), (int)392).getPO(C_BankStatement_ID, trxName);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(bs.toString());
        }
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                int C_Payment_ID = 0;
                int C_DepositBatch_ID = 0;
                Timestamp trxDate = (Timestamp)miniTable.getValueAt(i, 1);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                if (pp != null) {
                    C_Payment_ID = pp.getKey();
                }
                if ((pp = (KeyNamePair)miniTable.getValueAt(i, 3)) != null) {
                    C_DepositBatch_ID = pp.getKey();
                }
                pp = (KeyNamePair)miniTable.getValueAt(i, 4);
                int C_Currency_ID = pp.getKey();
                BigDecimal TrxAmt = (BigDecimal)miniTable.getValueAt(i, 6);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line Date=" + String.valueOf(trxDate) + ", Payment=" + C_Payment_ID + ", Currency=" + C_Currency_ID + ", Amt=" + String.valueOf(TrxAmt));
                }
                MBankStatementLine bsl = new MBankStatementLine(bs);
                bsl.setStatementLineDate(trxDate);
                if (C_Payment_ID > 0) {
                    bsl.setPayment((MPayment)MTable.get((Properties)Env.getCtx(), (int)335).getPO(C_Payment_ID, trxName));
                }
                if (C_DepositBatch_ID > 0) {
                    bsl.setC_DepositBatch_ID(C_DepositBatch_ID);
                }
                bsl.setTrxAmt(TrxAmt);
                bsl.setStmtAmt(TrxAmt);
                bsl.setC_Currency_ID(bs.getBankAccount().getC_Currency_ID());
                if (!bsl.save()) {
                    this.log.log(Level.SEVERE, "Line not created #" + i);
                }
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_Payment_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_DepositBatch_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        return columnNames;
    }

    @Override
    public void info(IMiniTable miniTable, IStatusBar statusBar) {
        DecimalFormat format = DisplayType.getNumberFormat((int)12);
        BigDecimal total = Env.ZERO;
        int rows = miniTable.getRowCount();
        int count = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                total = total.add((BigDecimal)miniTable.getValueAt(i, 5));
                ++count;
            }
            ++i;
        }
        statusBar.setStatusLine(String.valueOf(count) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + format.format(total));
    }
}

