/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import org.adempiere.webui.panel.AbstractMenuPanel;
import org.adempiere.webui.panel.MenuTreeFilterPanel;
import org.adempiere.webui.panel.MenuTreeSearchPanel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Toolbar;

public class MenuSearchPanel
extends AbstractMenuPanel {
    private static final long serialVersionUID = 5308522340852904168L;
    protected MenuTreeSearchPanel pnlSearch;
    private EventListener<Event> listener;

    public MenuSearchPanel(Component parent) {
        super(parent);
        this.setSclass("menu-search-panel-container");
    }

    @Override
    protected void init() {
        super.init();
        this.pnlSearch.initialise();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.createSearchPanel();
    }

    protected void createSearchPanel() {
        Toolbar toolbar = new Toolbar();
        toolbar.setMold("panel");
        this.appendChild((Component)toolbar);
        this.pnlSearch = new MenuTreeSearchPanel(this.getMenuTree());
        this.pnlSearch.setSclass("menu-search-panel");
        toolbar.appendChild((Component)this.pnlSearch);
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.listener != null) {
            try {
                EventQueue queue = EventQueues.lookup((String)"MENU_TREE_FILTER_CHECKED_QUEUE", (String)"desktop", (boolean)true);
                if (queue != null) {
                    queue.unsubscribe(this.listener);
                }
            }
            finally {
                this.listener = null;
            }
        }
    }

    @Override
    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (this.listener == null) {
            this.listener = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    Checkbox chk;
                    if (event.getName() == "onCheck" && (chk = (Checkbox)event.getData()) != null) {
                        if ("flatView".equals(chk.getId())) {
                            MenuTreeFilterPanel.toggleFlatView(MenuSearchPanel.this.getMenuTree(), chk);
                        } else {
                            MenuTreeFilterPanel.toggle(MenuSearchPanel.this.getMenuTree(), chk);
                        }
                        if (MenuSearchPanel.this.pnlSearch != null) {
                            MenuSearchPanel.this.pnlSearch.refreshSearchList();
                        }
                        MenuSearchPanel.this.getMenuTree().invalidate();
                    }
                }
            };
        }
        EventQueues.lookup((String)"MENU_TREE_FILTER_CHECKED_QUEUE", (String)"desktop", (boolean)true).subscribe(this.listener);
    }
}

