/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.beans.PropertyChangeEvent;
import java.util.Objects;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WRecordEditor;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class WRecordIDEditor
extends WRecordEditor<Integer> {
    public WRecordIDEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super(gridField, tableEditor, editorConfiguration);
    }

    @Override
    public void actionZoom() {
        int recordID;
        String s = this.tableIDValue != null ? String.valueOf(this.tableIDValue) : "";
        int tableID = s.length() > 0 ? Integer.parseInt(s) : 0;
        s = this.recordIDValue != null ? String.valueOf(this.recordIDValue) : "";
        int n = recordID = s.length() > 0 ? Integer.parseInt(s) : 0;
        if (tableID <= 0 || recordID < 0) {
            return;
        }
        if (!MRole.getDefault().isTableAccess(tableID, false)) {
            throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"AccessTableNoView"));
        }
        AEnv.zoom(tableID, recordID);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("FieldValue".equals(evt.getPropertyName())) {
            int tableID;
            int n = tableID = this.tableIDValue != null ? Integer.parseInt(String.valueOf(this.tableIDValue)) : 0;
            if (tableID > 0) {
                MTable table2 = MTable.get((int)tableID);
                int recordID = Integer.parseInt(Objects.toString(evt.getNewValue(), "-1"));
                if (tableID > 0 && recordID >= 0) {
                    table2.getPO(recordID, null);
                }
            }
            this.setValue(evt.getNewValue(), false);
        }
    }

    @Override
    public Integer toKeyValue(Object value) {
        return value != null ? Integer.valueOf(Integer.parseInt(String.valueOf(value))) : null;
    }

    @Override
    public boolean isUseUUIDKey() {
        return false;
    }

    @Override
    public String validateTableIdValue(int tableId) {
        MTable table2 = MTable.get((int)tableId);
        if (table2.isUUIDKeyTable()) {
            return "UUTableNotCompatibleWithRecordID";
        }
        if (!table2.isIDKeyTable()) {
            return "TableHasNoKeyColumn";
        }
        return null;
    }
}

