/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.adempiere.util.Callback;
import org.adempiere.util.IProcessUI;
import org.adempiere.webui.apps.BackgroundJobCallable;
import org.compiere.Adempiere;
import org.compiere.model.MPInstance;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class BackgroundJob {
    private ProcessInfo processInfo;
    private Properties context;
    private IProcessUI processUI;
    private String notificationType;
    private int initialDelay = 1000;

    private BackgroundJob(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public static BackgroundJob create(ProcessInfo processInfo) {
        return new BackgroundJob(processInfo);
    }

    public BackgroundJob withContext(Properties ctx) {
        this.context = ctx;
        return this;
    }

    public BackgroundJob withProcessUI(IProcessUI processUI) {
        this.processUI = processUI;
        return this;
    }

    public BackgroundJob withNotificationType(String notificationType) {
        this.notificationType = notificationType;
        return this;
    }

    public BackgroundJob withInitialDelay(int delay) {
        this.initialDelay = delay;
        return this;
    }

    public ScheduledFuture<ProcessInfo> run(Callback<Integer> createInstanceParaCallback) {
        ScheduledFuture<ProcessInfo> future;
        block7: {
            Properties ctx = this.context != null ? this.context : Env.getCtx();
            MPInstance instance = null;
            future = null;
            try {
                int AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
                int AD_User_ID = Env.getAD_User_ID((Properties)ctx);
                int count = new Query(ctx, "AD_PInstance", "Coalesce(AD_User_ID,0)=? AND IsProcessing='Y' AND IsRunAsJob='Y' ", null).setOnlyActiveRecords(true).setClient_ID().setParameters(new Object[]{AD_User_ID}).count();
                if (count >= MSysConfig.getIntValue((String)"BACKGROUND_JOB_MAX_PER_USER", (int)5, (int)AD_Client_ID)) {
                    throw new IllegalStateException(Msg.getMsg((Properties)ctx, (String)"BackgroundJobExceedMaxPerUser"));
                }
                count = new Query(ctx, "AD_PInstance", "IsProcessing='Y' AND IsRunAsJob='Y' ", null).setOnlyActiveRecords(true).setClient_ID().count();
                if (count >= MSysConfig.getIntValue((String)"BACKGROUND_JOB_MAX_PER_CLIENT", (int)10, (int)AD_Client_ID)) {
                    throw new IllegalStateException(Msg.getMsg((Properties)ctx, (String)"BackgroundJobExceedMaxPerClient"));
                }
                count = new Query(ctx, "AD_PInstance", "IsProcessing='Y' AND IsRunAsJob='Y' ", null).setOnlyActiveRecords(true).count();
                if (count >= MSysConfig.getIntValue((String)"BACKGROUND_JOB_MAX_IN_SYSTEM", (int)20)) {
                    throw new IllegalStateException(Msg.getMsg((Properties)ctx, (String)"BackgroundJobExceedMaxInSystem"));
                }
                instance = new MPInstance(ctx, this.processInfo.getAD_Process_ID(), this.processInfo.getTable_ID(), this.processInfo.getRecord_ID(), this.processInfo.getRecord_UU());
                instance.setIsRunAsJob(true);
                instance.setIsProcessing(true);
                instance.setNotificationType(this.getNotificationType(ctx));
                if (instance.getNotificationType() == null) {
                    instance.setNotificationType("N");
                }
                instance.setReportType(this.processInfo.getReportType());
                instance.setIsSummary(this.processInfo.isSummary());
                instance.setAD_Language_ID(this.processInfo.getLanguageID());
                if (this.processInfo.getSerializableObject() != null && this.processInfo.getSerializableObject() instanceof MPrintFormat) {
                    instance.setAD_PrintFormat_ID(((MPrintFormat)this.processInfo.getSerializableObject()).getAD_PrintFormat_ID());
                }
                instance.saveEx();
                this.processInfo.setAD_PInstance_ID(instance.getAD_PInstance_ID());
                createInstanceParaCallback.onCallback((Object)instance.getAD_PInstance_ID());
                MPInstance.publishChangedEvent((int)AD_User_ID);
                future = Adempiere.getThreadPoolExecutor().schedule(new BackgroundJobCallable(ctx, this.processInfo, this.processUI), (long)this.initialDelay, TimeUnit.MILLISECONDS);
                this.processInfo.setSummary(Msg.getMsg((Properties)ctx, (String)"BackgroundJobScheduled"));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.processInfo.setSummary(e.getLocalizedMessage());
                this.processInfo.setError(true);
                if (instance == null) break block7;
                instance.setIsProcessing(false);
                instance.saveEx();
            }
        }
        return future;
    }

    private String getNotificationType(Properties ctx) {
        if (this.notificationType != null) {
            return this.notificationType;
        }
        MUser user = MUser.get((Properties)ctx);
        String notificationType = user.getNotificationType();
        return notificationType;
    }

    public static List<MPInstance> getRunningJobForUser(int AD_User_ID) {
        List pis = new Query(Env.getCtx(), "AD_PInstance", "Coalesce(AD_User_ID,0)=? AND IsProcessing='Y' AND IsRunAsJob='Y'", null).setOnlyActiveRecords(true).setClient_ID().setParameters(new Object[]{AD_User_ID}).setOrderBy("Updated DESC").list();
        return pis;
    }
}

