/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.adempiere.base.Core;
import org.adempiere.model.MTabCustomization;
import org.adempiere.util.Callback;
import org.adempiere.util.GridRowCtx;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.adwindow.DetailPane;
import org.adempiere.webui.adwindow.GridTabRowRenderer;
import org.adempiere.webui.adwindow.GridTableListModel;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.adwindow.IFieldEditorContainer;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.util.SortComparator;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.MSysConfig;
import org.compiere.model.StateChangeEvent;
import org.compiere.model.StateChangeListener;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.lang.Library;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Div;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Paging;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Row;
import org.zkoss.zul.Vlayout;

public class GridView
extends Vlayout
implements EventListener<Event>,
IdSpace,
IFieldEditorContainer,
StateChangeListener {
    private static final String ON_POST_SELECTED_ROW_CHANGED_EVENT = "onPostSelectedRowChanged";
    public static final String ZERO_PX_WIDTH = "0px";
    private static final String GRID_VIEW_GRID_FIELD_INDEX = "gridView.gridField.index";
    public static final String COLUMN_WIDTH_ORIGINAL = "column.width.original";
    private static final String COLUMN_HFLEX_ORIGINAL = "column.hflex.original";
    private static final int MIN_COLUMN_MOBILE_WIDTH = 100;
    private static final long serialVersionUID = 3995829393137424527L;
    private static final String HEADER_GRID_STYLE = "border: none; margin:0; padding: 0;";
    private static final int DEFAULT_DETAIL_PAGE_SIZE = 10;
    private static final int DEFAULT_MOBILE_PAGE_SIZE = 20;
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int MIN_COLUMN_WIDTH = 100;
    private static final int MAX_COLUMN_WIDTH = 300;
    private static final int MIN_COMBOBOX_WIDTH = 160;
    private static final int MIN_NUMERIC_COL_WIDTH = 120;
    private static final String ATTR_ON_POST_SELECTED_ROW_CHANGED = "org.adempiere.webui.adwindow.GridView.onPostSelectedRowChanged";
    private static CLogger s_log = CLogger.getCLogger(GridView.class);
    private Grid listbox = null;
    private int pageSize = 20;
    private GridField[] gridFields;
    private AbstractTableModel tableModel;
    private int numColumns = 5;
    private int windowNo;
    private GridTab gridTab;
    private boolean init;
    private GridTableListModel listModel;
    private Paging paging;
    private GridTabRowRenderer renderer;
    private Div gridFooter;
    private boolean modeless = true;
    private String columnOnClick;
    private AbstractADWindowContent windowPanel;
    private boolean refreshing;
    private Map<Integer, String> columnWidthMap;
    private boolean detailPaneMode;
    protected Checkbox selectAll;
    protected boolean isHasCustomizeData = false;
    private boolean showCurrentRowIndicatorColumn = true;
    private String m_isAutoHideEmptyColumn;
    private Menupopup gridColumnMenuPopup;
    public static final String ATTR_VALUE_MENU_ITEM_FROZEN = "Frozen";
    public static final String MENU_ITEM_FROZEN_LABEL = "FrozenColumnContextMenuLabel";
    public static final String ATTR_VALUE_MENU_ITEM_RESET_FROZEN = "Reset Frozen";
    public static final String MENU_ITEM_RESET_FROZEN_LABEL = "ResetFrozenColumnContextMenuLabel";
    public static final String ATTR_NAME_CONTEXT_MENU_COLUMN = "contextMenuColumn";
    public static final String ATTR_NAME_GRID_VIEW_CONTEXT_MENU_POPUP = "gridViewContextMenuPopup";
    public static final EventListener<? extends Event> listener = event -> {
        Menuitem menuItem = (Menuitem)event.getTarget();
        Menupopup menupopup = (Menupopup)menuItem.getParent();
        Column contextMenuColumn = (Column)menupopup.getAttribute(ATTR_NAME_CONTEXT_MENU_COLUMN);
        org.zkoss.zul.Grid grid = contextMenuColumn.getGrid();
        int frozenColumns = -1;
        String valueIdentifyMenuItem = menuItem.getValue();
        if (ATTR_VALUE_MENU_ITEM_FROZEN.equals(valueIdentifyMenuItem)) {
            frozenColumns = grid.getColumns().getChildren().indexOf(contextMenuColumn) + 1;
        } else if (ATTR_VALUE_MENU_ITEM_RESET_FROZEN.equals(valueIdentifyMenuItem)) {
            frozenColumns = 2;
        }
        Frozen frozen = grid.getFrozen();
        if (frozenColumns != -1 && frozen != null) {
            frozen.setColumns(frozenColumns);
        }
    };

    public GridView() {
        this(0);
    }

    public GridView(int windowNo) {
        this.windowNo = windowNo;
        this.setId("gridView");
        this.createListbox();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this, "1");
        this.gridFooter = new Div();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.gridFooter, "0");
        if (ClientInfo.isMobile()) {
            this.pageSize = MSysConfig.getIntValue((String)"ZK_MOBILE_PAGING_SIZE", (int)20, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            String limit = Library.getProperty((String)"org.zkoss.zul.grid.DataLoader.limit");
            if (limit == null || !limit.equals(Integer.toString(this.pageSize))) {
                Library.setProperty((String)"org.zkoss.zul.grid.DataLoader.limit", (String)Integer.toString(this.pageSize));
            }
        } else {
            this.pageSize = MSysConfig.getIntValue((String)"ZK_PAGING_SIZE", (int)20, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            String limit = Library.getProperty((String)"org.zkoss.zul.grid.DataLoader.limit");
            if (limit == null || !limit.equals(Integer.toString(this.pageSize))) {
                Library.setProperty((String)"org.zkoss.zul.grid.DataLoader.limit", (String)Integer.toString(this.pageSize));
            }
        }
        this.modeless = ClientInfo.isMobile() ? MSysConfig.getBooleanValue((String)"ZK_GRID_MOBILE_EDIT_MODELESS", (boolean)false) && MSysConfig.getBooleanValue((String)"ZK_GRID_MOBILE_EDITABLE", (boolean)false) : MSysConfig.getBooleanValue((String)"ZK_GRID_EDIT_MODELESS", (boolean)true);
        this.appendChild((Component)this.listbox);
        this.appendChild((Component)this.gridFooter);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this, "true");
        this.setStyle(HEADER_GRID_STYLE);
        this.gridFooter.setStyle(HEADER_GRID_STYLE);
        this.addEventListener("onSelectRow", this);
        this.addEventListener("onCustomizeGrid", this);
    }

    protected void createListbox() {
        this.listbox = new Grid();
        this.listbox.setSizedByContent(false);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.listbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.listbox, "1");
        this.listbox.setSclass("adtab-grid");
        this.listbox.setEmptyMessage(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing")));
    }

    public void setDetailPaneMode(boolean detailPaneMode, GridTab gridTab) {
        if (this.detailPaneMode != detailPaneMode) {
            this.detailPaneMode = detailPaneMode;
            this.pageSize = detailPaneMode ? this.getDetailPageSize(gridTab) : MSysConfig.getIntValue((String)"ZK_PAGING_SIZE", (int)20, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            this.updatePaging();
        }
    }

    private int getDetailPageSize(GridTab gridTab) {
        int size = 10;
        String pageDetailSizes = MSysConfig.getValue((String)"ZK_PAGING_DETAIL_SIZE", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (Util.isEmpty((String)pageDetailSizes, (boolean)true)) {
            return size;
        }
        String[] stringArray = pageDetailSizes.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pageDetailSize = stringArray[n2];
            String[] parts = pageDetailSize.split(":");
            if (parts.length < 1 || parts.length > 2) {
                s_log.warning("Misconfiguration of ZK_PAGING_DETAIL_SIZE - cannot split : in -> " + pageDetailSize);
                return size;
            }
            String sizeToParse = null;
            if (parts.length == 1) {
                sizeToParse = parts[0];
            } else {
                String tab = parts[0];
                if (tab.equalsIgnoreCase(String.valueOf(gridTab.getAD_Tab_ID())) || tab.equalsIgnoreCase(String.valueOf(gridTab.getAD_Tab_UU())) || tab.equalsIgnoreCase(String.valueOf(gridTab.getTableName()))) {
                    sizeToParse = parts[1];
                }
            }
            if (sizeToParse != null) {
                int sizeParsed = -1;
                try {
                    sizeParsed = Integer.valueOf(sizeToParse);
                }
                catch (NumberFormatException numberFormatException) {
                    s_log.warning("Misconfiguration of ZK_PAGING_DETAIL_SIZE - cannot parse as integer -> " + sizeToParse);
                    return size;
                }
                if (sizeParsed > 0) {
                    size = sizeParsed;
                    if (parts.length > 1) break;
                }
            }
            ++n2;
        }
        return size;
    }

    public boolean isDetailPaneMode() {
        return this.detailPaneMode;
    }

    private void updatePaging() {
        if (this.paging != null && this.paging.getPageSize() != this.pageSize) {
            this.paging.setPageSize(this.pageSize);
            this.updateModel();
            if (this.paging.getPageCount() > 1) {
                this.showPagingControl();
            } else {
                this.hidePagingControl();
            }
        }
    }

    public void init(GridTab gridTab) {
        if (this.init) {
            return;
        }
        if (this.gridTab != null) {
            this.gridTab.removeStateChangeListener((StateChangeListener)this);
        }
        this.setupFields(gridTab);
        this.setupColumns();
        this.render();
        if (this.listbox.getFrozen() != null) {
            this.listbox.getFrozen().setWidgetOverride("syncScroll", "function (){idempiere.syncScrollFrozen(this);}");
        }
        this.updateListIndex();
        this.autoHideEmptyColumns();
        this.init = true;
        this.showRecordsCount();
    }

    private void showRecordsCount() {
        Component parent = this.getParent();
        while (parent != null) {
            if (parent instanceof DetailPane) {
                DetailPane p = (DetailPane)parent;
                if (p.getSelectedADTabpanel() == null || p.getSelectedADTabpanel().getGridTab() != this.gridTab) break;
                p.setStatusMessage(this.tableModel.getRowCount() + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Records"), false);
                break;
            }
            parent = parent.getParent();
        }
    }

    private void setupFields(GridTab gridTab) {
        this.gridTab = gridTab;
        gridTab.addStateChangeListener((StateChangeListener)this);
        this.tableModel = gridTab.getTableModel();
        this.columnWidthMap = new HashMap<Integer, String>();
        GridField[] tmpFields = ((GridTable)this.tableModel).getFields();
        MTabCustomization tabCustomization = MTabCustomization.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()), (int)gridTab.getAD_Tab_ID(), null);
        boolean bl = this.isHasCustomizeData = tabCustomization != null && tabCustomization.getAD_Tab_Customization_ID() > 0 && tabCustomization.getCustom() != null && tabCustomization.getCustom().trim().length() > 0;
        if (this.isHasCustomizeData) {
            String custom = tabCustomization.getCustom().trim();
            String[] customComponent = custom.split(";");
            String[] fieldIds = customComponent[0].split("[,]");
            ArrayList<GridField> fieldList = new ArrayList<GridField>();
            String[] stringArray = fieldIds;
            int n = fieldIds.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldIdStr = stringArray[n2];
                if ((fieldIdStr = fieldIdStr.trim()).length() != 0) {
                    int AD_Field_ID = Integer.parseInt(fieldIdStr);
                    GridField[] gridFieldArray = tmpFields;
                    int n3 = tmpFields.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        GridField gridField = gridFieldArray[n4];
                        if (gridField.getAD_Field_ID() == AD_Field_ID) {
                            if (!gridField.isDisplayedGrid() && !gridField.isDisplayed() || gridField.isToolbarOnlyButton()) break;
                            fieldList.add(gridField);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            this.gridFields = fieldList.toArray(new GridField[0]);
            if (customComponent.length == 2) {
                String[] widths = customComponent[1].split("[,]");
                int i = 0;
                while (i < this.gridFields.length && i < widths.length) {
                    this.columnWidthMap.put(this.gridFields[i].getAD_Field_ID(), widths[i]);
                    ++i;
                }
            }
            this.m_isAutoHideEmptyColumn = tabCustomization.getIsAutoHideEmptyColumn();
        } else {
            ArrayList<GridField> gridFieldList = new ArrayList<GridField>();
            int max = 0;
            if (ClientInfo.isMobile()) {
                max = MSysConfig.getIntValue((String)"ZK_GRID_MOBILE_MAX_COLUMNS", (int)10, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            }
            GridField[] gridFieldArray = tmpFields;
            int n = tmpFields.length;
            int n5 = 0;
            while (n5 < n) {
                GridField field = gridFieldArray[n5];
                if (field.isDisplayedGrid() && !field.isToolbarOnlyButton()) {
                    gridFieldList.add(field);
                }
                if (max > 0 && gridFieldList.size() >= max) break;
                ++n5;
            }
            Collections.sort(gridFieldList, new Comparator<GridField>(){

                @Override
                public int compare(GridField o1, GridField o2) {
                    return o1.getSeqNoGrid() - o2.getSeqNoGrid();
                }
            });
            this.gridFields = new GridField[gridFieldList.size()];
            gridFieldList.toArray(this.gridFields);
        }
        this.numColumns = this.gridFields.length;
    }

    public boolean isInit() {
        return this.init;
    }

    public void activate(GridTab gridTab) {
        if (!this.isInit()) {
            this.init(gridTab);
        } else {
            this.showRecordsCount();
        }
        if (this.isVisible()) {
            this.listbox.invalidate();
        }
    }

    public void refresh(GridTab gridTab) {
        if (this.gridTab != gridTab || !this.isInit()) {
            this.init = false;
            this.init(gridTab);
        } else {
            this.refreshing = true;
            this.listbox.setModel((ListModel)this.listModel);
            this.updateListIndex();
            this.refreshing = false;
            if (gridTab.getRowCount() == 0 && this.selectAll.isChecked()) {
                this.selectAll.setChecked(false);
            }
        }
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public void updateListIndex() {
        if (this.gridTab == null || !this.gridTab.isOpen()) {
            return;
        }
        this.updateEmptyMessage();
        int rowIndex = this.gridTab.getCurrentRow();
        if (this.pageSize > 0) {
            int pgNo;
            if (this.paging.getTotalSize() != this.gridTab.getRowCount()) {
                this.paging.setTotalSize(this.gridTab.getRowCount());
            }
            if (this.paging.getPageCount() > 1 && !this.gridFooter.isVisible()) {
                this.showPagingControl();
            }
            int pgIndex = rowIndex >= 0 ? rowIndex % this.pageSize : 0;
            int n = pgNo = rowIndex >= 0 ? (rowIndex - pgIndex) / this.pageSize : 0;
            if (this.listModel.getPage() != pgNo) {
                this.listModel.setPage(pgNo);
                if (this.renderer.isEditing()) {
                    this.renderer.stopEditing(false);
                }
            } else {
                if (rowIndex == this.renderer.getCurrentRowIndex()) {
                    if (this.modeless && !this.renderer.isEditing()) {
                        this.echoOnPostSelectedRowChanged();
                    }
                    return;
                }
                if (this.renderer.isEditing()) {
                    int editingPgIndex;
                    int editingPgNo;
                    this.renderer.stopEditing(false);
                    int editingRow = this.renderer.getCurrentRowIndex();
                    if (editingRow >= 0 && (editingPgNo = (editingRow - (editingPgIndex = editingRow % this.pageSize)) / this.pageSize) == pgNo) {
                        this.listModel.updateComponent(this.renderer.getCurrentRowIndex() % this.pageSize);
                    }
                }
            }
            if (this.paging.getActivePage() != pgNo) {
                this.paging.setActivePage(pgNo);
            }
            if (this.paging.getPageCount() == 1) {
                this.hidePagingControl();
            } else {
                this.showPagingControl();
            }
            if (rowIndex >= 0 && pgIndex >= 0) {
                this.echoOnPostSelectedRowChanged();
            }
        } else if (rowIndex >= 0) {
            this.echoOnPostSelectedRowChanged();
        }
    }

    private void hidePagingControl() {
        if (this.gridFooter.isVisible()) {
            this.gridFooter.setVisible(false);
        }
    }

    private void showPagingControl() {
        if (!this.gridFooter.isVisible()) {
            this.gridFooter.setVisible(true);
        }
    }

    protected void echoOnPostSelectedRowChanged() {
        if (this.getAttribute(ATTR_ON_POST_SELECTED_ROW_CHANGED) == null) {
            this.setAttribute(ATTR_ON_POST_SELECTED_ROW_CHANGED, Boolean.TRUE);
            Events.echoEvent((String)ON_POST_SELECTED_ROW_CHANGED_EVENT, (Component)this, null);
        }
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void clear() {
        this.getChildren().clear();
    }

    private void setupColumns() {
        if (this.init) {
            return;
        }
        org.adempiere.webui.component.Columns columns = new org.adempiere.webui.component.Columns();
        if (!ClientInfo.isMobile()) {
            Frozen frozen = new Frozen();
            frozen.setColumns(2);
            this.listbox.appendChild((Component)frozen);
        }
        Column selection = new Column();
        selection.setHeight("2em");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)selection, "22px");
        try {
            selection.setSort("none");
        }
        catch (Exception exception) {}
        selection.setStyle("border-right: none");
        this.selectAll = new Checkbox();
        selection.appendChild((Component)this.selectAll);
        this.selectAll.setId("selectAll");
        this.selectAll.addEventListener("onCheck", this);
        columns.appendChild((Component)selection);
        if (ClientInfo.isMobile()) {
            this.showCurrentRowIndicatorColumn = MSysConfig.getBooleanValue((String)"ZK_GRID_MOBILE_SHOW_CURRENT_ROW_INDICATOR", (boolean)false);
        }
        if (this.showCurrentRowIndicatorColumn) {
            Column indicator = new Column();
            indicator.setHeight("2em");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)indicator, "22px");
            try {
                indicator.setSort("none");
            }
            catch (Exception exception) {}
            indicator.setStyle("border-left: none");
            columns.appendChild((Component)indicator);
        }
        this.listbox.appendChild((Component)columns);
        columns.setSizable(true);
        columns.setColumnsgroup(false);
        if (this.gridColumnMenuPopup != null && this.gridColumnMenuPopup.getParent() != null) {
            this.gridColumnMenuPopup.detach();
        }
        this.gridColumnMenuPopup = new Menupopup();
        this.appendChild((Component)this.gridColumnMenuPopup);
        this.gridColumnMenuPopup.addEventListener("onOpen", event -> {
            OpenEvent openEvent = (OpenEvent)event;
            if (openEvent.isOpen()) {
                openEvent.getTarget().setAttribute(ATTR_NAME_CONTEXT_MENU_COLUMN, (Object)openEvent.getReference());
            } else {
                openEvent.getTarget().removeAttribute(ATTR_NAME_CONTEXT_MENU_COLUMN);
            }
        });
        Menuitem frozenMenuItem = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)MENU_ITEM_FROZEN_LABEL, (boolean)true));
        frozenMenuItem.setValue(ATTR_VALUE_MENU_ITEM_FROZEN);
        frozenMenuItem.setIconSclass("z-icon-lock");
        frozenMenuItem.addEventListener("onClick", listener);
        this.gridColumnMenuPopup.appendChild((Component)frozenMenuItem);
        Menuitem resetFrozenMenuItem = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)MENU_ITEM_RESET_FROZEN_LABEL, (boolean)true));
        resetFrozenMenuItem.setValue(ATTR_VALUE_MENU_ITEM_RESET_FROZEN);
        resetFrozenMenuItem.setIconSclass("z-icon-mail-reply");
        resetFrozenMenuItem.addEventListener("onClick", listener);
        this.gridColumnMenuPopup.appendChild((Component)resetFrozenMenuItem);
        HashMap<Integer, String> colnames = new HashMap<Integer, String>();
        int index = 0;
        int i = 0;
        while (i < this.numColumns) {
            if ((this.isHasCustomizeData || this.gridFields[i].isDisplayedGrid()) && !this.gridFields[i].isToolbarOnlyButton()) {
                colnames.put(index, this.gridFields[i].getHeader());
                ++index;
                Column column = new Column();
                column.setAttribute(GRID_VIEW_GRID_FIELD_INDEX, (Object)i);
                column.setHeight("2em");
                int colindex = this.tableModel.findColumn(this.gridFields[i].getColumnName());
                column.setSortAscending((Comparator)new SortComparator(colindex, true, Env.getLanguage((Properties)Env.getCtx())));
                column.setSortDescending((Comparator)new SortComparator(colindex, false, Env.getLanguage((Properties)Env.getCtx())));
                if (this.gridFields[i].isFieldOnly()) {
                    column.setLabel("");
                } else {
                    column.setLabel(this.gridFields[i].getHeader());
                }
                if (this.columnWidthMap != null && this.columnWidthMap.get(this.gridFields[i].getAD_Field_ID()) != null && !this.columnWidthMap.get(this.gridFields[i].getAD_Field_ID()).equals("")) {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)column, this.columnWidthMap.get(this.gridFields[i].getAD_Field_ID()));
                } else if (this.gridFields[i].getDisplayType() == 20) {
                    if (i > 0) {
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
                    } else {
                        estimatedWidth = 60;
                        headerWidth = (this.gridFields[i].getHeader().length() + 2) * 8;
                        if (headerWidth > estimatedWidth) {
                            estimatedWidth = headerWidth;
                        }
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, estimatedWidth + "px");
                    }
                } else if (DisplayType.isNumeric((int)this.gridFields[i].getDisplayType()) && "Line".equals(this.gridFields[i].getColumnName())) {
                    if (i > 0) {
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
                    } else {
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "60px");
                    }
                } else {
                    estimatedWidth = 0;
                    estimatedWidth = DisplayType.isNumeric((int)this.gridFields[i].getDisplayType()) ? 120 : (DisplayType.isLookup((int)this.gridFields[i].getDisplayType()) ? 160 : (DisplayType.isText((int)this.gridFields[i].getDisplayType()) ? this.gridFields[i].getDisplayLength() * 8 : 100));
                    headerWidth = (this.gridFields[i].getHeader().length() + 2) * 8;
                    if (headerWidth > estimatedWidth) {
                        estimatedWidth = headerWidth;
                    }
                    if (i > 0 && !ClientInfo.isMobile()) {
                        if (DisplayType.isLookup((int)this.gridFields[i].getDisplayType())) {
                            if (headerWidth > 160) {
                                ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
                            }
                        } else if (DisplayType.isNumeric((int)this.gridFields[i].getDisplayType())) {
                            if (headerWidth > 120) {
                                ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
                            }
                        } else if (!DisplayType.isText((int)this.gridFields[i].getDisplayType()) && headerWidth > 100) {
                            ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
                        }
                    }
                    if (!"min".equals(column.getHflex())) {
                        if (ClientInfo.isMobile() && ClientInfo.get() != null && ClientInfo.get().desktopWidth <= 700) {
                            int maxWidth = ClientInfo.get().desktopWidth / 5;
                            if (maxWidth < 100) {
                                maxWidth = 100;
                            }
                            if (estimatedWidth > maxWidth) {
                                estimatedWidth = maxWidth;
                            }
                        } else if (estimatedWidth > 300) {
                            estimatedWidth = 300;
                        } else if (estimatedWidth < 100) {
                            estimatedWidth = 100;
                        }
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, Integer.toString(estimatedWidth) + "px");
                    }
                }
                columns.appendChild((Component)column);
                column.setContext((Popup)this.gridColumnMenuPopup);
            }
            ++i;
        }
    }

    private void render() {
        this.updateEmptyMessage();
        this.listbox.addEventListener("onClick", this);
        this.updateModel();
        if (this.pageSize > 0) {
            this.paging = new Paging();
            this.paging.setPageSize(this.pageSize);
            this.paging.setTotalSize(this.tableModel.getRowCount());
            this.paging.setDetailed(true);
            this.paging.setId("paging");
            this.gridFooter.appendChild((Component)this.paging);
            this.paging.addEventListener("onPaging", (EventListener)this);
            this.renderer.setPaging(this.paging);
            if (this.paging.getPageCount() == 1) {
                this.hidePagingControl();
            } else {
                this.showPagingControl();
            }
            this.positionPagingControl();
        } else {
            this.hidePagingControl();
        }
    }

    protected void autoHideEmptyColumns() {
        int index;
        Object value;
        if (!this.isAutoHideEmptyColumns()) {
            return;
        }
        String attr = this.listbox.getUuid() + ".autoHideEmptyColumns";
        if (Executions.getCurrent().getAttribute(attr) != null) {
            return;
        }
        Executions.getCurrent().setAttribute(attr, (Object)Boolean.TRUE);
        Columns columns = this.listbox.getColumns();
        List columnList = columns.getChildren();
        int rowCount = this.listModel.getSize();
        GridField[] gridTabFields = this.gridTab.getFields();
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        if (rowCount > 0) {
            block0: for (Column column : columnList) {
                value = column.getAttribute(GRID_VIEW_GRID_FIELD_INDEX);
                if (value == null || !(value instanceof Integer)) continue;
                index = (Integer)value;
                int i = 0;
                while (i < gridTabFields.length) {
                    if (this.gridFields[index].getAD_Field_ID() == gridTabFields[i].getAD_Field_ID()) {
                        indexMap.put(index, i);
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        for (Column column : columnList) {
            value = column.getAttribute(GRID_VIEW_GRID_FIELD_INDEX);
            if (value == null || !(value instanceof Integer)) continue;
            index = (Integer)value;
            boolean hideColumn = false;
            if (rowCount > 0) {
                int valueIndex = (Integer)indexMap.get(index);
                hideColumn = true;
                int i = 0;
                while (i < rowCount) {
                    String display;
                    Object[] values = (Object[])this.listModel.getElementAt(i);
                    int rowIndex = i;
                    if (this.paging != null && this.paging.getPageSize() > 0) {
                        rowIndex = this.paging.getActivePage() * this.paging.getPageSize() + rowIndex;
                    }
                    if (!Util.isEmpty((String)(display = this.renderer.getDisplayTextWithEditorCheck(values[valueIndex], this.gridFields[index], rowIndex)), (boolean)true)) {
                        hideColumn = false;
                        break;
                    }
                    if (this.gridTab.getCurrentRow() == rowIndex && this.gridTab.isNew() && this.gridFields[index].isEditable(false) && (this.gridFields[index].isMandatory(false) || !Util.isEmpty((String)this.gridFields[index].getVO().MandatoryLogic) || !Util.isEmpty((String)this.gridFields[index].getVO().DisplayLogic) || !Util.isEmpty((String)this.gridFields[index].getVO().ReadOnlyLogic))) {
                        hideColumn = false;
                        break;
                    }
                    ++i;
                }
            }
            if (hideColumn && column.isVisible() && !ZERO_PX_WIDTH.equals(column.getWidth())) {
                String width = column.getWidth();
                String hflex = column.getHflex();
                if (!Util.isEmpty((String)hflex, (boolean)true)) {
                    column.setAttribute(COLUMN_HFLEX_ORIGINAL, (Object)hflex);
                    column.setHflex(null);
                }
                column.setWidth(ZERO_PX_WIDTH);
                if (column.getAttribute(COLUMN_WIDTH_ORIGINAL) != null) continue;
                column.setAttribute(COLUMN_WIDTH_ORIGINAL, (Object)(width != null ? width : ""));
                continue;
            }
            if (hideColumn || !column.isVisible() || !ZERO_PX_WIDTH.equals(column.getWidth()) || column.getAttribute(COLUMN_WIDTH_ORIGINAL) == null) continue;
            if (column.getAttribute(COLUMN_HFLEX_ORIGINAL) != null) {
                String hflex = (String)column.getAttribute(COLUMN_HFLEX_ORIGINAL);
                column.setWidth(null);
                column.setHflex(hflex);
                continue;
            }
            column.setWidth((String)column.getAttribute(COLUMN_WIDTH_ORIGINAL));
        }
    }

    private boolean isAutoHideEmptyColumns() {
        if (!Util.isEmpty((String)this.m_isAutoHideEmptyColumn, (boolean)true)) {
            return "Y".equalsIgnoreCase(this.m_isAutoHideEmptyColumn);
        }
        return MSysConfig.getBooleanValue((String)"ZK_GRID_AUTO_HIDE_EMPTY_COLUMNS", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    }

    private void updateEmptyMessage() {
        if (this.gridTab.getRowCount() == 0) {
            this.listbox.setEmptyMessage(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"FindZeroRecords")));
        } else {
            this.listbox.setEmptyMessage(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing")));
        }
    }

    private void updateModel() {
        if (this.listModel != null) {
            ((GridTable)this.tableModel).removeTableModelListener((TableModelListener)this.listModel);
        }
        this.listModel = new GridTableListModel((GridTable)this.tableModel, this.windowNo);
        this.listModel.setPageSize(this.pageSize);
        if (this.renderer != null && this.renderer.isEditing()) {
            this.renderer.stopEditing(false);
        }
        this.renderer = new GridTabRowRenderer(this.gridTab, this.windowNo);
        this.renderer.setGridPanel(this);
        this.renderer.setADWindowPanel(this.windowPanel);
        if (this.pageSize > 0 && this.paging != null) {
            this.renderer.setPaging(this.paging);
        }
        this.listbox.setModel((ListModel)this.listModel);
        if (this.listbox.getRows() == null) {
            this.listbox.appendChild((Component)new Rows());
        }
        this.listbox.setRowRenderer(this.renderer);
    }

    public void deactivate() {
        if (this.renderer != null && this.renderer.isEditing()) {
            this.renderer.stopEditing(true);
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event == null) {
            return;
        }
        if (event.getTarget() == this.listbox && "onClick".equals(event.getName())) {
            Object data = event.getData();
            Row row = null;
            String columnName = null;
            if (data != null && data instanceof Component) {
                if (data instanceof Row) {
                    row = (Row)data;
                } else {
                    AbstractComponent cmp = (AbstractComponent)data;
                    if (cmp.getParent() instanceof Row) {
                        row = (Row)cmp.getParent();
                        columnName = (String)cmp.getAttribute("columnName");
                    }
                }
            }
            if (row != null) {
                if (row == this.renderer.getCurrentRow()) {
                    if (!this.renderer.isEditing()) {
                        this.renderer.editCurrentRow();
                        if (columnName != null && columnName.trim().length() > 0) {
                            this.setFocusToField(columnName);
                        } else {
                            this.renderer.focusToFirstEditor();
                        }
                    }
                } else {
                    int index = this.listbox.getRows().getChildren().indexOf(row);
                    if (index >= 0) {
                        this.columnOnClick = columnName;
                        this.onSelectedRowChange(index);
                    }
                }
            }
            event.stopPropagation();
        } else if (event.getTarget() == this.paging) {
            int pgNo = this.paging.getActivePage();
            if (pgNo != this.listModel.getPage()) {
                this.listModel.setPage(pgNo);
                this.onSelectedRowChange(0);
                this.gridTab.clearSelection();
                this.invalidateGridView();
            }
        } else if (event.getTarget() == this.selectAll) {
            this.toggleSelectionForAll(this.selectAll.isChecked());
        } else if (event.getName().equals("onSelectRow")) {
            Checkbox checkbox = (Checkbox)((Object)event.getData());
            int rowIndex = (Integer)checkbox.getAttribute("grid.row.index");
            if (checkbox.isChecked()) {
                this.gridTab.addToSelection(rowIndex);
                if (!this.selectAll.isChecked() && this.isAllSelected()) {
                    this.selectAll.setChecked(true);
                }
            } else {
                this.gridTab.removeFromSelection(rowIndex);
                if (this.selectAll.isChecked()) {
                    this.selectAll.setChecked(false);
                }
            }
        } else if (event.getName().equals("onCustomizeGrid")) {
            this.reInit();
        }
    }

    private Center findCenter(GridView gridView) {
        if (gridView == null) {
            return null;
        }
        Component p = gridView.getParent();
        while (p != null) {
            if (p instanceof Center) {
                return (Center)p;
            }
            p = p.getParent();
        }
        return null;
    }

    private boolean isAllSelected() {
        org.zkoss.zul.Rows rows = this.listbox.getRows();
        List childs = rows.getChildren();
        boolean all = false;
        for (Component comp : childs) {
            Row row = (Row)comp;
            Component firstChild = row.getFirstChild();
            if (firstChild instanceof Cell) {
                firstChild = firstChild.getFirstChild();
            }
            if (!(firstChild instanceof Checkbox)) continue;
            Checkbox checkbox = (Checkbox)firstChild;
            if (!checkbox.isChecked()) {
                return false;
            }
            all = true;
        }
        return all;
    }

    private void toggleSelectionForAll(boolean b) {
        org.zkoss.zul.Rows rows = this.listbox.getRows();
        List childs = rows.getChildren();
        for (Component comp : childs) {
            Row row = (Row)comp;
            Component firstChild = row.getFirstChild();
            if (firstChild instanceof Cell) {
                firstChild = firstChild.getFirstChild();
            }
            if (!(firstChild instanceof Checkbox)) continue;
            Checkbox checkbox = (Checkbox)firstChild;
            checkbox.setChecked(b);
            int rowIndex = (Integer)checkbox.getAttribute("grid.row.index");
            if (b) {
                this.gridTab.addToSelection(rowIndex);
                continue;
            }
            this.gridTab.removeFromSelection(rowIndex);
        }
    }

    private void onSelectedRowChange(int index) {
        if (this.updateModelIndex(index)) {
            this.updateListIndex();
        }
    }

    public void onPostSelectedRowChanged() {
        int rowIndex;
        this.removeAttribute(ATTR_ON_POST_SELECTED_ROW_CHANGED);
        if (this.listbox.getRows() == null || this.listbox.getRows().getChildren().isEmpty()) {
            return;
        }
        int n = rowIndex = this.gridTab.isOpen() ? this.gridTab.getCurrentRow() : -1;
        if (rowIndex >= 0 && this.pageSize > 0) {
            int pgIndex = rowIndex >= 0 ? rowIndex % this.pageSize : 0;
            Row row = (Row)this.listbox.getRows().getChildren().get(pgIndex);
            if (!this.isRowRendered(row, pgIndex)) {
                this.listbox.renderRow(row);
            } else {
                this.renderer.setCurrentRow(row);
            }
            if (this.modeless && !this.renderer.isEditing()) {
                this.renderer.editCurrentRow();
                if (this.columnOnClick != null && this.columnOnClick.trim().length() > 0) {
                    this.setFocusToField(this.columnOnClick);
                    this.columnOnClick = null;
                } else {
                    this.focusToFirstEditorIfNotDetailTab();
                }
            } else {
                this.focusToRow(row);
            }
        } else if (rowIndex >= 0) {
            Row row = (Row)this.listbox.getRows().getChildren().get(rowIndex);
            if (!this.isRowRendered(row, rowIndex)) {
                this.listbox.renderRow(row);
            } else {
                this.renderer.setCurrentRow(row);
            }
            if (this.modeless && !this.renderer.isEditing()) {
                this.renderer.editCurrentRow();
                if (this.columnOnClick != null && this.columnOnClick.trim().length() > 0) {
                    this.setFocusToField(this.columnOnClick);
                    this.columnOnClick = null;
                } else {
                    this.renderer.focusToFirstEditor();
                }
            } else {
                this.focusToRow(row);
            }
        }
    }

    private void focusToFirstEditorIfNotDetailTab() {
        ADWindow adwindow;
        ADTabpanel adtabpanel = null;
        boolean setFocus = true;
        Component parent = this.listbox.getParent();
        while (parent != null) {
            if (parent instanceof ADTabpanel) {
                adtabpanel = (ADTabpanel)parent;
                break;
            }
            parent = parent.getParent();
        }
        if (adtabpanel != null && (adwindow = ADWindow.findADWindow(adtabpanel)) != null) {
            IADTabpanel selectedADTabpanel = adwindow.getADWindowContent().getADTab().getSelectedTabpanel();
            IADTabpanel selectedADDetailTabpanel = null;
            if (selectedADTabpanel.getDetailPane() != null) {
                selectedADDetailTabpanel = selectedADTabpanel.getDetailPane().getSelectedADTabpanel();
            }
            if (selectedADTabpanel != adtabpanel && selectedADDetailTabpanel != null && selectedADDetailTabpanel != adtabpanel) {
                setFocus = false;
            }
        }
        if (setFocus) {
            this.renderer.focusToFirstEditor();
        }
    }

    public void scrollToCurrentRow() {
        this.onPostSelectedRowChanged();
    }

    private void focusToRow(Row row) {
        if (this.renderer.isEditing()) {
            if (this.columnOnClick != null && this.columnOnClick.trim().length() > 0) {
                this.setFocusToField(this.columnOnClick);
                this.columnOnClick = null;
            } else {
                this.focusToFirstEditorIfNotDetailTab();
            }
        } else {
            Component cmp = null;
            List childs = row.getChildren();
            for (Object o : childs) {
                Component c = (Component)o;
                if (!c.isVisible() || !(c instanceof Cell)) continue;
                cmp = c;
                break;
            }
            if (cmp != null) {
                Clients.response((AuResponse)new AuScript(null, "idempiere.scrollToRow('" + cmp.getUuid() + "');"));
            }
            if (this.columnOnClick != null && this.columnOnClick.trim().length() > 0) {
                List list = row.getChildren();
                for (Object element : list) {
                    Div div;
                    if (!(element instanceof Div) || !this.columnOnClick.equals((div = (Div)element).getAttribute("columnName"))) continue;
                    cmp = div.getFirstChild();
                    Clients.response((AuResponse)new AuScript(null, "idempiere.scrollToRow('" + cmp.getUuid() + "');"));
                    break;
                }
                this.columnOnClick = null;
            }
        }
    }

    private boolean isRowRendered(Row row, int index) {
        if (row.getChildren().size() == 0) {
            return false;
        }
        return row.getChildren().size() != 1 || row.getChildren().get(0) instanceof Div;
    }

    private boolean updateModelIndex(int rowIndex) {
        if (this.pageSize > 0) {
            int start = this.listModel.getPage() * this.listModel.getPageSize();
            rowIndex = start + rowIndex;
        }
        if (this.gridTab.getCurrentRow() != rowIndex) {
            ADWindow adwindow = ADWindow.findADWindow((Component)this);
            if (adwindow != null) {
                boolean[] retValue = new boolean[1];
                int index = rowIndex;
                adwindow.getADWindowContent().saveAndNavigate((Callback<Boolean>)((Callback)e -> {
                    if (e.booleanValue()) {
                        this.gridTab.navigate(index);
                        blArray[0] = true;
                    }
                }));
                return retValue[0];
            }
            this.gridTab.navigate(rowIndex);
            return true;
        }
        return false;
    }

    public Grid getListbox() {
        return this.listbox;
    }

    public void dynamicDisplay(int col) {
        GridField changedField;
        String columnName;
        ArrayList dependants;
        if (this.gridTab == null || !this.gridTab.isOpen()) {
            return;
        }
        if (this.renderer.getEditors().isEmpty()) {
            this.listbox.onInitRender();
        }
        if (col > 0 && (dependants = this.gridTab.getDependantFields(columnName = (changedField = this.gridTab.getField(col)).getColumnName())).size() <= 0 && changedField.getCallout().length() <= 0 && Core.findCallout((String)this.gridTab.getTableName(), (String)columnName).size() <= 0) {
            return;
        }
        boolean noData = this.gridTab.getRowCount() == 0;
        List<WEditor> list = this.renderer.getEditors();
        this.dynamicDisplayEditors(noData, list);
        if (this.gridTab.getRowCount() == 0 && this.selectAll.isChecked()) {
            this.selectAll.setChecked(false);
        }
    }

    private void dynamicDisplayEditors(boolean noData, List<WEditor> list) {
        for (WEditor comp : list) {
            Object ctx;
            GridField mField = comp.getGridField();
            if (mField == null) continue;
            Object object = ctx = this.isDetailPane() ? new GridRowCtx(Env.getCtx(), this.gridTab) : mField.getVO().ctx;
            if (noData) {
                comp.setReadWrite(false);
            } else {
                boolean rw = mField.isEditable(true);
                if (rw && !comp.isReadWrite()) {
                    mField.refreshLookup();
                }
                comp.setReadWrite(rw);
                comp.setMandatory(mField.isMandatory(true));
                comp.dynamicDisplay((Properties)ctx);
            }
            comp.setVisible((this.isHasCustomizeData || mField.isDisplayedGrid()) && mField.isDisplayed((Properties)ctx, true));
        }
    }

    private boolean isDetailPane() {
        Component parent = this.getParent();
        while (parent != null) {
            if (parent instanceof DetailPane) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public void focus() {
        if (this.renderer != null && this.renderer.isEditing()) {
            this.renderer.focusToFirstEditor();
        }
    }

    public boolean onEnterKey() {
        if (!this.modeless && this.renderer != null && !this.renderer.isEditing()) {
            this.renderer.editCurrentRow();
            this.renderer.focusToFirstEditor();
            return true;
        }
        return false;
    }

    public void setFocusToField(String columnName) {
        for (WEditor editor : this.renderer.getEditors()) {
            if (!columnName.equals(editor.getColumnName())) continue;
            Object c = editor.getComponent();
            if (c instanceof EditorBox) {
                c = ((EditorBox)((Object)c)).getTextbox();
            } else if (c instanceof NumberBox) {
                c = ((NumberBox)((Object)c)).getDecimalbox();
            }
            Clients.response((AuResponse)new AuFocus(c));
            break;
        }
    }

    public void setADWindowPanel(AbstractADWindowContent winPanel) {
        this.windowPanel = winPanel;
        if (this.renderer != null) {
            this.renderer.setADWindowPanel(this.windowPanel);
        }
    }

    public void reInit() {
        this.listbox.getChildren().clear();
        this.listbox.detach();
        if (this.paging != null) {
            this.paging.detach();
            this.paging = null;
        }
        this.renderer = null;
        this.init = false;
        Grid tmp = this.listbox;
        this.createListbox();
        tmp.copyEventListeners(this.listbox);
        this.insertBefore((Component)this.listbox, (Component)this.gridFooter);
        this.refresh(this.gridTab);
        this.scrollToCurrentRow();
        this.invalidateGridView();
    }

    public void invalidateGridView() {
        Center center = this.findCenter(this);
        if (center != null) {
            center.invalidate();
        } else {
            this.invalidate();
        }
    }

    public GridField[] getFields() {
        return this.gridFields;
    }

    public void onEditCurrentRow() {
        this.onEditCurrentRow(null);
    }

    public void onEditCurrentRow(Event event) {
        if (!this.renderer.isEditing()) {
            Row currentRow = this.renderer.getCurrentRow();
            if (currentRow == null || currentRow.getParent() == null || !currentRow.isVisible()) {
                if (event == null) {
                    Events.postEvent((String)"onEditCurrentRow", (Component)this, null);
                }
            } else {
                this.renderer.editCurrentRow();
                this.renderer.focusToFirstEditor();
            }
        }
    }

    @Override
    public void focusToFirstEditor() {
        if (this.renderer.isEditing()) {
            this.renderer.focusToFirstEditor();
        }
    }

    @Override
    public void focusToNextEditor(WEditor ref) {
        if (this.renderer.isEditing()) {
            this.renderer.focusToNextEditor(ref);
        }
    }

    public void stateChange(StateChangeEvent event) {
        switch (event.getEventType()) {
            case 0: 
            case 2: 
            case 6: {
                if (!this.selectAll.isChecked()) break;
                this.selectAll.setChecked(false);
                break;
            }
            case 3: 
            case 5: {
                if (this.selectAll.isChecked() || !this.isAllSelected()) break;
                this.selectAll.setChecked(true);
            }
        }
    }

    protected void onADTabPanelParentChanged() {
        this.positionPagingControl();
    }

    private void positionPagingControl() {
        if (this.isDetailPane()) {
            Component parent = this.getParent();
            while (parent != null) {
                if (parent instanceof DetailPane.Tabpanel) {
                    ((DetailPane.Tabpanel)parent).setPagingControl(this.gridFooter);
                    break;
                }
                parent = parent.getParent();
            }
            if (this.paging != null) {
                this.paging.setDetailed(false);
            }
        } else {
            if (this.gridFooter.getParent() != this) {
                ZKUpdateUtil.setHflex((HtmlBasedComponent)this.gridFooter, "1");
                this.gridFooter.setSclass("adtab-grid-south");
                this.appendChild((Component)this.gridFooter);
            }
            if (this.paging != null) {
                this.paging.setDetailed(true);
            }
        }
    }

    @Override
    public void editorTraverse(Callback<WEditor> editorTaverseCallback) {
        this.editorTraverse(editorTaverseCallback, this.renderer.getEditors());
    }

    public boolean isShowCurrentRowIndicatorColumn() {
        return this.showCurrentRowIndicatorColumn;
    }
}

