/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.ui.zk.report;

import com.google.common.net.MediaType;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.webui.window.ZkReportViewer;
import org.compiere.print.ReportEngine;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.print.renderer.CSVReportRendererConfiguration;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.print.renderer.IReportRendererConfiguration;
import org.idempiere.ui.zk.report.IReportViewerRenderer;
import org.osgi.service.component.annotations.Component;
import org.zkoss.util.media.AMedia;

@Component(service={IReportViewerRenderer.class}, immediate=true)
public class CSVReportViewerRenderer
implements IReportViewerRenderer {
    private static final CLogger log = CLogger.getCLogger(CSVReportViewerRenderer.class);

    @Override
    public String getId() {
        return "CSV";
    }

    @Override
    public String getExportLabel() {
        return Msg.getMsg((Properties)Env.getCtx(), (String)"FileCSV");
    }

    @Override
    public String getContentType() {
        return MediaType.CSV_UTF_8.toString();
    }

    @Override
    public String getFileExtension() {
        return "csv";
    }

    @Override
    public boolean isExport() {
        return true;
    }

    @Override
    public boolean isPreview(boolean roleCanExport) {
        return roleCanExport;
    }

    @Override
    public AMedia renderMedia(ZkReportViewer viewer, boolean export) {
        ReportEngine reportEngine = viewer.getReportEngine();
        try {
            String path = System.getProperty("java.io.tmpdir");
            String prefix = this.makePrefix(reportEngine.getName());
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
            }
            File file = FileUtil.createTempFile((String)prefix, (String)("." + this.getFileExtension()), (File)new File(path));
            IReportRenderer renderer = Core.getReportRenderer((String)this.getId());
            CSVReportRendererConfiguration config = new CSVReportRendererConfiguration().setLanguage(reportEngine.getPrintFormat().getLanguage()).setOutputFile(file);
            renderer.renderReport(reportEngine, (IReportRendererConfiguration)config);
            return new AMedia(file.getName(), this.getFileExtension(), this.getContentType(), file, false);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

