/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Properties;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.window.ZkReportViewer;
import org.compiere.print.ReportEngine;
import org.compiere.print.ReportViewerProvider;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Executions;

public class ZkReportViewerProvider
implements ReportViewerProvider {
    public void openViewer(final ReportEngine report) {
        if (Executions.getCurrent() != null) {
            this.openReportViewWindow(report);
        } else {
            AEnv.executeAsyncDesktopTask(new Runnable(){

                @Override
                public void run() {
                    ZkReportViewerProvider.this.openReportViewWindow(report);
                }
            });
        }
    }

    protected void openReportViewWindow(ReportEngine report) {
        ZkReportViewer viewer = new ZkReportViewer(report, report.getName());
        viewer.setAttribute("mode", "embedded");
        viewer.setAttribute("insertPosition", "insertNext");
        if (report.isReplaceTabContent()) {
            viewer.setAttribute("insertPosition", "replace");
            viewer.setAttribute("replaceWindowNo", report.getWindowNo());
            String predefined = Env.getContext((Properties)Env.getCtx(), (int)report.getWindowNo(), (String)"__PredefinedContextVariables__");
            if (!Util.isEmpty((String)predefined, (boolean)true)) {
                viewer.setAttribute("__PredefinedContextVariables__", predefined);
            }
            viewer.setAttribute("IsSOTrx", Env.getContext((Properties)Env.getCtx(), (int)report.getWindowNo(), (String)"IsSOTrx"));
        }
        viewer.setAttribute("deferSetSelectedTab", Boolean.TRUE);
        SessionManager.getAppDesktop().showWindow(viewer);
    }
}

