/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.HashMap;
import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.VerticalBox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.compiere.model.MPostIt;
import org.compiere.model.MSysConfig;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.zkforge.ckez.CKeditor;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Separator;

public class WPostIt
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -9092535255629718710L;
    private boolean editable;
    private int maxSize;
    private String note;
    private Tabbox tabbox;
    private Textbox textBox;
    private CKeditor editor;
    private Label status;
    private Label createdBox;
    private Label updatedBox;
    private String created;
    private String updated;
    private MPostIt m_postIt;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));

    public WPostIt(String title, int postItID, int tableID, int recordID, String recordUU, String trxName) {
        this.setTitle(title);
        this.editable = true;
        this.maxSize = 2000;
        this.m_postIt = postItID > 0 ? new MPostIt(Env.getCtx(), postItID, trxName) : new MPostIt(Env.getCtx(), tableID, recordID, recordUU, trxName);
        String created = null;
        if (this.m_postIt.getAD_PostIt_ID() > 0) {
            created = this.m_postIt.getCreatedString();
        }
        String updated = this.m_postIt.getUpdatedString();
        this.created = created;
        this.updated = updated;
        this.note = this.m_postIt.getText();
        this.init();
    }

    private void init() {
        this.setBorder("normal");
        this.setMaximizable(true);
        VerticalBox vbox = new VerticalBox();
        this.appendChild((Component)vbox);
        this.tabbox = new Tabbox();
        this.tabbox.setMaximalHeight(true);
        vbox.appendChild((Component)this.tabbox);
        Tabs tabs = new Tabs();
        this.tabbox.appendChild((Component)tabs);
        Tabpanels tabPanels = new Tabpanels();
        this.tabbox.appendChild((Component)tabPanels);
        Tab tab = new Tab("Text");
        tabs.appendChild((Component)tab);
        Tabpanel tabPanel = new Tabpanel();
        tabPanels.appendChild((Component)tabPanel);
        this.textBox = new Textbox(this.note);
        this.textBox.setCols(80);
        this.textBox.setMultiline(true);
        this.textBox.setEnabled(this.editable);
        if (ClientInfo.minWidth(730)) {
            this.textBox.setWidth("700px");
        } else {
            this.textBox.setWidth(ClientInfo.get().desktopWidth - 30 + "px");
        }
        if (ClientInfo.minHeight(700)) {
            this.textBox.setHeight("500px");
        } else {
            this.textBox.setHeight(ClientInfo.get().desktopHeight - 190 + "px");
        }
        tabPanel.appendChild((Component)this.textBox);
        tab = new Tab("HTML");
        tabs.appendChild((Component)tab);
        tabPanel = new Tabpanel();
        tabPanels.appendChild((Component)tabPanel);
        this.editor = new CKeditor();
        tabPanel.appendChild((Component)this.editor);
        if (ClientInfo.minWidth(730)) {
            this.editor.setWidth("700px");
        } else {
            this.editor.setWidth(ClientInfo.get().desktopWidth - 30 + "px");
        }
        this.editor.setVflex("1");
        this.editor.setValue(this.note);
        if (ClientInfo.isMobile()) {
            this.editor.setCustomConfigurationsPath("/js/ckeditor/config-min.js");
        } else {
            this.editor.setCustomConfigurationsPath("/js/ckeditor/config.js");
        }
        this.editor.setToolbar("MyToolbar");
        HashMap<String, String> lang = new HashMap<String, String>();
        lang.put("language", Language.getLoginLanguage().getAD_Language());
        this.editor.setConfig(lang);
        vbox.appendChild((Component)new Separator());
        this.createdBox = new Label();
        this.createdBox.setText(this.created);
        vbox.appendChild((Component)this.createdBox);
        this.updatedBox = new Label();
        this.updatedBox.setText(this.updated);
        vbox.appendChild((Component)this.updatedBox);
        vbox.appendChild((Component)new Separator());
        ConfirmPanel confirmPanel = new ConfirmPanel(true);
        vbox.appendChild((Component)confirmPanel);
        confirmPanel.addActionListener(this);
        if (this.maxSize > 0) {
            this.status = new Label();
            this.appendChild((Component)this.status);
            this.updateStatus(this.note == null ? 0 : this.note.length());
            this.status.setStyle("margin-top:10px;");
            this.textBox.addEventListener("onChange", this);
            this.editor.addEventListener("onChange", (EventListener)this);
        }
        this.tabbox.addEventListener("onSelect", this);
        this.addEventListener("onCancel", e -> this.onCancel());
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (event.getTarget().getId().equals("Ok")) {
            if (this.editable) {
                String text = this.tabbox.getSelectedIndex() == 0 ? this.textBox.getText() : this.editor.getValue();
                this.m_postIt.setText(text);
                this.m_postIt.saveEx();
            }
            this.detach();
        } else if (event.getName().equals("onSelect")) {
            if (this.editable) {
                if (this.tabbox.getSelectedIndex() == 0) {
                    this.textBox.setText(this.editor.getValue());
                    this.updateStatus(this.textBox.getText().length());
                } else {
                    this.editor.setValue(this.textBox.getText());
                    this.updateStatus(this.editor.getValue().length());
                }
            }
        } else if (event.getName().equals("onChange")) {
            if (event.getTarget() == this.textBox) {
                this.updateStatus(this.textBox.getText().length());
            } else if (event.getTarget() == this.editor) {
                this.updateStatus(this.editor.getValue().length());
            }
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.detach();
    }

    private void updateStatus(int newLength) {
        if (this.status != null && this.maxSize > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append(newLength);
            if (newLength == this.maxSize) {
                msg.append(" = ");
            } else if (newLength < this.maxSize) {
                msg.append(" < ");
            } else {
                msg.append(" > ");
            }
            msg.append(this.maxSize);
            this.status.setValue(msg.toString());
        }
    }

    public void showWindow() {
        this.textBox.focus();
    }
}

