/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Messagebox;
import org.adempiere.webui.editor.WChosenboxListEditor;
import org.adempiere.webui.editor.WChosenboxSearchEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.editor.WPasswordEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trace;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

public final class Dialog {
    private static final CLogger logger = CLogger.getCLogger(Dialog.class);

    private Dialog() {
    }

    private static String constructMessage(String adMessage, String message, Object ... args) {
        StringBuffer out = new StringBuffer();
        if (!Util.isEmpty((String)adMessage)) {
            out.append(Dialog.getADMessage(adMessage, args));
        }
        if (!Util.isEmpty((String)message)) {
            if (out.length() > 0) {
                out.append("<br>");
            }
            out.append(message);
        }
        return out.toString();
    }

    private static String getADMessage(String adMessage, Object ... args) {
        String message = args != null && args.length > 0 ? Msg.getMsg((Properties)Env.getCtx(), (String)adMessage, (Object[])args) : Msg.getMsg((Properties)Env.getCtx(), (String)adMessage);
        return message;
    }

    public static void warn(int windowNo, String adMessage) {
        Dialog.warn(windowNo, adMessage, null, null);
    }

    public static void warn(int windowNo, String adMessage, String title) {
        Dialog.warn(windowNo, adMessage, null, title);
    }

    public static void warn(int windowNo, String adMessage, String additionalMessage, String title) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(adMessage + " - " + additionalMessage);
        }
        String dialogTitle = Dialog.getDialogTitle(title, windowNo);
        String out = Dialog.constructMessage(adMessage, additionalMessage, new Object[0]);
        String message = Dialog.formatDialogMessage(out);
        Messagebox.showDialog(message, dialogTitle, 1, "~./zul/img/msgbox/warning-btn.png");
    }

    private static String getDialogTitle(String title, int windowNo) {
        return title == null ? AEnv.getDialogHeader(Env.getCtx(), windowNo) : title;
    }

    private static String formatDialogMessage(String originalMessage) {
        return originalMessage.replace("\n", "<br>");
    }

    public static void error(int windowNo, String adMessage) {
        Dialog.error(windowNo, adMessage, null);
    }

    public static void error(int windowNo, String adMessage, String additionalMessage) {
        Dialog.error(windowNo, adMessage, additionalMessage, null);
    }

    public static void error(int windowNo, String adMessage, String additionalMessage, Callback<Integer> callback) {
        Dialog.error(windowNo, adMessage, additionalMessage, callback, null);
    }

    public static void error(int windowNo, String adMessage, String additionalMessage, String title) {
        Dialog.error(windowNo, adMessage, additionalMessage, null, title);
    }

    public static void error(int windowNo, String adMessage, String additionalMessage, Callback<Integer> callback, String title) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(adMessage + " - " + additionalMessage);
        }
        if (CLogMgt.isLevelFinest()) {
            Trace.printStack();
        }
        String dialogTitle = Dialog.getDialogTitle(title, windowNo);
        String out = Dialog.constructMessage(adMessage, additionalMessage, new Object[0]);
        String message = Dialog.formatDialogMessage(out);
        Messagebox.showDialog(message, dialogTitle, 1, "~./zul/img/msgbox/stop-btn.png", callback);
    }

    @Deprecated(forRemoval=true, since="11")
    public static boolean ask(int windowNo, String adMessage) {
        return Dialog.ask(windowNo, adMessage, "");
    }

    public static boolean ask(int windowNo, String adMessage, Callback<Boolean> callback) {
        return Dialog.ask(null, windowNo, adMessage, callback, new Object[0]);
    }

    @Deprecated(forRemoval=true, since="11")
    public static boolean ask(int windowNo, String adMessage, String additionalMessage) {
        return Dialog.ask(windowNo, adMessage, additionalMessage, null);
    }

    public static boolean ask(int windowNo, String adMessage, String additionalMessage, Callback<Boolean> callback) {
        return Dialog.ask(null, windowNo, adMessage, additionalMessage, callback, new Object[0]);
    }

    public static boolean ask(String title, int windowNo, String adMessage, Callback<Boolean> callback, Object ... args) {
        return Dialog.ask(title, windowNo, adMessage, null, callback, args);
    }

    public static boolean ask(int windowNo, String title, String adMessage, String msg, Callback<Boolean> callback) {
        return Dialog.ask(title, windowNo, adMessage, msg, callback, new Object[0]);
    }

    public static boolean ask(String title, int windowNo, String adMessage, String additionalMessage, Callback<Boolean> callback, Object ... args) {
        Callback<Integer> msgCallback = Dialog.getMessageCallback(callback);
        String message = Dialog.constructMessage(adMessage, additionalMessage, args);
        String dialogTitle = Dialog.getDialogTitle(title, windowNo);
        int response = Messagebox.showDialog(message = Dialog.formatDialogMessage(message), dialogTitle, 3, "~./zul/img/msgbox/question-btn.png", msgCallback, msgCallback == null);
        return response == 1;
    }

    private static Callback<Integer> getMessageCallback(final Callback<Boolean> callback) {
        Callback<Integer> msgCallback = null;
        if (callback != null) {
            msgCallback = new Callback<Integer>(){

                public void onCallback(Integer result) {
                    boolean b = result != null && result == 1;
                    callback.onCallback((Object)b);
                }
            };
        }
        return msgCallback;
    }

    public static void askForInput(String message, MLookup lookup, int editorType, Callback<Object> callback, Desktop desktop, int windowNo) {
        Dialog.askForInput(message, lookup, editorType, callback, desktop, windowNo, "", null);
    }

    public static void askForInput(final String message, MLookup lookup, int editorType, final Callback<Object> callback, Desktop desktop, final int windowNo, final String title, Object defaultValue) {
        final WEditor weditor = Dialog.getEditor(lookup, editorType);
        if (weditor != null && defaultValue != null) {
            weditor.setValue(defaultValue);
        }
        Executions.schedule((Desktop)desktop, (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Dialog.askForInput(windowNo, weditor, message, title, (Callback<Object>)callback);
            }
        }, (Event)new Event("onAskForInput"));
    }

    private static WEditor getEditor(MLookup lookup, int editorType) {
        switch (editorType) {
            case 10: {
                return new WStringEditor();
            }
            case 22: {
                return new WNumberEditor();
            }
            case 11: {
                return new WNumberEditor(editorType);
            }
            case 19: 
            case 200234: {
                return new WTableDirEditor((Lookup)lookup, "", "", true, false, true);
            }
            case 30: 
            case 200235: {
                return new WSearchEditor((Lookup)lookup, "", "", true, false, true);
            }
            case 200163: {
                return new WChosenboxSearchEditor((Lookup)lookup, "", "", true, false, true);
            }
            case 200161: 
            case 200162: {
                return new WChosenboxListEditor((Lookup)lookup, "", "", true, false, true);
            }
        }
        return null;
    }

    public static void askForInput(int windowNo, WEditor weditor, String adMessage, Callback<Object> callback) {
        Dialog.askForInput(windowNo, weditor, adMessage, "", callback);
    }

    public static void askForInput(int windowNo, WEditor weditor, String adMessage, String title, final Callback<Object> callback) {
        Callback<Object> msgCallback = null;
        if (callback != null) {
            msgCallback = new Callback<Object>(){

                public void onCallback(Object result) {
                    callback.onCallback(result);
                }
            };
        }
        String dialogTitle = Dialog.getDialogTitle(title, windowNo);
        String message = Dialog.constructMessage(adMessage, null, new Object[0]);
        message = Dialog.formatDialogMessage(message);
        Messagebox.showDialog(message, dialogTitle, 2049, "~./zul/img/msgbox/question-btn.png", weditor, msgCallback, msgCallback == null);
    }

    public static void askForInput(int windowNo, String adMessage, Callback<String> callback) {
        Dialog.askForInput(windowNo, adMessage, "", callback);
    }

    public static void askForInput(int windowNo, String adMessage, String title, final Callback<String> callback) {
        Callback<String> msgCallback = null;
        if (callback != null) {
            msgCallback = new Callback<String>(){

                public void onCallback(String result) {
                    callback.onCallback((Object)result);
                }
            };
        }
        String dialogTitle = Dialog.getDialogTitle(title, windowNo);
        String message = Dialog.constructMessage(adMessage, null, new Object[0]);
        message = Dialog.formatDialogMessage(message);
        Messagebox.showDialog(message, dialogTitle, 2049, "~./zul/img/msgbox/question-btn.png", msgCallback, msgCallback == null);
    }

    public static void askForSecretInput(int windowNo, String adMessage, final Callback<String> callback) {
        Callback<String> msgCallback = null;
        if (callback != null) {
            msgCallback = new Callback<String>(){

                public void onCallback(String result) {
                    callback.onCallback((Object)result);
                }
            };
        }
        String dialogTitle = Dialog.getDialogTitle("", windowNo);
        String message = Dialog.constructMessage(adMessage, null, new Object[0]);
        message = Dialog.formatDialogMessage(message);
        Messagebox.showDialog(message, dialogTitle, 2049, "~./zul/img/msgbox/question-btn.png", new WPasswordEditor(), msgCallback, msgCallback == null);
    }

    public static void askForInputTextConfirmation(int windowNo, WEditor weditor, String adMessage, Object[] adMessageArgs, String title, final Callback<Map.Entry<Boolean, String>> callback) {
        Callback<Map.Entry<Boolean, String>> msgCallback = null;
        msgCallback = new Callback<Map.Entry<Boolean, String>>(){

            public void onCallback(Map.Entry<Boolean, String> result) {
                callback.onCallback(result);
            }
        };
        String dialogTitle = Dialog.getDialogTitle(title, windowNo);
        String message = Dialog.constructMessage(adMessage, null, adMessageArgs);
        message = Dialog.formatDialogMessage(message);
        Messagebox.showDialog(message, dialogTitle, 2051, "~./zul/img/msgbox/question-btn.png", weditor, msgCallback, msgCallback == null);
    }

    public static void askForInputWithCancel(int windowNo, WEditor weditor, String adMessage, String title, final Callback<Map.Entry<Boolean, Object>> callback) {
        Callback<Map.Entry<Boolean, Object>> msgCallback = null;
        if (callback != null) {
            msgCallback = new Callback<Map.Entry<Boolean, Object>>(){

                public void onCallback(Map.Entry<Boolean, Object> result) {
                    callback.onCallback(result);
                }
            };
        }
        String dialogTitle = Dialog.getDialogTitle(title, windowNo);
        String message = Dialog.constructMessage(adMessage, null, new Object[0]);
        message = Dialog.formatDialogMessage(message);
        Messagebox.showDialog(message, dialogTitle, 2051, "~./zul/img/msgbox/question-btn.png", weditor, true, msgCallback, msgCallback == null);
    }

    public static void info(int windowNo, String adMessage) {
        Dialog.info(windowNo, adMessage, null);
    }

    public static void info(int windowNo, String adMessage, String additionalMessage) {
        Dialog.info(windowNo, adMessage, additionalMessage, null);
    }

    public static void info(int windowNo, String adMessage, String additionalMessage, String title) {
        Dialog.info(windowNo, adMessage, additionalMessage, title, null);
    }

    public static void info(int windowNo, String adMessage, String additionalMessage, String title, Callback<Integer> callback) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(adMessage + " - " + additionalMessage);
        }
        String dialogTitle = Dialog.getDialogTitle(title, windowNo);
        String message = Dialog.constructMessage(adMessage, additionalMessage, new Object[0]);
        message = Dialog.formatDialogMessage(message);
        Messagebox.showDialog(message, dialogTitle, 1, "~./zul/img/msgbox/info-btn.png", callback);
    }
}

