/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.compiere.util.CLogger;

public class OSTask
extends Thread {
    private String m_cmd;
    private Process m_child = null;
    private StringBuffer m_out = new StringBuffer();
    private StringBuffer m_err = new StringBuffer();
    private InputStream m_outStream;
    private InputStream m_errStream;
    private OutputStream m_inStream;
    private static final CLogger log = CLogger.getCLogger(OSTask.class);
    private Thread m_outReader = new Thread(){

        @Override
        public void run() {
            if (log.isLoggable(Level.FINE)) {
                log.fine("outReader");
            }
            try {
                int c;
                while ((c = OSTask.this.m_outStream.read()) != -1 && !this.isInterrupted()) {
                    OSTask.this.m_out.append((char)c);
                }
                OSTask.this.m_outStream.close();
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "outReader", (Throwable)ioe);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("outReader - done");
            }
        }
    };
    private Thread m_errReader = new Thread(){

        @Override
        public void run() {
            if (log.isLoggable(Level.FINE)) {
                log.fine("errReader");
            }
            try {
                int c;
                while ((c = OSTask.this.m_errStream.read()) != -1 && !this.isInterrupted()) {
                    OSTask.this.m_err.append((char)c);
                }
                OSTask.this.m_errStream.close();
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "errReader", (Throwable)ioe);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("errReader - done");
            }
        }
    };

    public OSTask(String cmd) {
        this.m_cmd = cmd;
    }

    @Override
    public void run() {
        if (log.isLoggable(Level.INFO)) {
            log.info(this.m_cmd);
        }
        try {
            this.m_child = Runtime.getRuntime().exec(this.m_cmd);
            this.m_outStream = this.m_child.getInputStream();
            this.m_errStream = this.m_child.getErrorStream();
            this.m_inStream = this.m_child.getOutputStream();
            if (this.checkInterrupted()) {
                return;
            }
            this.m_outReader.start();
            this.m_errReader.start();
            Integer exitValue = null;
            while (exitValue == null) {
                block8: {
                    try {
                        Thread.sleep(500L);
                        if (this.checkInterrupted()) {
                            return;
                        }
                        int i = this.m_child.exitValue();
                        exitValue = i;
                    }
                    catch (Exception ie) {
                        if (!log.isLoggable(Level.INFO)) break block8;
                        log.log(Level.INFO, "(ie) - " + String.valueOf(ie));
                    }
                }
                if (!log.isLoggable(Level.CONFIG)) continue;
                log.config("done");
            }
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, "(ioe)", (Throwable)ioe);
            this.m_err.append(ioe.getLocalizedMessage());
        }
    }

    private boolean checkInterrupted() {
        if (this.isInterrupted()) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config("interrupted");
            }
            if (this.m_child != null) {
                this.m_child.destroy();
            }
            this.m_child = null;
            if (this.m_outReader != null && this.m_outReader.isAlive()) {
                this.m_outReader.interrupt();
            }
            this.m_outReader = null;
            if (this.m_errReader != null && this.m_errReader.isAlive()) {
                this.m_errReader.interrupt();
            }
            this.m_errReader = null;
            if (this.m_inStream != null) {
                try {
                    this.m_inStream.close();
                }
                catch (Exception exception) {}
            }
            this.m_inStream = null;
            if (this.m_outStream != null) {
                try {
                    this.m_outStream.close();
                }
                catch (Exception exception) {}
            }
            this.m_outStream = null;
            if (this.m_errStream != null) {
                try {
                    this.m_errStream.close();
                }
                catch (Exception exception) {}
            }
            this.m_errStream = null;
            return true;
        }
        return false;
    }

    public StringBuffer getOut() {
        return this.m_out;
    }

    public StringBuffer getErr() {
        return this.m_err;
    }

    public OutputStream getInStream() {
        return this.m_inStream;
    }
}

