/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel.action;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.apps.WProcessCtl;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.GridTab;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Space;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.impl.LabelImageElement;

public class ReportAction
implements EventListener<Event> {
    private static final CLogger log = CLogger.getCLogger(ReportAction.class);
    private AbstractADWindowContent panel;
    private Window winReport = null;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Listbox cboPrintFormat = new Listbox();
    private Listbox cboExportType = new Listbox();
    private Checkbox chkCurrentRowOnly = new Checkbox();
    private Checkbox chkExport = new Checkbox();
    private Checkbox chkAllColumns = new Checkbox();
    private List<KeyNamePair> printFormatList = new ArrayList<KeyNamePair>();

    public ReportAction(AbstractADWindowContent panel) {
        this.panel = panel;
        this.getPrintFormats(panel.getActiveGridTab().getAD_Table_ID(), panel.getActiveGridTab().getAD_Window_ID());
    }

    public void show() {
        LabelImageElement toolbarItem;
        Popup popup;
        int AD_Table_ID = this.panel.getActiveGridTab().getAD_Table_ID();
        boolean isCanExport = MRole.getDefault().isCanExport(AD_Table_ID);
        if (this.winReport == null) {
            this.winReport = new Window();
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this.winReport, 450);
            this.winReport.setClosable(true);
            this.winReport.setBorder("normal");
            this.winReport.setStyle("position:absolute");
            this.winReport.addEventListener("onValidate", this);
            this.winReport.addCallback("afterPageDetached", (Callback & Serializable)t -> {
                boolean bl = this.panel.focusToLastFocusEditor();
            });
            this.cboPrintFormat.setMold("select");
            this.cboPrintFormat.getItems().clear();
            for (KeyNamePair printFormat : this.printFormatList) {
                this.cboPrintFormat.appendItem(printFormat.getName(), printFormat.getKey());
            }
            if (this.cboPrintFormat.getItemCount() > 0) {
                this.cboPrintFormat.setSelectedIndex(0);
            }
            this.cboExportType.setMold("select");
            this.cboExportType.getItems().clear();
            this.cboExportType.appendItem("ps - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePS"), "ps");
            this.cboExportType.appendItem("xml - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXML"), "xml");
            this.cboExportType.appendItem("pdf - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FilePDF"), "pdf");
            this.cboExportType.appendItem("html - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileHTML"), "html");
            this.cboExportType.appendItem("txt - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileTXT"), "txt");
            this.cboExportType.appendItem("ssv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileSSV"), "ssv");
            this.cboExportType.appendItem("csv - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileCSV"), "csv");
            this.cboExportType.appendItem("xlsx - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLSX"), "xlsx");
            ListItem li = this.cboExportType.appendItem("xls - " + Msg.getMsg((Properties)Env.getCtx(), (String)"FileXLS"), "xls");
            this.cboExportType.setSelectedItem(li);
            this.cboExportType.setVisible(false);
            this.chkCurrentRowOnly.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"CurrentRowOnly"));
            this.chkCurrentRowOnly.setSelected(false);
            if (isCanExport) {
                this.chkExport.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Export"));
                this.chkExport.setSelected(false);
            }
            this.chkAllColumns.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"AllColumns"));
            this.chkAllColumns.setSelected(false);
            li = this.cboPrintFormat.getSelectedItem();
            if (li != null && li.getValue() != null) {
                int AD_PrintFormat_ID = Integer.valueOf(li.getValue().toString());
                this.chkAllColumns.setVisible(AD_PrintFormat_ID == -1);
            }
            Div vb = new Div();
            ZkCssHelper.appendStyle((HtmlBasedComponent)vb, "display: flex; flex-direction: column;");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)vb, "200px");
            this.winReport.appendChild((Component)vb);
            this.winReport.setSclass("toolbar-popup-window");
            vb.setSclass("toolbar-popup-window-cnt");
            Grid grid = GridFactory.newGridLayout();
            ZkCssHelper.appendStyle((HtmlBasedComponent)grid, "flex-grow: 1;");
            vb.appendChild((Component)grid);
            Columns columns = new Columns();
            Column column = new Column();
            column.setWidth("25%");
            columns.appendChild((Component)column);
            column = new Column();
            column.setWidth("75%");
            columns.appendChild((Component)column);
            grid.appendChild((Component)columns);
            Rows rows = new Rows();
            grid.appendChild((Component)rows);
            Row row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Label(Msg.translate((Properties)Env.getCtx(), (String)"AD_PrintFormat_ID")));
            row.appendChild((Component)this.cboPrintFormat);
            this.cboPrintFormat.setWidth("100%");
            this.cboPrintFormat.addEventListener("onSelect", this);
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Space());
            row.appendChild((Component)this.chkCurrentRowOnly);
            if (isCanExport) {
                Panel panel = new Panel();
                panel.appendChild((Component)this.chkExport);
                ZKUpdateUtil.setHflex((HtmlBasedComponent)this.chkExport, "min");
                panel.appendChild((Component)new Space());
                this.chkExport.addEventListener("onCheck", this);
                panel.appendChild((Component)this.cboExportType);
                ZKUpdateUtil.setHflex((HtmlBasedComponent)this.cboExportType, "1");
                ZKUpdateUtil.setHflex((HtmlBasedComponent)panel, "1");
                row = new Row();
                rows.appendChild((Component)row);
                row.appendChild((Component)new Space());
                row.appendChild((Component)panel);
            }
            row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Space());
            row.appendChild((Component)this.chkAllColumns);
            vb.appendChild((Component)this.confirmPanel);
            LayoutUtils.addSclass("dialog-footer", (HtmlBasedComponent)this.confirmPanel);
            this.confirmPanel.addActionListener(this);
            ZkCssHelper.appendStyle((HtmlBasedComponent)this.confirmPanel, "flex-grow: 0;");
        }
        if ((popup = LayoutUtils.findPopup((Component)(toolbarItem = this.panel.getToolbar().getToolbarItem("Report")))) != null) {
            popup.appendChild((Component)this.winReport);
        }
        LayoutUtils.openPopupWindow((Component)toolbarItem, (org.zkoss.zul.Window)this.winReport, "after_start");
        this.winReport.setFocus(true);
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Cancel")) {
            this.winReport.onClose();
        } else if (event.getTarget().getId().equals("Ok")) {
            this.winReport.setVisible(false);
            Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
            Events.echoEvent((String)"onValidate", (Component)this.winReport, null);
        } else if (event.getTarget() == this.cboPrintFormat) {
            ListItem li = this.cboPrintFormat.getSelectedItem();
            if (li != null && li.getValue() != null) {
                int AD_PrintFormat_ID = Integer.valueOf(li.getValue().toString());
                this.chkAllColumns.setVisible(AD_PrintFormat_ID == -1);
            }
        } else if (event.getTarget() == this.chkExport) {
            this.cboExportType.setVisible(this.chkExport.isChecked());
        } else if (event.getName().equals("onValidate")) {
            try {
                this.validate();
            }
            finally {
                Clients.clearBusy();
                this.panel.getComponent().invalidate();
            }
        }
    }

    private void validate() {
        ListItem li = this.cboPrintFormat.getSelectedItem();
        if (li == null || li.getValue() == null) {
            Dialog.error(0, "PrintFormatMandatory");
            return;
        }
        int AD_PrintFormat_ID = Integer.valueOf(li.getValue().toString());
        boolean export = this.chkExport.isChecked();
        if (export && ((li = this.cboExportType.getSelectedItem()) == null || li.getValue() == null)) {
            Dialog.error(0, "ExportFileTypeMandatory");
            return;
        }
        GridTab gridTab = this.panel.getActiveGridTab();
        boolean allColumns = this.chkAllColumns.isChecked();
        MPrintFormat pf = null;
        pf = AD_PrintFormat_ID == -1 ? MPrintFormat.createFromGridLayout((Properties)Env.getCtx(), (GridTab)gridTab, (boolean)allColumns) : MPrintFormat.get((Properties)Env.getCtx(), (int)AD_PrintFormat_ID, (boolean)true);
        boolean currentRowOnly = this.chkCurrentRowOnly.isChecked();
        int Record_ID = 0;
        String Record_UU = null;
        ArrayList<Integer> jasperRecordIDs = null;
        ArrayList<String> jasperRecordUUs = null;
        MQuery query = new MQuery(gridTab.getTableName());
        MTable table = MTable.get((int)gridTab.getAD_Table_ID());
        StringBuilder whereClause = new StringBuilder("");
        if (currentRowOnly) {
            Record_ID = gridTab.getRecord_ID();
            Record_UU = gridTab.getRecord_UU();
            whereClause.append(gridTab.getTableModel().getWhereClause(gridTab.getCurrentRow()));
            if (whereClause.length() == 0) {
                whereClause.append(gridTab.getTableModel().getSelectWhereClause());
            }
        } else {
            whereClause.append(gridTab.getTableModel().getSelectWhereClause());
            if (pf != null && pf.getJasperProcess_ID() > 0) {
                if (table.isUUIDKeyTable()) {
                    jasperRecordUUs = new ArrayList<String>();
                    i = 0;
                    while (i < gridTab.getRowCount()) {
                        jasperRecordUUs.add(gridTab.getKeyUUID(i));
                        ++i;
                    }
                } else {
                    jasperRecordIDs = new ArrayList<Integer>();
                    i = 0;
                    while (i < gridTab.getRowCount()) {
                        jasperRecordIDs.add(gridTab.getKeyID(i));
                        ++i;
                    }
                }
            }
        }
        if (whereClause.length() > 0 && whereClause.indexOf("@") != -1) {
            String context = Env.parseContext((Properties)Env.getCtx(), (int)this.panel.getWindowNo(), (String)whereClause.toString(), (boolean)false);
            if (context != null && context.trim().length() > 0) {
                whereClause = new StringBuilder(context);
            } else {
                log.log(Level.WARNING, "Failed to parse where clause. whereClause= " + String.valueOf(whereClause));
                whereClause = new StringBuilder("1 = 2");
            }
        }
        if (!currentRowOnly && gridTab.isOnlyCurrentRows() && gridTab.getTabNo() == 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(").append(gridTab.getTableName()).append(".Processed='N' OR ").append(gridTab.getTableName()).append(".Updated>");
            whereClause.append("getDate()-1");
            whereClause.append(")");
        }
        query.addRestriction(whereClause.toString());
        PrintInfo info = new PrintInfo(pf.getName(), pf.getAD_Table_ID(), Record_ID, Record_UU);
        info.setDescription(query.getInfo());
        if (pf != null && pf.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", pf.getJasperProcess_ID(), pf.getAD_Table_ID(), Record_ID, Record_UU);
            pi.setRecord_IDs(jasperRecordIDs);
            pi.setRecord_UUs(jasperRecordUUs);
            pi.setTransientObject((Object)pf);
            if (export) {
                li = this.cboExportType.getSelectedItem();
                String ext = li.getValue().toString();
                pi.setExportFileExtension(ext);
                pi.setExport(true);
                this.winReport.onClose();
                ServerProcessCtl.process((ProcessInfo)pi, null);
                try {
                    File exportFile = pi.getExportFile();
                    AMedia media = new AMedia(exportFile.getName() + "." + ext, null, "application/octet-stream", exportFile, true);
                    Filedownload.save((Media)media, (String)(exportFile.getName() + "." + ext));
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to export content.", (Throwable)e);
                }
            } else {
                this.winReport.onClose();
                WProcessCtl.process(gridTab.getWindowNo(), pi, null);
            }
        } else {
            ReportEngine re = new ReportEngine(Env.getCtx(), pf, query, info, null, gridTab.getWindowNo());
            re.setWhereExtended(gridTab.getWhereExtended());
            if (export) {
                this.export(re);
            } else {
                this.print(re);
            }
        }
    }

    private void print(ReportEngine re) {
        this.winReport.onClose();
        ReportCtl.preview((ReportEngine)re);
        Tabpanel tabPanel = (Tabpanel)this.panel.getComponent().getParent();
        tabPanel.getLinkedTab().setSelected(true);
    }

    private void export(ReportEngine re) {
        try {
            ListItem li = this.cboExportType.getSelectedItem();
            if (li == null || li.getValue() == null) {
                Dialog.error(0, "FileInvalidExtension");
                return;
            }
            String ext = li.getValue().toString();
            byte[] data = null;
            File inputFile = null;
            if (ext.equals("pdf")) {
                data = re.createPDFData();
            } else if (ext.equals("ps")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                re.createPS((OutputStream)baos);
                data = baos.toByteArray();
            } else if (ext.equals("xml")) {
                sw = new StringWriter();
                re.createXML((Writer)sw);
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("csv")) {
                sw = new StringWriter();
                re.createCSV((Writer)sw, ',', re.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("ssv")) {
                sw = new StringWriter();
                re.createCSV((Writer)sw, ';', re.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("txt")) {
                sw = new StringWriter();
                re.createCSV((Writer)sw, '\t', re.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("html") || ext.equals("htm")) {
                sw = new StringWriter();
                re.createHTML((Writer)sw, false, re.getPrintFormat().getLanguage());
                data = sw.getBuffer().toString().getBytes();
            } else if (ext.equals("xls")) {
                inputFile = File.createTempFile("Export", ".xls");
                re.createXLS(inputFile, re.getPrintFormat().getLanguage());
            } else if (ext.equals("xlsx")) {
                inputFile = File.createTempFile("Export", ".xlsx");
                re.createXLSX(inputFile, re.getPrintFormat().getLanguage());
            } else {
                Dialog.error(0, "FileInvalidExtension");
                return;
            }
            this.winReport.onClose();
            AMedia media = null;
            media = data != null ? new AMedia(re.getPrintFormat().getName() + "." + ext, null, "application/octet-stream", data) : new AMedia(re.getPrintFormat().getName() + "." + ext, null, "application/octet-stream", inputFile, true);
            Filedownload.save((Media)media, (String)(re.getPrintFormat().getName() + "." + ext));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to export content.", (Throwable)e);
        }
    }

    private void getPrintFormats(int AD_Table_ID, int AD_Window_ID) {
        this.printFormatList.clear();
        this.printFormatList = MPrintFormat.getAccessiblePrintFormats((int)AD_Table_ID, (int)AD_Window_ID, null, (boolean)false);
        int pfAD_Window_ID = MPrintFormat.getZoomWindowID((int)-1);
        if (MRole.getDefault().isTableAccess(493, false) && Boolean.TRUE.equals(MRole.getDefault().getWindowAccess(pfAD_Window_ID))) {
            StringBuffer sb = new StringBuffer("** ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"NewReport")).append(" **");
            KeyNamePair pp = new KeyNamePair(-1, sb.toString());
            this.printFormatList.add(pp);
        }
    }
}

