/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.webui.panel.TreeSearchPanel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.TreeItemAction;
import org.adempiere.webui.util.TreeNodeAction;
import org.adempiere.webui.util.TreeUtils;
import org.compiere.model.MTreeNode;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.Treeitem;

public class MenuTreeSearchPanel
extends TreeSearchPanel {
    private static final long serialVersionUID = 3127547233019932429L;
    protected Toolbarbutton newBtn;
    protected Toolbarbutton openBtn;
    protected boolean isNew = false;

    public MenuTreeSearchPanel(Tree tree, String event, int windowno, int tabno) {
        super(tree, event, windowno, tabno);
    }

    public MenuTreeSearchPanel(Tree tree, String event) {
        super(tree, event);
    }

    public MenuTreeSearchPanel(Tree tree) {
        super(tree);
    }

    @Override
    protected void init() {
        super.init();
        this.layout.getFirstChild().detach();
        Hlayout hlayout = new Hlayout();
        hlayout.setValign("middle");
        hlayout.setSpacing("0px");
        hlayout.setSclass("menu-search-toggle-box");
        this.createNewButton();
        this.createOpenButton();
        hlayout.appendChild((Component)this.newBtn);
        hlayout.appendChild((Component)this.openBtn);
        this.layout.insertBefore((Component)hlayout, this.layout.getFirstChild());
    }

    protected void createOpenButton() {
        this.openBtn = new Toolbarbutton();
        if (ThemeManager.isUseFontIconForImage()) {
            this.openBtn.setIconSclass("z-icon-Open");
        } else {
            this.openBtn.setImage(ThemeManager.getThemeResource("images/Open16.png"));
        }
        this.openBtn.setSclass("menu-search-toggle-on");
        this.openBtn.setDisabled(true);
        this.openBtn.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                MenuTreeSearchPanel.this.openBtn.setDisabled(true);
                MenuTreeSearchPanel.this.openBtn.setSclass("menu-search-toggle-on");
                MenuTreeSearchPanel.this.isNew = false;
                MenuTreeSearchPanel.this.newBtn.setDisabled(false);
                MenuTreeSearchPanel.this.newBtn.setSclass("menu-search-toggle-off");
                MenuTreeSearchPanel.this.refreshAutoComplete();
            }
        });
        this.openBtn.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Open")));
    }

    protected void createNewButton() {
        this.newBtn = new Toolbarbutton();
        if (ThemeManager.isUseFontIconForImage()) {
            this.newBtn.setIconSclass("z-icon-New");
        } else {
            this.newBtn.setImage(ThemeManager.getThemeResource("images/New16.png"));
        }
        this.newBtn.setSclass("menu-search-toggle-off");
        this.newBtn.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                MenuTreeSearchPanel.this.newBtn.setDisabled(true);
                MenuTreeSearchPanel.this.newBtn.setSclass("menu-search-toggle-on");
                MenuTreeSearchPanel.this.isNew = true;
                MenuTreeSearchPanel.this.openBtn.setDisabled(false);
                MenuTreeSearchPanel.this.openBtn.setSclass("menu-search-toggle-off");
                MenuTreeSearchPanel.this.refreshAutoComplete();
            }
        });
        this.newBtn.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"New")));
    }

    @Override
    public void refreshSearchList() {
        this.treeNodeItemMap.clear();
        if (this.tree.getModel() == null) {
            TreeUtils.traverse(this.tree, new TreeItemAction(){

                @Override
                public void run(Treeitem treeItem) {
                    if (treeItem.isVisible()) {
                        MenuTreeSearchPanel.this.addTreeItem(treeItem);
                    }
                }
            });
        } else {
            TreeUtils.traverse((TreeModel<Object>)this.tree.getModel(), new TreeNodeAction(){

                @Override
                public void run(DefaultTreeNode<?> treeNode) {
                    MenuTreeSearchPanel.this.addTreeItem(treeNode);
                }
            });
        }
        this.refreshAutoComplete();
    }

    protected void refreshAutoComplete() {
        ArrayList<String> valueList = new ArrayList<String>();
        ArrayList<String> descriptionList = new ArrayList<String>();
        ArrayList<String> imageList = new ArrayList<String>();
        ArrayList<String> typeList = new ArrayList<String>();
        for (Object value : this.treeNodeItemMap.values()) {
            DefaultTreeNode sNode;
            MTreeNode mNode;
            if (value instanceof Treeitem) {
                Treeitem treeItem = (Treeitem)value;
                if (this.isFolder(treeItem) || this.isNew && !"window".equals(treeItem.getAttribute("menu.type"))) continue;
                valueList.add(this.getLabel(treeItem));
                descriptionList.add(treeItem.getTooltiptext());
                typeList.add(String.valueOf(treeItem.getAttribute("menu.type")));
                String image = this.getImage(treeItem);
                if (image == null || image.length() == 0) {
                    image = ThemeManager.getThemeResource("images/Folder16.png");
                }
                imageList.add(image);
                continue;
            }
            if (!(value instanceof DefaultTreeNode) || !(mNode = (MTreeNode)(sNode = (DefaultTreeNode)value).getData()).isLeaf() || this.isNew && !mNode.isWindow()) continue;
            valueList.add(mNode.getName());
            descriptionList.add(mNode.getDescription());
            imageList.add(mNode.getImagePath());
        }
        this.treeDescription = descriptionList.toArray(new String[0]);
        this.treeValues = valueList.toArray(new String[0]);
        this.treeImages = imageList.toArray(new String[0]);
        this.treeTypes = typeList.toArray(new String[0]);
        this.orderArrays();
        this.cmbSearch.setDescription(this.treeDescription);
        this.cmbSearch.setDict(this.treeValues);
        this.cmbSearch.setImages(this.treeImages);
        this.cmbSearch.setContents(this.treeTypes);
        this.cmbSearch.refresh("");
    }

    @Override
    protected void onPostSelectTreeitem() {
        Clients.clearBusy();
        Event event = null;
        event = this.eventToFire.equals("onClick") ? (this.tree.getSelectedItem().getTreerow().getFirstChild().getFirstChild() instanceof A ? new Event("onClick", this.tree.getSelectedItem().getTreerow().getFirstChild().getFirstChild(), (Object)this.isNew) : new Event("onClick", (Component)this.tree.getSelectedItem().getTreerow(), (Object)this.isNew)) : new Event(this.eventToFire, (Component)this.tree, (Object)this.isNew);
        Events.postEvent((Event)event);
        Events.echoEvent((String)"onPostFireTreeEvent", (Component)this, null);
    }

    protected void orderArrays() {
        int i = 1;
        while (i < this.treeValues.length) {
            int j = 0;
            while (j < this.treeValues.length - i) {
                if (this.treeValues[j].compareTo(this.treeValues[j + 1]) > 0) {
                    String aux = this.treeValues[j];
                    this.treeValues[j] = this.treeValues[j + 1];
                    this.treeValues[j + 1] = aux;
                    aux = this.treeDescription[j];
                    this.treeDescription[j] = this.treeDescription[j + 1];
                    this.treeDescription[j + 1] = aux;
                    aux = this.treeTypes[j];
                    this.treeTypes[j] = this.treeTypes[j + 1];
                    this.treeTypes[j + 1] = aux;
                    aux = this.treeImages[j];
                    this.treeImages[j] = this.treeImages[j + 1];
                    this.treeImages[j + 1] = aux;
                }
                ++j;
            }
            ++i;
        }
    }
}

