/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.component.Urlbox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class WUrlEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onChange", "onOK"};
    private String oldValue;

    public WUrlEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WUrlEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new Urlbox(), gridField, tableEditor, editorConfiguration);
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-Online");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/Online16.png"));
        }
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.popupMenu.addMenuListener(this);
        this.addChangeLogMenu(this.popupMenu);
        this.getComponent().getTextbox().setClientAttribute("type", "url");
        if (gridField != null) {
            this.getComponent().getTextbox().setPlaceholder(gridField.getPlaceholder());
        }
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.oldValue = null;
            this.getComponent().setText("");
        } else {
            this.oldValue = String.valueOf(value);
            this.getComponent().setText(this.oldValue);
        }
    }

    @Override
    public Object getValue() {
        return this.getComponent().getText();
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    public Urlbox getComponent() {
        return (Urlbox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    public void onEvent(Event event) {
        if ("onChange".equals(event.getName()) || "onOK".equals(event.getName())) {
            String newValue = this.getComponent().getText();
            if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if (this.oldValue == null && newValue == null) {
                return;
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            this.fireValueChange(changeEvent);
            this.oldValue = newValue;
        }
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent()) && this.isShowPreference()) {
            ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
        }
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }

    @Override
    protected void setFieldStyle(String style) {
        this.getComponent().getTextbox().setStyle(style);
    }
}

