/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.GridRowCtx;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Html;
import org.zkoss.zul.Menuitem;

public class WColorEditor
extends WEditor
implements ContextMenuListener {
    private static final CLogger log = CLogger.getCLogger(WColorEditor.class);
    private static final String[] LISTENER_EVENTS = new String[]{"onClick"};
    public static final String COLOR_PICKER_EVENT = "COLOR_PICKER";
    private String oldValue;
    private String placeHolder;
    private Textbox colorbox;

    public WColorEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WColorEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new EditorBox(), gridField, tableEditor, editorConfiguration);
        this.init();
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass("z-icon-pencil");
        } else {
            this.getComponent().setButtonImage(ThemeManager.getThemeResource("images/ColorPicker16.png"));
        }
        if (gridField != null) {
            this.placeHolder = gridField.getPlaceholder();
        }
        if (Util.isEmpty((String)this.placeHolder, (boolean)true)) {
            this.placeHolder = Msg.getMsg((Properties)Env.getCtx(), (String)"ColorFieldPlaceholder");
        }
        this.getComponent().getTextbox().setPlaceholder(this.placeHolder);
        this.getComponent().getTextbox().setReadonly(true);
        this.colorbox = new Textbox();
        this.colorbox.setClientAttribute("type", "color");
        this.colorbox.setStyle("position:absolute;top:0;left:0;height:0px !important;width:0px !important;border:none !important;margin:0 !important;padding:0 !important;visibility:hidden;");
        if (!tableEditor) {
            this.getComponent().appendChild((Component)this.colorbox);
        } else {
            this.getComponent().getTextbox().addCallback("afterPageAttached", (Callback & Serializable)t -> {
                Object object = this.afterPageAttached();
            });
            this.getComponent().getTextbox().addCallback("afterPageDetached", (Callback & Serializable)t -> {
                Object object = this.afterPageDetached();
            });
        }
        this.colorbox.addEventListener("onInput", e -> this.processNewValue((String)e.getData()));
        this.colorbox.setWidgetOverride("__doOnInput", "function(evt) {  let v=this.$n().value;  this.fire('onInput',v,{toServer:true});}");
        this.colorbox.setWidgetOverride("bind_", "function() {  this.$supers('bind_',arguments);  this.domListen_(this.$n(),'oninput','__doOnInput');}");
        this.colorbox.setWidgetOverride("unbind_", "function() {  this.domUnlisten_(this.$n(),'oninput','__doOnInput');  this.$supers('unbind_',arguments);}");
    }

    private Object afterPageDetached() {
        if (this.colorbox.getPage() != null && this.colorbox.getParent() != this.getComponent()) {
            this.colorbox.detach();
        }
        this.getComponent().getTextbox().addCallback("afterPageAttached", (Callback & Serializable)t -> {
            Object object = this.afterPageAttached();
        });
        this.getComponent().getTextbox().addCallback("afterPageDetached", (Callback & Serializable)t -> {
            Object object = this.afterPageDetached();
        });
        return null;
    }

    private Object afterPageAttached() {
        if (this.colorbox.getParent() == null) {
            this.colorbox.setPage(this.getComponent().getPage());
        }
        this.fillTextbox();
        return null;
    }

    private void init() {
        if (log.isLoggable(Level.INFO)) {
            log.info("Initializing component");
        }
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.addColorEditorMenu(this.popupMenu);
        this.addChangeLogMenu(this.popupMenu);
    }

    protected void addColorEditorMenu(WEditorPopupMenu popupMenu) {
        Menuitem editor = new Menuitem();
        editor.setAttribute("EVENT", (Object)"RESET");
        editor.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Erase")).intern());
        if (ThemeManager.isUseFontIconForImage()) {
            editor.setIconSclass("z-icon-eraser");
        } else {
            editor.setImage(ThemeManager.getThemeResource("images/Erase16.png"));
        }
        editor.addEventListener("onClick", (EventListener)popupMenu);
        popupMenu.appendChild((Component)editor);
        editor = new Menuitem();
        editor.setAttribute("EVENT", (Object)COLOR_PICKER_EVENT);
        editor.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ColorPicker"));
        if (ThemeManager.isUseFontIconForImage()) {
            editor.setIconSclass("z-icon-pencil");
        } else {
            editor.setImage(ThemeManager.getThemeResource("images/ColorPicker16.png"));
        }
        editor.addEventListener("onClick", (EventListener)popupMenu);
        popupMenu.appendChild((Component)editor);
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("RESET".equals(evt.getContextEvent())) {
            this.processNewValue(null);
            this.colorbox.setValue(this.oldValue);
        } else if (COLOR_PICKER_EVENT.equals(evt.getContextEvent())) {
            this.openColorPicker();
        }
    }

    public EditorBox getComponent() {
        return (EditorBox)this.component;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.oldValue = null;
            this.getComponent().setText("");
        } else {
            this.oldValue = String.valueOf(value);
            this.getComponent().setText(this.oldValue);
        }
        this.colorbox.setValue(this.oldValue);
        this.fillTextbox();
    }

    private void fillTextbox() {
        String style = "background-color: transparent !important;";
        if (!Util.isEmpty((String)this.oldValue, (boolean)true)) {
            style = this.getBackgroundFillStyle(this.oldValue);
        }
        String script = "jq('#" + this.getComponent().getTextbox().getUuid() + "').attr('style','" + style + "');";
        if (Executions.getCurrent() != null && this.getComponent().getPage() != null) {
            Clients.response((AuResponse)new AuScript(script));
        } else if (this.getComponent().getDesktop() != null) {
            Executions.schedule((Desktop)this.getComponent().getDesktop(), e -> Clients.response((AuResponse)new AuScript(script)), (Event)new Event("onFillTextBox"));
        }
    }

    protected String getBackgroundFillStyle(String color) {
        return "background: linear-gradient(to right, rgba(255,0,0,0) 50%, " + color + " 50%) !important;";
    }

    @Override
    public Object getValue() {
        return this.getComponent().getText();
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().getButton().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().getButton().setEnabled(readWrite);
    }

    public void onEvent(Event event) {
        if (!"onClick".equalsIgnoreCase(event.getName())) {
            return;
        }
        this.openColorPicker();
    }

    public void openColorPicker() {
        String uid = this.colorbox.getUuid();
        String script = "(function(){let wgt = zk.Widget.$('#" + uid + "');wgt.$n().click();})()";
        Clients.response((AuResponse)new AuScript(script));
    }

    protected void processNewValue(String newValue) {
        if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
            return;
        }
        if (this.oldValue == null && newValue == null) {
            return;
        }
        ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
        this.fireValueChange(changeEvent);
        this.oldValue = this.getComponent().getTextbox().getValue();
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }

    @Override
    public String getDisplayTextForGridView(GridRowCtx gridRowCtx, Object value) {
        if (value == null) {
            return "";
        }
        return "<div class='grid-view-color-fieldtype-display'>\t<div style='background: " + value.toString() + ";'></div></div>";
    }

    @Override
    public Component getDisplayComponent() {
        return new Html();
    }
}

