/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.util.Properties;
import java.util.Set;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.FavoriteSimpleTreeModel;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.dashboard.DPFavourites;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MTable;
import org.compiere.model.MTreeFavorite;
import org.compiere.model.MTreeFavoriteNode;
import org.compiere.model.MTreeNode;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Label;
import org.zkoss.zul.Rows;
import org.zkoss.zul.South;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeNode;

public class FavouriteFolderDialog
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -2838644830113603288L;
    private Textbox txtFolder;
    private Checkbox chkAddAsRoot;
    private Checkbox chkDefaultExpanded;
    private Label lblSelectedNodeInfo = new Label();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel centerPanel = new Panel();
    private Grid grid = new Grid();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private MTreeFavoriteNode favNodeSummary;
    private FavoriteSimpleTreeModel treeModel;
    private Tree tree;
    private boolean isAdd;

    public FavouriteFolderDialog(boolean isAdd, FavoriteSimpleTreeModel treeModel, Tree tree) {
        this.isAdd = isAdd;
        this.treeModel = treeModel;
        this.tree = tree;
        this.init();
        this.initAttributes();
    }

    private void init() {
        if (this.isAdd) {
            this.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"AddFolder"));
        } else {
            this.setTitle(Msg.translate((Properties)Env.getCtx(), (String)"EditFolder"));
        }
        this.setBorder("normal");
        this.setShadow(true);
        this.setSizable(true);
        this.setMaximizable(true);
        this.setMode("highlighted");
        this.setSclass("popup-dialog fav-add-edit-dialog");
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 325);
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 225);
        this.mainLayout.setParent((Component)this);
        this.grid.setOddRowSclass("even");
        this.centerPanel.appendChild((Component)this.grid);
        Center center = new Center();
        center.setSclass("dialog-content");
        center.appendChild((Component)this.centerPanel);
        center.setParent((Component)this.mainLayout);
        South south = new South();
        south.setSclass("dialog-footer");
        south.appendChild((Component)this.confirmPanel);
        south.setParent((Component)this.mainLayout);
        this.confirmPanel.addActionListener("onClick", this);
        Rows rows = new Rows();
        rows.setParent((Component)this.grid);
        Row row = new Row();
        row.setParent((Component)rows);
        row.appendChild((Component)this.lblSelectedNodeInfo);
        if (this.isAdd) {
            this.chkAddAsRoot = new Checkbox();
            this.chkAddAsRoot.setClass("fav-chkbox");
            this.chkAddAsRoot.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"AddAsRoot"));
            this.chkAddAsRoot.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Tooltip_AddAsRoot"));
            row = new Row();
            row.setParent((Component)rows);
            row.appendChild((Component)this.chkAddAsRoot);
        }
        this.chkDefaultExpanded = new Checkbox();
        this.chkDefaultExpanded.setClass("fav-chkbox");
        this.chkDefaultExpanded.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"DefaultExpanded"));
        this.chkDefaultExpanded.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Tooltip_DefaultExpanded"));
        row = new Row();
        row.setParent((Component)rows);
        row.appendChild((Component)this.chkDefaultExpanded);
        this.txtFolder = new Textbox();
        this.txtFolder.setClass("fav-folder-textbox");
        this.txtFolder.setPlaceholder(Msg.getMsg((Properties)Env.getCtx(), (String)"AddFolderFavTree"));
        this.txtFolder.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AddFolderFavTree"));
        this.txtFolder.addEventListener("onOK", (EventListener)this);
        row = new Row();
        row.setParent((Component)rows);
        row.appendChild((Component)this.txtFolder);
    }

    private void initAttributes() {
        String MSG_CURRENT_FOLDER_SELECTED = Msg.getMsg((Properties)Env.getCtx(), (String)"CurrentFolderSelected");
        int selectedNodeID = DPFavourites.getCurrentSelectedNodeID(this.tree);
        if (selectedNodeID > 0) {
            this.favNodeSummary = (MTreeFavoriteNode)MTable.get((Properties)Env.getCtx(), (int)200221).getPO(selectedNodeID, null);
            if (!this.favNodeSummary.isSummary()) {
                if (this.favNodeSummary.getParent_ID() > 0) {
                    this.favNodeSummary = (MTreeFavoriteNode)this.favNodeSummary.getParent();
                } else {
                    this.lblSelectedNodeInfo.setValue(MSG_CURRENT_FOLDER_SELECTED + " : [ Root ]");
                    return;
                }
            }
            this.chkDefaultExpanded.setSelected(!this.favNodeSummary.isCollapsible());
            this.lblSelectedNodeInfo.setValue(MSG_CURRENT_FOLDER_SELECTED + " : " + this.favNodeSummary.getName());
            if (!this.isAdd) {
                this.txtFolder.setText(this.favNodeSummary.getName());
            }
        } else {
            this.lblSelectedNodeInfo.setValue(MSG_CURRENT_FOLDER_SELECTED + " : [ Root ]");
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Ok") || event.getTarget() == this.txtFolder && "onOK".equals(event.getName())) {
            if (Util.isEmpty((String)this.txtFolder.getText(), (boolean)true)) {
                this.txtFolder.setFocus(true);
            } else {
                if (this.isAdd) {
                    this.insertFolder(this.txtFolder.getText());
                } else {
                    this.favNodeSummary.setIsCollapsible(!this.chkDefaultExpanded.isChecked());
                    this.favNodeSummary.setName(this.txtFolder.getText());
                    this.favNodeSummary.saveEx();
                    Set nodeSelection = this.treeModel.getSelection();
                    for (TreeNode tNode : nodeSelection) {
                        MTreeNode mtNode = (MTreeNode)tNode.getData();
                        mtNode.setName(this.favNodeSummary.getName());
                        mtNode.setCollapsible(this.favNodeSummary.isCollapsible());
                    }
                    int[] path = this.treeModel.getSelectionPath();
                    if (path != null && path.length > 0) {
                        DefaultTreeNode<Object> parentNode = this.treeModel.getRoot();
                        int index = path.length - 1;
                        int i = 0;
                        while (i < index) {
                            parentNode = this.treeModel.getChild(parentNode, path[i]);
                            ++i;
                        }
                        this.treeModel.fireEvent(0, this.treeModel.getPath((TreeNode)parentNode), path[index], path[index]);
                    }
                }
                this.txtFolder.setText("");
                this.dispose();
            }
        } else if (event.getTarget().getId().equals("Cancel")) {
            this.dispose();
        }
    }

    private void insertFolder(String folderName) {
        int parentID = 0;
        if (!this.chkAddAsRoot.isChecked() && (parentID = DPFavourites.getCurrentSelectedNodeID(this.tree)) > 0) {
            this.favNodeSummary = (MTreeFavoriteNode)MTable.get((Properties)Env.getCtx(), (int)200221).getPO(parentID, null);
            if (!this.favNodeSummary.isSummary()) {
                parentID = this.favNodeSummary.getParent_ID() > 0 ? this.favNodeSummary.getParent_ID() : 0;
            }
        }
        MTreeFavoriteNode favNode = MTreeFavoriteNode.create((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()), (int)MTreeFavorite.getFavoriteTreeID((int)Env.getAD_User_ID((Properties)Env.getCtx())), (int)0, (int)parentID, (int)0, (String)folderName, (boolean)true, (!this.chkDefaultExpanded.isChecked() ? 1 : 0) != 0, (boolean)false);
        DPFavourites.addNodeInTree(this.treeModel, this.tree, this.treeModel.find(null, favNode.getParent_ID()), favNode);
    }
}

