/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.util.Properties;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.FavoriteSimpleTreeModel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.dashboard.FavouriteFolderDialog;
import org.adempiere.webui.dashboard.LoginOpenSequenceDialog;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MMenu;
import org.compiere.model.MTable;
import org.compiere.model.MTreeFavorite;
import org.compiere.model.MTreeFavoriteNode;
import org.compiere.model.MTreeNode;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Box;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.Vbox;

public class DPFavourites
extends DashboardPanel
implements EventListener<Event> {
    private static final long serialVersionUID = 7915726855926813700L;
    public static final String FAVOURITE_DROPPABLE = "favourite";
    private FavoriteSimpleTreeModel treeModel;
    private ToolBarButton btnAdd;
    private ToolBarButton btnEdit;
    private ToolBarButton btnExpand;
    private ToolBarButton btnAutoLaunch;
    private Tree tree;

    public DPFavourites() {
        Panel panel = new Panel();
        panel.setClass("fav-tree-panel");
        this.appendChild((Component)panel);
        Panelchildren favContent = new Panelchildren();
        favContent.appendChild((Component)this.createFavoritePanel());
        favContent.setDroppable(FAVOURITE_DROPPABLE);
        favContent.addEventListener("onDrop", (EventListener)this);
        panel.appendChild((Component)favContent);
        this.btnExpand = new ToolBarButton("Expand");
        this.btnExpand.setChecked(false);
        this.btnExpand.setClass("fav-button-Expand");
        this.btnExpand.addEventListener("onClick", this);
        this.btnExpand.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Tooltip_ExpandCollapseTree"));
        if (ThemeManager.isUseFontIconForImage()) {
            this.btnExpand.setIconSclass("z-icon-Expanding");
        } else {
            this.btnExpand.setImage(ThemeManager.getThemeResource("images/expand-header.png"));
        }
        this.btnAdd = new ToolBarButton("AddFolder");
        this.btnAdd.setClass("fav-button-add");
        this.btnAdd.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AddFolder"));
        this.btnAdd.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.btnAdd.setIconSclass("z-icon-TreeFavNodeAdd");
        } else {
            this.btnAdd.setImage(ThemeManager.getThemeResource("images/FolderAdd24.png"));
        }
        this.btnEdit = new ToolBarButton("Edit");
        this.btnEdit.setClass("fav-button-edit");
        this.btnEdit.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"EditFolder"));
        this.btnEdit.addEventListener("onClick", this);
        this.btnEdit.setDisabled(true);
        if (ThemeManager.isUseFontIconForImage()) {
            this.btnEdit.setIconSclass("z-icon-Edit");
        } else {
            this.btnEdit.setImage(ThemeManager.getThemeResource("images/Editor24.png"));
        }
        this.btnAutoLaunch = new ToolBarButton("AutoLaunch");
        this.btnAutoLaunch.setClass("fav-button-autolaunch");
        this.btnAutoLaunch.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoLaunch"));
        this.btnAutoLaunch.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.btnAutoLaunch.setIconSclass("z-icon-SequenceChange");
        } else {
            this.btnAutoLaunch.setImage(ThemeManager.getThemeResource("images/Customize24.png"));
        }
        Toolbar toolbar = new Toolbar();
        toolbar.setClass("fav-toolbar");
        toolbar.appendChild((Component)this.btnExpand);
        toolbar.appendChild((Component)this.btnAdd);
        toolbar.appendChild((Component)this.btnEdit);
        toolbar.appendChild((Component)this.btnAutoLaunch);
        this.appendChild((Component)toolbar);
    }

    private Box createFavoritePanel() {
        this.tree = new Tree();
        this.tree.setMultiple(false);
        this.tree.setSizedByContent(false);
        this.tree.setClass("menu-tree");
        this.tree.addEventListener("onSelect", (EventListener)this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tree, "100%");
        ZkCssHelper.appendStyle((HtmlBasedComponent)this.tree, "border: none; min-height: 20px;");
        Vbox box = new Vbox();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)box, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)box, "1");
        box.appendChild((Component)this.tree);
        this.initTreeModel();
        return box;
    }

    public void initTreeModel() {
        this.treeModel = FavoriteSimpleTreeModel.initADTree(this.tree, null);
    }

    public void onEvent(Event event) {
        DropEvent de;
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            if (event.getTarget() == this.btnAdd) {
                this.doFolderOpr(true);
            } else if (event.getTarget() == this.btnEdit) {
                this.doFolderOpr(false);
            } else if (event.getTarget() == this.btnExpand) {
                this.doExpandCollapseAll();
            } else if (event.getTarget() == this.btnAutoLaunch) {
                this.doLoginOpenSeq();
            }
        } else if (eventName.equals("onSelect") && event.getTarget() == this.tree) {
            MTreeNode mtNode = DPFavourites.getCurrentSelectedTreeNode(this.tree);
            this.btnEdit.setDisabled(mtNode.getNode_ID() == 0 || !mtNode.isSummary());
        } else if (eventName.equals("onDrop") && event instanceof DropEvent && event.getTarget() instanceof Panelchildren && (de = (DropEvent)event).getDragged() != de.getTarget() && de.getDragged() instanceof Treerow) {
            Treeitem src = (Treeitem)((Treerow)de.getDragged()).getParent();
            int menuID = Integer.parseInt((String)src.getValue());
            int treeFavoriteID = MTreeFavorite.getFavoriteTreeID((int)Env.getAD_User_ID((Properties)Env.getCtx()));
            DPFavourites.insertMenuInTree(menuID, 0, treeFavoriteID, this.tree, this.treeModel, null);
        }
    }

    private void doLoginOpenSeq() {
        LoginOpenSequenceDialog dialog = new LoginOpenSequenceDialog(Env.getAD_User_ID((Properties)Env.getCtx()));
        dialog.loadData();
        dialog.doHighlighted();
        AEnv.showCenterScreen(dialog);
    }

    private void doFolderOpr(boolean isAddFolder) {
        FavouriteFolderDialog addFolderPanel = new FavouriteFolderDialog(isAddFolder, this.treeModel, this.tree);
        AEnv.showCenterScreen(addFolderPanel);
    }

    private void doExpandCollapseAll() {
        this.btnExpand.setChecked(!this.btnExpand.isChecked());
        if (!this.tree.getChildren().isEmpty()) {
            if (this.btnExpand.isChecked()) {
                this.btnExpand.addSclass("fav-expand-mode");
                TreeUtils.expandAll(this.tree);
            } else {
                this.btnExpand.removeSclass("fav-expand-mode");
                TreeUtils.collapseAll(this.tree);
            }
        }
    }

    public static MTreeNode getCurrentSelectedTreeNode(Tree tree) {
        Treeitem selItem = tree.getSelectedItem();
        DefaultTreeNode dtn = selItem == null ? (DefaultTreeNode)tree.getModel().getRoot() : (DefaultTreeNode)selItem.getValue();
        return (MTreeNode)dtn.getData();
    }

    public static int getCurrentSelectedNodeID(Tree tree) {
        return DPFavourites.getCurrentSelectedTreeNode(tree).getNode_ID();
    }

    public static void insertMenuInTree(int menuID, int parentNodeID, int treeFavoriteID, Tree tree, FavoriteSimpleTreeModel treeModel, DefaultTreeNode<Object> parentDTN) {
        MTreeFavoriteNode favNode = MTreeFavoriteNode.create((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Org_ID"), (int)treeFavoriteID, (int)menuID, (int)parentNodeID, (int)0, null, (boolean)false, (boolean)true, (boolean)false);
        DPFavourites.addNodeInTree(treeModel, tree, parentDTN, favNode);
    }

    public static void addNodeInTree(FavoriteSimpleTreeModel treeModel, Tree tree, DefaultTreeNode<Object> parentDTN, MTreeFavoriteNode favNode) {
        String name = null;
        String description = null;
        String action = null;
        if (favNode.getAD_Menu_ID() > 0) {
            MMenu menu = (MMenu)MTable.get((Properties)Env.getCtx(), (int)116).getPO(favNode.getAD_Menu_ID(), null);
            name = menu.getDisplayedName();
            description = menu.get_Translation("Description");
            action = menu.getAction();
        } else {
            description = name = favNode.getName();
        }
        MTreeNode mtnNew = new MTreeNode(favNode.getAD_Tree_Favorite_Node_ID(), favNode.getSeqNo(), name, description, favNode.getParent_ID(), favNode.getAD_Menu_ID(), action, favNode.isSummary(), favNode.isCollapsible(), favNode.isFavourite());
        DefaultTreeNode newNode = new DefaultTreeNode((Object)mtnNew);
        if (parentDTN == null) {
            parentDTN = treeModel.getRoot();
        }
        treeModel.addNode(parentDTN, (DefaultTreeNode<Object>)newNode, 0);
        int[] path = treeModel.getPath((TreeNode)newNode);
        Treeitem ti = tree.renderItemByPath(path);
        tree.renderItem(ti);
        if (mtnNew.isSummary()) {
            tree.setSelectedItem(ti);
        } else {
            tree.setSelectedItem(ti.getParentItem());
            path = treeModel.getPath((TreeNode)treeModel.getParent((DefaultTreeNode<Object>)newNode));
        }
        treeModel.addSelectionPath(path);
        Events.sendEvent((Component)tree, (Event)new Event("onSelect", (Component)tree));
    }
}

