/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ManageImageCache;
import org.compiere.model.MAttachment;
import org.compiere.model.MForm;
import org.compiere.model.MImage;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MUserDefInfo;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zul.Include;
import org.zkoss.zul.impl.LabelImageElement;

public class Tab
extends org.zkoss.zul.Tab {
    private static final long serialVersionUID = -7504310693884092219L;
    private boolean isDisableDraggDrop = false;

    public Tab(String label) {
        this.setLabel(label);
    }

    public Tab() {
    }

    public void setDecorateInfo(DecorateInfo decorateInfo) {
        if (decorateInfo != null) {
            decorateInfo.decorate((LabelImageElement)this);
        }
    }

    public void onClose() {
        Tabpanel tp = (Tabpanel)this.getLinkedPanel();
        if (tp != null) {
            tp.onClose();
        }
    }

    public boolean isDisableDraggDrop() {
        return this.isDisableDraggDrop;
    }

    public void setDisableDraggDrop(boolean isDisableDraggDrop) {
        this.isDisableDraggDrop = isDisableDraggDrop;
    }

    public void close() {
        boolean attached;
        org.zkoss.zul.Tabbox tabbox;
        org.zkoss.zul.Tab tab;
        if (this.isSelected() && (tab = this.selectNextTabWR()) != null) {
            HashSet<org.zkoss.zul.Tab> selItems = new HashSet<org.zkoss.zul.Tab>(2);
            selItems.add(tab);
            Events.postEvent((Event)new SelectEvent("onSelect", (Component)tab, selItems));
        }
        if ((tabbox = this.getTabbox()) != null && tabbox.getModel() != null) {
            return;
        }
        org.zkoss.zul.Tabpanel panel = this.getLinkedPanel();
        if (this.getTabbox() instanceof Tabbox) {
            ((Tabbox)this.getTabbox()).removeTabFromActiveSeq(this);
        }
        boolean bl = attached = this.getDesktop() != null;
        if (panel != null && attached) {
            Executions.schedule((Desktop)this.getDesktop(), e -> panel.detach(), (Event)new Event("onCloseLinkedPanel"));
        }
        this.detach();
        if (panel != null) {
            Component include;
            if (attached && panel.getChildren().size() > 0) {
                Component[] childs;
                Component[] componentArray = childs = panel.getChildren().toArray(new Component[0]);
                int n = childs.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    AEnv.detachInputElement(c);
                    ++n2;
                }
            }
            if ((include = panel.getFirstChild()) instanceof Include) {
                include.detach();
            }
            if (!attached) {
                panel.detach();
            }
        }
    }

    protected org.zkoss.zul.Tab selectNextTabWR() {
        org.zkoss.zul.Tab nextActiveTab;
        Tabbox idTabbox = null;
        if (this.getTabbox() instanceof Tabbox) {
            idTabbox = (Tabbox)this.getTabbox();
        }
        if (idTabbox != null && idTabbox.isActiveBySeq() && (nextActiveTab = idTabbox.getNextActiveBySeq(this)) != null) {
            nextActiveTab.setSelected(true);
            return nextActiveTab;
        }
        org.zkoss.zul.Tab tab = (org.zkoss.zul.Tab)this.getPreviousSibling();
        while (tab != null) {
            if (!tab.isDisabled()) {
                tab.setSelected(true);
                return tab;
            }
            tab = (org.zkoss.zul.Tab)tab.getPreviousSibling();
        }
        tab = (org.zkoss.zul.Tab)this.getNextSibling();
        while (tab != null) {
            if (!tab.isDisabled()) {
                tab.setSelected(true);
                return tab;
            }
            tab = (org.zkoss.zul.Tab)tab.getNextSibling();
        }
        return null;
    }

    public static class DecorateInfo {
        private String imageKey;
        private URL imageIntenalUrl;

        public void decorate(LabelImageElement comp) {
            if (this.imageIntenalUrl != null) {
                if (ThemeManager.isUseFontIconForImage()) {
                    String iconClass = this.imageIntenalUrl.getFile().replace("16.png", "").replaceAll(".*\\/", "");
                    comp.setIconSclass("z-icon-" + iconClass);
                } else {
                    Image image = ManageImageCache.instance().getImage(this.imageIntenalUrl);
                    if (image != null) {
                        comp.setImageContent(image);
                    }
                }
            } else if (this.imageKey != null) {
                if (ThemeManager.isUseFontIconForImage() && this.imageKey.indexOf("://") == -1 && !MAttachment.isAttachmentURLPath((String)this.imageKey)) {
                    String iconClass = this.imageKey;
                    comp.setIconSclass("z-icon-" + iconClass);
                } else {
                    Image ico = ManageImageCache.instance().getImage(this.imageKey);
                    if (ico != null) {
                        comp.setImageContent(ico);
                    } else {
                        comp.setImage(ThemeManager.getThemeResource("images/m" + this.imageKey + ".png"));
                    }
                }
            }
        }

        public DecorateInfo(MImage imageData) {
            if (imageData != null) {
                this.imageIntenalUrl = ManageImageCache.getImageInternalUrl(imageData);
                if (this.imageIntenalUrl == null) {
                    this.imageKey = ManageImageCache.instance().loadImage(imageData);
                }
            }
        }

        public DecorateInfo(String imagePath) {
            if (imagePath != null) {
                this.imageIntenalUrl = ManageImageCache.getImageInternalUrl(imagePath);
                if (this.imageIntenalUrl == null) {
                    this.imageKey = imagePath;
                }
            }
        }

        public static DecorateInfo get(ADWindow adWindow) {
            if (adWindow.getMImage() != null) {
                return new DecorateInfo(adWindow.getMImage());
            }
            return new DecorateInfo("Window");
        }

        public static DecorateInfo get(MInfoWindow mInfo) {
            if (mInfo != null) {
                String image = mInfo.getImageURL();
                MUserDefInfo userDef = MUserDefInfo.getBestMatch((Properties)Env.getCtx(), (int)mInfo.getAD_InfoWindow_ID());
                if (userDef != null && !Util.isEmpty((String)userDef.getImageURL())) {
                    image = userDef.getImageURL();
                }
                return new DecorateInfo(!Util.isEmpty((String)image) ? image : "Info");
            }
            return null;
        }

        public static DecorateInfo get(MForm form) {
            if (form != null) {
                return new DecorateInfo(!Util.isEmpty((String)form.getImageURL()) ? form.getImageURL() : "Form");
            }
            return null;
        }
    }
}

