/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.adempiere.webui.component.Rows;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;

public class Grid
extends org.zkoss.zul.Grid
implements IdSpace {
    private static final long serialVersionUID = -4483759833677794926L;
    private transient Map<String, List<EventListenerInfo>> listeners = new HashMap<String, List<EventListenerInfo>>();

    public void makeNoStrip() {
        this.setOddRowSclass("z-dummy");
    }

    public Rows newRows() {
        Rows rows = new Rows();
        this.appendChild((Component)rows);
        return rows;
    }

    public boolean addEventListener(int priority, String evtnm, EventListener<? extends Event> listener) {
        boolean b = super.addEventListener(priority, evtnm, listener);
        if (b) {
            EventListenerInfo listenerInfo = new EventListenerInfo(priority, listener);
            List<EventListenerInfo> list = this.listeners.get(evtnm);
            if (list != null) {
                Iterator<EventListenerInfo> it = list.iterator();
                while (it.hasNext()) {
                    EventListenerInfo li = it.next();
                    if (!li.listener.equals(listener)) continue;
                    if (li.priority == priority) {
                        return false;
                    }
                    it.remove();
                    break;
                }
                list.add(listenerInfo);
            } else {
                list = new LinkedList<EventListenerInfo>();
                this.listeners.put(evtnm, list);
                list.add(listenerInfo);
            }
        }
        return b;
    }

    public boolean removeEventListener(String evtnm, EventListener<? extends Event> listener) {
        List<EventListenerInfo> list;
        boolean b = super.removeEventListener(evtnm, listener);
        if (b && (list = this.listeners.get(evtnm)) != null) {
            Iterator<EventListenerInfo> it = list.iterator();
            while (it.hasNext()) {
                EventListenerInfo li = it.next();
                if (!li.listener.equals(listener)) continue;
                it.remove();
                break;
            }
        }
        return b;
    }

    public void copyEventListeners(Grid grid) {
        for (String evtnm : this.listeners.keySet()) {
            if (evtnm.equals("onInitModel")) continue;
            List<EventListenerInfo> list = this.listeners.get(evtnm);
            for (EventListenerInfo info : list) {
                grid.addEventListener(info.priority, evtnm, info.listener);
            }
        }
    }

    private static class EventListenerInfo {
        private final int priority;
        private final EventListener<? extends Event> listener;

        private EventListenerInfo(int priority, EventListener<? extends Event> listener) {
            this.priority = priority;
            this.listener = listener;
        }
    }
}

