/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.graph.WDocumentStatusIndicator;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.compiere.model.MDocumentStatus;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;

public class WDocumentStatusPanel
extends Panel {
    private static final long serialVersionUID = 7473476079783059880L;
    private List<WDocumentStatusIndicator> indicatorList = new ArrayList<WDocumentStatusIndicator>();
    private MDocumentStatus[] m_indicators = null;
    private int lastRefreshCount;
    private static final CLogger log = CLogger.getCLogger(WDocumentStatusPanel.class);

    public static WDocumentStatusPanel get() {
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
        MDocumentStatus[] indicators = MDocumentStatus.getDocumentStatusIndicators((Properties)Env.getCtx(), (int)AD_User_ID, (int)AD_Role_ID);
        return new WDocumentStatusPanel(indicators);
    }

    private WDocumentStatusPanel(MDocumentStatus[] indicators) {
        this.m_indicators = indicators;
        this.init();
    }

    private void init() {
        if (log.isLoggable(Level.INFO)) {
            log.info("");
        }
        Grid grid = new Grid();
        this.appendChild((Component)grid);
        grid.setWidth("100%");
        grid.makeNoStrip();
        grid.setOddRowSclass("even");
        grid.setStyle("border: none;");
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        int i = 0;
        while (i < this.m_indicators.length) {
            Row row = new Row();
            rows.appendChild((Component)row);
            WDocumentStatusIndicator pi = new WDocumentStatusIndicator(this.m_indicators[i], true);
            row.appendChild((Component)pi);
            this.indicatorList.add(pi);
            ++i;
        }
    }

    public void refresh() {
        this.lastRefreshCount = 0;
        for (WDocumentStatusIndicator indicator : this.indicatorList) {
            indicator.refresh();
            if (indicator.getDocumentStatus().getAD_Client_ID() != 0) continue;
            this.lastRefreshCount += indicator.getStatusCount();
        }
    }

    public void updateUI() {
        for (WDocumentStatusIndicator indicator : this.indicatorList) {
            indicator.updateUI();
        }
        EventQueue queue = EventQueues.lookup((String)"ActivitiesEventQueue", (boolean)true);
        Event event = new Event("onActivitiesChanged", null, (Object)this.lastRefreshCount);
        queue.publish(event);
    }
}

