/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.form.WCreateFromWindow;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WLocatorEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.grid.CreateFrom;
import org.compiere.grid.CreateFromShipment;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vlayout;

public class WCreateFromShipmentUI
extends CreateFromShipment
implements EventListener<Event>,
ValueChangeListener {
    private WCreateFromWindow window;
    private int p_WindowNo;
    private static final CLogger log = CLogger.getCLogger(WCreateFromShipmentUI.class);
    protected Label bPartnerLabel = new Label();
    protected WEditor bPartnerField;
    protected Label orderLabel = new Label();
    protected Listbox orderField = ListboxFactory.newDropdownListbox();
    protected Label rmaLabel = new Label();
    protected Listbox rmaField = ListboxFactory.newDropdownListbox();
    protected Label invoiceLabel = new Label();
    protected Listbox invoiceField = ListboxFactory.newDropdownListbox();
    protected Checkbox sameWarehouseCb = new Checkbox();
    protected Label locatorLabel = new Label();
    protected WLocatorEditor locatorField = new WLocatorEditor();
    protected Label upcLabel = new Label();
    protected WStringEditor upcField = new WStringEditor();
    private Grid parameterStdLayout;
    private int noOfParameterColumn;
    private boolean m_actionActive = false;

    public WCreateFromShipmentUI(GridTab tab) {
        super(tab);
        if (log.isLoggable(Level.INFO)) {
            log.info(this.getGridTab().toString());
        }
        this.window = new WCreateFromWindow((CreateFrom)this, this.getGridTab().getWindowNo());
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.zkInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            this.setInitOK(false);
            throw new AdempiereException(e.getMessage());
        }
        AEnv.showWindow(this.window);
    }

    protected boolean dynInit() throws Exception {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        super.dynInit();
        this.window.setTitle(this.getTitle());
        this.sameWarehouseCb.setSelected(true);
        this.sameWarehouseCb.addActionListener(this);
        MLocatorLookup locator = new MLocatorLookup(Env.getCtx(), this.p_WindowNo, null);
        this.locatorField = new WLocatorEditor("M_Locator_ID", true, false, true, locator, this.p_WindowNo);
        this.initBPartner(false);
        this.bPartnerField.addValueChangeListener(this);
        this.locatorLabel.setMandatory(true);
        this.upcField = new WStringEditor("UPC", false, false, true, 10, 30, null, null);
        this.upcField.getComponent().addEventListener("onChange", (EventListener)this);
        return true;
    }

    protected void zkInit() throws Exception {
        boolean isRMAWindow = this.getGridTab().getAD_Window_ID() == 53098 || this.getGridTab().getAD_Window_ID() == 53097;
        this.bPartnerLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.orderLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_Order_ID", (boolean)false));
        this.invoiceLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_Invoice_ID", (boolean)false));
        this.rmaLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_RMA_ID"));
        this.locatorLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
        this.sameWarehouseCb.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"FromSameWarehouseOnly", (boolean)true));
        this.sameWarehouseCb.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"FromSameWarehouseOnly", (boolean)false));
        this.upcLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"UPC", (boolean)false));
        Vlayout vlayout = new Vlayout();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)vlayout, "min");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vlayout, "100%");
        Panel parameterPanel = this.window.getParameterPanel();
        parameterPanel.appendChild((Component)vlayout);
        this.parameterStdLayout = GridFactory.newGridLayout();
        vlayout.appendChild((Component)this.parameterStdLayout);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)vlayout, "parameterStdLayout");
        this.setupColumns(this.parameterStdLayout);
        Rows rows = this.parameterStdLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.bPartnerLabel.rightAlign());
        if (this.bPartnerField != null) {
            row.appendChild(this.bPartnerField.getComponent());
            this.bPartnerField.fillHorizontal();
        }
        if (!isRMAWindow) {
            row.appendChild(this.orderLabel.rightAlign());
            row.appendChild((Component)this.orderField);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.orderField, "1");
        }
        row = rows.newRow();
        row.appendChild(this.locatorLabel.rightAlign());
        row.appendChild((Component)this.locatorField.getComponent());
        if (!isRMAWindow) {
            row.appendChild(this.invoiceLabel.rightAlign());
            row.appendChild((Component)this.invoiceField);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.invoiceField, "1");
        }
        row = rows.newRow();
        row.appendChild((Component)new Space());
        row.appendChild((Component)this.sameWarehouseCb);
        row = rows.newRow();
        row.appendChild(this.upcLabel.rightAlign());
        row.appendChild((Component)this.upcField.getComponent());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.upcField.getComponent(), "1");
        if (isRMAWindow) {
            row.appendChild(this.rmaLabel.rightAlign());
            row.appendChild((Component)this.rmaField);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.rmaField, "1");
        }
        if (ClientInfo.isMobile()) {
            if (this.noOfParameterColumn == 2) {
                LayoutUtils.compactTo(this.parameterStdLayout, 2);
            }
            ClientInfo.onClientInfo((Component)this.window, this::onClientInfo);
        }
    }

    public void onEvent(Event e) throws Exception {
        if (this.m_actionActive) {
            return;
        }
        this.m_actionActive = true;
        if (e.getTarget().equals((Object)this.orderField)) {
            KeyNamePair pp = this.orderField.getSelectedItem().toKeyNamePair();
            if (pp != null && pp.getKey() > 0) {
                int C_Order_ID = pp.getKey();
                this.invoiceField.setSelectedIndex(-1);
                this.rmaField.setSelectedIndex(-1);
                this.loadOrder(C_Order_ID, false, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0);
            }
        } else if (e.getTarget().equals((Object)this.invoiceField)) {
            KeyNamePair pp = this.invoiceField.getSelectedItem().toKeyNamePair();
            if (pp != null && pp.getKey() > 0) {
                int C_Invoice_ID = pp.getKey();
                this.orderField.setSelectedIndex(-1);
                this.rmaField.setSelectedIndex(-1);
                this.loadInvoice(C_Invoice_ID, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0);
            }
        } else if (e.getTarget().equals((Object)this.rmaField)) {
            KeyNamePair pp = this.rmaField.getSelectedItem().toKeyNamePair();
            if (pp != null && pp.getKey() > 0) {
                int M_RMA_ID = pp.getKey();
                this.orderField.setSelectedIndex(-1);
                this.invoiceField.setSelectedIndex(-1);
                this.loadRMA(M_RMA_ID, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0);
            }
        } else if (e.getTarget().equals((Object)this.sameWarehouseCb)) {
            int bpId = this.bPartnerField.getValue() == null ? 0 : (Integer)this.bPartnerField.getValue();
            this.initBPOrderDetails(bpId, false);
        } else if (e.getTarget().equals(this.upcField.getComponent())) {
            this.checkProductUsingUPC();
        }
        this.m_actionActive = false;
    }

    private void checkProductUsingUPC() {
        String upc = this.upcField.getDisplay();
        ListModelTable model = this.window.getWListbox().getModel();
        List products = MProduct.getByUPC((Properties)Env.getCtx(), (String)upc, null);
        for (MProduct product : products) {
            int row = this.findProductRow(product.get_ID());
            if (row < 0) continue;
            BigDecimal qty = (BigDecimal)model.getValueAt(row, 1);
            model.setValueAt(qty, row, 1);
            model.setValueAt(Boolean.TRUE, row, 0);
            model.updateComponent(row, row);
        }
        this.upcField.setValue("");
    }

    private int findProductRow(int M_Product_ID) {
        ListModelTable model = this.window.getWListbox().getModel();
        int i = 0;
        while (i < model.getRowCount()) {
            KeyNamePair kp = (KeyNamePair)model.getValueAt(i, 4);
            if (kp.getKey() == M_Product_ID) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void valueChange(ValueChangeEvent e) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(e.getPropertyName() + "=" + String.valueOf(e.getNewValue()));
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            int C_BPartner_ID = 0;
            if (e.getNewValue() != null) {
                C_BPartner_ID = (Integer)e.getNewValue();
            }
            this.initBPOrderDetails(C_BPartner_ID, false);
        }
        this.window.tableChanged(null);
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
        int AD_Column_ID = 3499;
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.bPartnerField = new WSearchEditor("C_BPartner_ID", true, false, true, (Lookup)lookup);
        int C_BPartner_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BPartner_ID");
        this.bPartnerField.setValue(C_BPartner_ID);
        this.initBPOrderDetails(C_BPartner_ID, forInvoice);
    }

    private void initBPInvoiceDetails(int C_BPartner_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_BPartner_ID" + C_BPartner_ID);
        }
        this.invoiceField.removeActionListener(this);
        this.invoiceField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.invoiceField.addItem(pp);
        ArrayList list = this.loadInvoiceData(C_BPartner_ID);
        for (KeyNamePair knp : list) {
            this.invoiceField.addItem(knp);
        }
        this.invoiceField.setSelectedIndex(0);
        this.invoiceField.addActionListener(this);
        this.upcField.addValueChangeListener(this);
    }

    protected void initBPOrderDetails(int C_BPartner_ID, boolean forInvoice) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_BPartner_ID=" + C_BPartner_ID);
        }
        KeyNamePair pp = new KeyNamePair(0, "");
        this.orderField.removeActionListener(this);
        this.orderField.removeAllItems();
        this.orderField.addItem(pp);
        ArrayList list = this.loadOrderData(C_BPartner_ID, forInvoice, this.sameWarehouseCb.isSelected());
        for (KeyNamePair knp : list) {
            this.orderField.addItem(knp);
        }
        int C_Order_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_Order_ID");
        if (C_Order_ID > 0) {
            KeyNamePair knpo;
            this.orderField.setValue(C_Order_ID);
            if (this.orderField.getSelectedItem() != null && (knpo = this.orderField.getSelectedItem().toKeyNamePair()) != null && knpo.getKey() > 0) {
                this.loadOrder(knpo.getKey(), false, this.locatorField.getValue() != null ? (Integer)this.locatorField.getValue() : 0);
            }
        } else {
            this.orderField.setSelectedIndex(0);
        }
        this.orderField.addActionListener(this);
        this.initBPDetails(C_BPartner_ID);
    }

    protected void initBPDetails(int C_BPartner_ID) {
        this.initBPInvoiceDetails(C_BPartner_ID);
        this.initBPRMADetails(C_BPartner_ID);
    }

    private void initBPRMADetails(int C_BPartner_ID) {
        this.rmaField.removeActionListener(this);
        this.rmaField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.rmaField.addItem(pp);
        ArrayList list = this.loadRMAData(C_BPartner_ID);
        for (KeyNamePair knp : list) {
            this.rmaField.addItem(knp);
        }
        this.rmaField.setSelectedIndex(0);
        this.rmaField.addActionListener(this);
    }

    protected void loadOrder(int C_Order_ID, boolean forInvoice, int M_Locator_ID) {
        this.loadTableOIS(this.getOrderData(C_Order_ID, forInvoice, M_Locator_ID));
    }

    protected void loadRMA(int M_RMA_ID, int M_Locator_ID) {
        this.loadTableOIS(this.getRMAData(M_RMA_ID, M_Locator_ID));
    }

    protected void loadInvoice(int C_Invoice_ID, int M_Locator_ID) {
        this.loadTableOIS(this.getInvoiceData(C_Invoice_ID, M_Locator_ID));
    }

    protected void loadTableOIS(Vector<?> data) {
        this.window.getWListbox().clear();
        this.window.getWListbox().getModel().removeTableModelListener(this.window);
        ListModelTable model = new ListModelTable(data);
        model.addTableModelListener(this.window);
        this.window.getWListbox().setData(model, this.getOISColumnNames());
        this.configureMiniTable(this.window.getWListbox());
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public Object getWindow() {
        return this.window;
    }

    protected void setupColumns(Grid parameterGrid) {
        this.noOfParameterColumn = ClientInfo.maxWidth(600) ? 2 : 4;
        Columns columns = new Columns();
        parameterGrid.appendChild((Component)columns);
        if (ClientInfo.maxWidth(600)) {
            Column column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "35%");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "65%");
            columns.appendChild((Component)column);
        } else {
            Column column = new Column();
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "15%");
            columns.appendChild((Component)column);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "35%");
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "15%");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "35%");
            columns.appendChild((Component)column);
        }
    }

    protected void onClientInfo() {
        if (ClientInfo.isMobile() && this.parameterStdLayout != null && this.parameterStdLayout.getRows() != null) {
            int cc;
            int nc = ClientInfo.maxWidth(600) ? 2 : 4;
            if (nc == (cc = this.noOfParameterColumn)) {
                return;
            }
            this.parameterStdLayout.getColumns().detach();
            this.setupColumns(this.parameterStdLayout);
            if (cc > nc) {
                LayoutUtils.compactTo(this.parameterStdLayout, nc);
            } else {
                LayoutUtils.expandTo(this.parameterStdLayout, nc, false);
            }
            ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this.window);
            ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this.window);
            this.window.invalidate();
        }
    }
}

