/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.panel.ADForm;
import org.compiere.model.IMFAMechanism;
import org.compiere.model.MMFAMethod;
import org.compiere.model.MMFARegistration;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Html;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.Window;

@Form
public class MFARegisterForm
extends ADForm {
    private static final long serialVersionUID = 6186035815377577281L;
    private Html msgInstructions;
    private Html msgAdditional;
    private Label codeLabel;
    private Textbox codeBox;
    private Label nameLabel;
    private Textbox nameBox;
    private Checkbox prefBox;
    private ConfirmPanel confirmPanel;
    private int pInstanceId;
    private MMFARegistration registration = null;

    @Override
    protected void initForm() {
        this.setClosable(true);
        this.setSizable(true);
        Grid grid = GridFactory.newGridLayout();
        grid.setHeight("100%");
        grid.setWidth("100%");
        this.appendChild((Component)grid);
        Columns columns = new Columns();
        grid.appendChild((Component)columns);
        Column column = new Column();
        column.setWidth("5%");
        columns.appendChild((Component)column);
        column = new Column();
        column.setWidth("30%");
        columns.appendChild((Component)column);
        column = new Column();
        column.setWidth("60%");
        columns.appendChild((Component)column);
        column = new Column();
        column.setWidth("10%");
        columns.appendChild((Component)column);
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = rows.newRow();
        row = rows.newRow();
        this.msgInstructions = new Html();
        row.appendCellChild((Component)this.msgInstructions, 4);
        this.msgInstructions.setHflex("1");
        row = rows.newRow();
        this.msgAdditional = new Html();
        row.appendCellChild((Component)this.msgAdditional, 4);
        this.msgAdditional.setHflex("1");
        row = rows.newRow();
        this.codeLabel = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"MFAValidationCode"));
        row.appendCellChild((Component)this.codeLabel, 2);
        this.codeBox = new Textbox();
        row.appendCellChild((Component)this.codeBox, 2);
        row = rows.newRow();
        this.nameLabel = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Name"));
        row.appendCellChild((Component)this.nameLabel, 2);
        this.nameBox = new Textbox();
        row.appendCellChild((Component)this.nameBox, 2);
        row = rows.newRow();
        row.appendCellChild((Component)new Separator(), 2);
        this.prefBox = new Checkbox();
        this.prefBox.setLabel(Msg.getElement((Properties)Env.getCtx(), (String)"IsUserMFAPreferred"));
        row.appendCellChild((Component)this.prefBox, 2);
        row = rows.newRow();
        this.confirmPanel = new ConfirmPanel(true);
        row.appendCellChild((Component)new Space());
        row.appendCellChild((Component)this.confirmPanel, 3);
        this.confirmPanel.addActionListener("onClick", evt -> this.onConfirmPanelAction(evt));
        this.setHeight(null);
        this.setWidth("350px");
        this.setVflex("min");
    }

    @Override
    public Window.Mode getWindowMode() {
        return Window.Mode.HIGHLIGHTED;
    }

    private void onConfirmPanelAction(Event evt) {
        if (evt.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.detach();
        } else if (evt.getTarget() == this.confirmPanel.getButton("Ok")) {
            String msg;
            if (this.codeBox.isDisabled()) {
                this.detach();
            }
            if (Util.isEmpty((String)this.codeBox.getValue())) {
                throw new WrongValueException((Component)this.codeBox, Msg.getMsg((Properties)Env.getCtx(), (String)"MFACodeRequired"));
            }
            Timestamp now = new Timestamp(System.currentTimeMillis());
            if (this.registration.getExpiration() != null && now.after(this.registration.getExpiration())) {
                throw new WrongValueException((Component)this.codeBox, Msg.getMsg((Properties)Env.getCtx(), (String)"MFARegistrationExpired"));
            }
            MMFAMethod method = new MMFAMethod(Env.getCtx(), this.registration.getMFA_Method_ID(), this.registration.get_TrxName());
            IMFAMechanism mechanism = method.getMFAMechanism();
            try {
                msg = mechanism.complete(Env.getCtx(), this.registration, this.codeBox.getValue(), this.nameBox.getValue(), this.prefBox.isChecked(), this.registration.get_TrxName());
            }
            catch (Exception e) {
                Object err = !Util.isEmpty((String)e.getLocalizedMessage()) ? e.getLocalizedMessage() : Msg.getMsg((Properties)Env.getCtx(), (String)"Error") + " = " + e.toString();
                throw new WrongValueException((Component)this.codeBox, (String)err);
            }
            this.codeBox.setDisabled(true);
            this.nameBox.setDisabled(true);
            this.prefBox.setDisabled(true);
            this.msgInstructions.setContent(msg);
            this.msgAdditional.setContent(null);
            this.confirmPanel.getButton("Cancel").setDisabled(true);
            this.confirmPanel.getButton("Cancel").setVisible(false);
        }
    }

    public void completeRegistration(Object[] retArray, int pInstanceId) {
        this.pInstanceId = pInstanceId;
        String instructions = retArray[0].toString();
        StringBuilder additionalInstructions = new StringBuilder();
        int i = 1;
        while (i < retArray.length) {
            if (retArray[i] instanceof String) {
                String reti;
                if (additionalInstructions.length() > 0) {
                    additionalInstructions.append("<br>");
                }
                if ((reti = (String)retArray[i]).startsWith("data:image/png;base64,")) {
                    additionalInstructions.append("<img src=\"" + reti.toString() + "\" width=\"180\" height=\"180\"/>");
                } else {
                    additionalInstructions.append(reti.toString());
                }
            } else if (retArray[i] instanceof MMFARegistration) {
                this.registration = (MMFARegistration)retArray[i];
            }
            ++i;
        }
        this.msgInstructions.setContent(instructions);
        this.msgAdditional.setContent(additionalInstructions.toString());
        this.nameBox.setValue(this.registration.getName());
        this.registration.set_TrxName(null);
    }
}

