/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.util.Properties;
import org.adempiere.base.IServiceHolder;
import org.adempiere.webui.action.Actions;
import org.adempiere.webui.action.IAction;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.component.ToolBarButton;
import org.compiere.model.MToolBarButton;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Util;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Toolbarbutton;

public class ToolbarCustomButton
implements EventListener<Event>,
Evaluatee {
    private Toolbarbutton toolbarButton;
    private String actionId;
    private int windowNo;
    private int tabNo = -1;
    private MToolBarButton mToolbarButton;

    public ToolbarCustomButton(MToolBarButton mToolbarButton, Toolbarbutton btn, String actionId, int windowNo) {
        this(mToolbarButton, btn, actionId, windowNo, -1);
    }

    public ToolbarCustomButton(MToolBarButton mToolbarButton, Toolbarbutton btn, String actionId, int windowNo, int tabNo) {
        this.toolbarButton = btn;
        this.actionId = actionId;
        this.windowNo = windowNo;
        this.tabNo = tabNo;
        this.mToolbarButton = mToolbarButton;
        this.toolbarButton.addEventListener("onClick", (EventListener)this);
    }

    public void onEvent(Event event) throws Exception {
        IAction action;
        IServiceHolder<IAction> serviceHolder = Actions.getAction(this.actionId);
        if (serviceHolder != null && (action = (IAction)serviceHolder.getService()) != null) {
            action.execute(ADWindow.get(this.windowNo));
        }
    }

    public String get_ValueAsString(String variableName) {
        int tabNo;
        ADWindow adwindow = ADWindow.get(this.windowNo);
        if (adwindow == null) {
            return "";
        }
        IADTabpanel adTabpanel = adwindow.getADWindowContent().getADTab().getSelectedTabpanel();
        if (adTabpanel == null) {
            return "";
        }
        int n = tabNo = this.tabNo >= 0 ? this.tabNo : adTabpanel.getTabNo();
        if (tabNo == 0) {
            return adTabpanel.get_ValueAsString(variableName);
        }
        DefaultEvaluatee evaluatee = new DefaultEvaluatee(adTabpanel.getGridTab(), this.windowNo, tabNo, false, true);
        return evaluatee.get_ValueAsString(variableName);
    }

    public void dynamicDisplay() {
        this.dynamicDisplay(false);
    }

    public void dynamicDisplay(boolean forceValidation) {
        if (this.toolbarButton.getParent() == null && !forceValidation) {
            return;
        }
        String displayLogic = this.mToolbarButton.getDisplayLogic();
        if (displayLogic == null || displayLogic.trim().length() == 0) {
            return;
        }
        boolean visible = true;
        if (displayLogic.startsWith("@SQL=")) {
            ADWindow adwindow = ADWindow.get(this.windowNo);
            if (adwindow == null) {
                return;
            }
            IADTabpanel adTabpanel = adwindow.getADWindowContent().getADTab().getSelectedTabpanel();
            if (adTabpanel == null) {
                return;
            }
            visible = Evaluator.parseSQLLogic((String)displayLogic, (Properties)Env.getCtx(), (int)this.windowNo, (int)adTabpanel.getTabNo(), (String)this.mToolbarButton.getActionName());
        } else {
            visible = Evaluator.evaluateLogic((Evaluatee)this, (String)displayLogic);
        }
        this.toolbarButton.setVisible(visible);
    }

    public void pressedLogic() {
        if (this.toolbarButton.getParent() == null) {
            return;
        }
        String pressedLogic = this.mToolbarButton.getPressedLogic();
        if (Util.isEmpty((String)pressedLogic, (boolean)true)) {
            return;
        }
        ADWindow window = ADWindow.get(this.windowNo);
        if (window == null) {
            return;
        }
        IADTabpanel adTabpanel = window.getADWindowContent().getADTab().getSelectedTabpanel();
        if (adTabpanel == null || adTabpanel.getRecord_ID() <= 0) {
            return;
        }
        boolean isPressed = this.validateLogic(pressedLogic, adTabpanel.getTabNo());
        ((ToolBarButton)this.toolbarButton).setPressed(isPressed);
    }

    public void readOnlyLogic() {
        if (this.toolbarButton.getParent() == null) {
            return;
        }
        String readOnlyLogic = this.mToolbarButton.getReadOnlyLogic();
        if (Util.isEmpty((String)readOnlyLogic, (boolean)true)) {
            return;
        }
        ADWindow window = ADWindow.get(this.windowNo);
        if (window == null) {
            return;
        }
        IADTabpanel adTabpanel = window.getADWindowContent().getADTab().getSelectedTabpanel();
        if (adTabpanel == null || adTabpanel.getRecord_ID() <= 0) {
            return;
        }
        boolean isReadOnly = this.validateLogic(readOnlyLogic, adTabpanel.getTabNo());
        this.toolbarButton.setDisabled(isReadOnly);
    }

    private boolean validateLogic(String logic, int tabNo) {
        boolean isValid = false;
        isValid = logic.startsWith("@SQL=") ? Evaluator.parseSQLLogic((String)logic, (Properties)Env.getCtx(), (int)this.windowNo, (int)tabNo, (String)"") : Evaluator.evaluateLogic((Evaluatee)this, (String)logic);
        return isValid;
    }

    public Toolbarbutton getToolbarbutton() {
        return this.toolbarButton;
    }
}

