/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.acct;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.acct.WAcctViewerData;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.VerticalBox;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.DateRangeButton;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MAuthorizationAccount;
import org.compiere.model.MColumn;
import org.compiere.model.MPeriod;
import org.compiere.model.MSysConfig;
import org.compiere.report.core.RModel;
import org.compiere.report.core.RModelExcelExporter;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.idempiere.ui.zk.media.IMediaView;
import org.idempiere.ui.zk.media.Medias;
import org.idempiere.ui.zk.media.WMediaOptions;
import org.zkoss.util.media.AMedia;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Center;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Paging;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Window;

public class WAcctViewer
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 3440375640756094077L;
    private static final String TITLE = "Posting";
    private static final int PAGE_SIZE = 1000;
    private WAcctViewerData m_data = null;
    private Listbox selAcctSchema = new Listbox();
    private Listbox selTable = new Listbox();
    private Listbox selPostingType = new Listbox();
    private Listbox selOrg = new Listbox();
    private Listbox sortBy1 = new Listbox();
    private Listbox sortBy2 = new Listbox();
    private Listbox sortBy3 = new Listbox();
    private Listbox sortBy4 = new Listbox();
    private Button selRecord = new Button();
    private Button selAcct = new Button();
    private Button bQuery = new Button();
    private Button bRePost = new Button();
    private Button bExport = new Button();
    private Button bZoom = new Button();
    private Button sel1 = new Button();
    private Button sel2 = new Button();
    private Button sel3 = new Button();
    private Button sel4 = new Button();
    private Button sel5 = new Button();
    private Button sel6 = new Button();
    private Button sel7 = new Button();
    private Button sel8 = new Button();
    private Label statusLine = new Label();
    private Label lsel1 = new Label();
    private Label lsel2 = new Label();
    private Label lsel3 = new Label();
    private Label lsel4 = new Label();
    private Label lsel5 = new Label();
    private Label lsel6 = new Label();
    private Label lsel7 = new Label();
    private Label lsel8 = new Label();
    private Label lacctSchema = new Label();
    private Label lpostingType = new Label();
    private Label lOrg = new Label();
    private Label lAcct = new Label();
    private Label lDate = new Label();
    private Label lSort = new Label();
    private Label lGroup = new Label();
    private WDateEditor selDateFrom = new WDateEditor();
    private WDateEditor selDateTo = new WDateEditor();
    private Checkbox selDocument = new Checkbox();
    private Checkbox displayQty = new Checkbox();
    private Checkbox displaySourceAmt = new Checkbox();
    private Checkbox displayDocumentInfo = new Checkbox();
    private Checkbox group1 = new Checkbox();
    private Checkbox group2 = new Checkbox();
    private Checkbox group3 = new Checkbox();
    private Checkbox group4 = new Checkbox();
    private Checkbox forcePost = new Checkbox();
    private Tabbox tabbedPane = new Tabbox();
    private Listbox table = new Listbox();
    private Paging paging = new Paging();
    private VerticalBox displayPanel = new VerticalBox();
    private VerticalBox selectionPanel = new VerticalBox();
    private Tab tabQuery = new Tab();
    private Tab tabResult = new Tab();
    private Tabs tabs = new Tabs();
    private Tabpanel result = new Tabpanel();
    private Tabpanel query = new Tabpanel();
    private Tabpanels tabpanels = new Tabpanels();
    private Hlayout southPanel = new Hlayout();
    private int m_windowNo;
    private ArrayList<ArrayList<Object>> m_queryData;
    private South pagingPanel;
    private Borderlayout resultPanel;
    private RModel m_rmodel;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private static final CLogger log = CLogger.getCLogger(WAcctViewer.class);

    public WAcctViewer() {
        this(0, 0, 0);
    }

    public WAcctViewer(int AD_Client_ID, int AD_Table_ID, int Record_ID) {
        if (log.isLoggable(Level.INFO)) {
            log.info("AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID);
        }
        this.m_windowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.m_data = new WAcctViewerData(Env.getCtx(), this.m_windowNo, AD_Client_ID, AD_Table_ID);
        try {
            this.init();
            this.dynInit(AD_Table_ID, Record_ID);
            this.setAttribute("mode", "embedded");
            this.setAttribute("insertPosition", "insertNext");
            this.setAttribute("desktop.windowno", this.m_windowNo);
            SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
            this.addEventListener("onCloseWindowShortcut", this);
            AEnv.showWindow(this);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    private void init() throws Exception {
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.selectionPanel, "1");
        Grid grid = new Grid();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)grid, "1");
        grid.setSclass("grid-layout");
        this.selectionPanel.appendChild((Component)grid);
        Columns columns = new Columns();
        grid.appendChild((Component)columns);
        Column column = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "30%");
        columns.appendChild((Component)column);
        column = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "60%");
        columns.appendChild((Component)column);
        Rows rows = grid.newRows();
        this.lacctSchema.setValue(Msg.translate((Properties)Env.getCtx(), (String)"C_AcctSchema_ID"));
        this.selAcctSchema.setMold("select");
        this.selAcctSchema.setRows(1);
        Row row = rows.newRow();
        row.appendChild((Component)this.lacctSchema);
        row.appendChild((Component)this.selAcctSchema);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.selAcctSchema, "1");
        this.selDocument.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"SelectDocument"));
        this.selDocument.addEventListener("onCheck", this);
        this.selTable.setMold("select");
        this.selTable.setRows(1);
        row = rows.newRow();
        row.appendChild((Component)this.selDocument);
        Hlayout hlayout = new Hlayout();
        hlayout.appendChild((Component)this.selTable);
        hlayout.appendChild((Component)this.selRecord);
        row.appendChild((Component)hlayout);
        this.lpostingType.setValue(Msg.translate((Properties)Env.getCtx(), (String)"PostingType"));
        this.selPostingType.setMold("select");
        this.selPostingType.setRows(1);
        this.selPostingType.addEventListener("onClick", this);
        row = rows.newRow();
        row.appendChild((Component)this.lpostingType);
        row.appendChild((Component)this.selPostingType);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.selPostingType, "1");
        this.lDate.setValue(Msg.translate((Properties)Env.getCtx(), (String)"DateAcct"));
        row = rows.newRow();
        row.appendChild((Component)this.lDate);
        hlayout = new Hlayout();
        hlayout.appendChild((Component)this.selDateFrom.getComponent());
        hlayout.appendChild((Component)new Label(" - "));
        hlayout.appendChild((Component)this.selDateTo.getComponent());
        DateRangeButton drb = new DateRangeButton(this.selDateFrom, this.selDateTo);
        hlayout.appendChild((Component)drb);
        row.appendChild((Component)hlayout);
        this.lOrg.setValue(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        this.selOrg.setMold("select");
        this.selOrg.setRows(1);
        this.selOrg.addEventListener("onSelect", this);
        row = rows.newRow();
        row.appendChild((Component)this.lOrg);
        row.appendChild((Component)this.selOrg);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.selOrg, "1");
        this.lAcct.setValue(Msg.translate((Properties)Env.getCtx(), (String)"Account_ID"));
        row = rows.newRow();
        row.appendChild((Component)this.lAcct);
        row.appendChild((Component)this.selAcct);
        row = rows.newRow();
        row.appendChild((Component)this.lsel1);
        row.appendChild((Component)this.sel1);
        row = rows.newRow();
        row.appendChild((Component)this.lsel2);
        row.appendChild((Component)this.sel2);
        row = rows.newRow();
        row.appendChild((Component)this.lsel3);
        row.appendChild((Component)this.sel3);
        row = rows.newRow();
        row.appendChild((Component)this.lsel4);
        row.appendChild((Component)this.sel4);
        row = rows.newRow();
        row.appendChild((Component)this.lsel5);
        row.appendChild((Component)this.sel5);
        row = rows.newRow();
        row.appendChild((Component)this.lsel6);
        row.appendChild((Component)this.sel6);
        row = rows.newRow();
        row.appendChild((Component)this.lsel7);
        row.appendChild((Component)this.sel7);
        row = rows.newRow();
        row.appendChild((Component)this.lsel8);
        row.appendChild((Component)this.sel8);
        this.displayDocumentInfo.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"DisplayDocumentInfo"));
        this.displayDocumentInfo.addEventListener("onClick", this);
        this.displaySourceAmt.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"DisplaySourceInfo"));
        this.displaySourceAmt.addEventListener("onCheck", this);
        this.displayQty.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"DisplayQty"));
        this.displayQty.addEventListener("onCheck", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.displayPanel, "100%");
        this.displayPanel.appendChild((Component)this.displayDocumentInfo);
        this.displayPanel.appendChild((Component)this.displaySourceAmt);
        this.displayPanel.appendChild((Component)this.displayQty);
        this.displayPanel.appendChild((Component)new Space());
        grid = new Grid();
        grid.setSclass("grid-layout");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)grid, "1");
        this.displayPanel.appendChild((Component)grid);
        columns = new Columns();
        grid.appendChild((Component)columns);
        column = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "70%");
        columns.appendChild((Component)column);
        column = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "30%");
        columns.appendChild((Component)column);
        rows = grid.newRows();
        row = rows.newRow();
        this.lSort.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"SortBy"));
        this.lGroup.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"GroupBy"));
        row.appendChild((Component)this.lSort);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.lSort, "1");
        row.appendChild((Component)this.lGroup);
        row = rows.newRow();
        this.sortBy1.setMold("select");
        this.sortBy1.setRows(1);
        row.appendChild((Component)this.sortBy1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.sortBy1, "1");
        row.appendChild((Component)this.group1);
        row = rows.newRow();
        this.sortBy2.setMold("select");
        this.sortBy2.setRows(1);
        row.appendChild((Component)this.sortBy2);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.sortBy2, "1");
        row.appendChild((Component)this.group2);
        row = rows.newRow();
        this.sortBy3.setMold("select");
        this.sortBy3.setRows(1);
        row.appendChild((Component)this.sortBy3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.sortBy3, "1");
        row.appendChild((Component)this.group3);
        row = rows.newRow();
        this.sortBy4.setMold("select");
        this.sortBy4.setRows(1);
        row.appendChild((Component)this.sortBy4);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.sortBy4, "1");
        row.appendChild((Component)this.group4);
        Groupbox groupDisplay = new Groupbox();
        Caption capDisplay = new Caption(Msg.getMsg((Properties)Env.getCtx(), (String)"Display"));
        groupDisplay.appendChild((Component)capDisplay);
        groupDisplay.appendChild((Component)this.displayPanel);
        Groupbox groupSelection = new Groupbox();
        Caption capSelection = new Caption(Msg.getMsg((Properties)Env.getCtx(), (String)"Selection"));
        groupSelection.appendChild((Component)capSelection);
        groupSelection.appendChild((Component)this.selectionPanel);
        Hlayout boxQueryPanel = new Hlayout();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)boxQueryPanel, "3");
        boxQueryPanel.appendChild((Component)groupSelection);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)groupSelection, "2");
        Separator separator = new Separator();
        separator.setOrient("vertical");
        boxQueryPanel.appendChild((Component)separator);
        boxQueryPanel.appendChild((Component)groupDisplay);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)groupDisplay, "1");
        this.bRePost.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"RePost")));
        this.bRePost.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"RePostInfo")));
        this.bRePost.addEventListener("onClick", this);
        this.bRePost.setVisible(false);
        this.forcePost.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Force")));
        this.forcePost.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"ForceInfo")));
        this.forcePost.setVisible(false);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bZoom.setIconSclass("z-icon-Zoom");
        } else {
            this.bZoom.setImage(ThemeManager.getThemeResource("images/Zoom16.png"));
        }
        this.bZoom.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Zoom")));
        this.bZoom.setVisible(this.tabbedPane.getSelectedIndex() == 1);
        this.bZoom.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bQuery.setIconSclass("z-icon-Refresh");
        } else {
            this.bQuery.setImage(ThemeManager.getThemeResource("images/Refresh16.png"));
        }
        this.bQuery.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")));
        this.bQuery.addEventListener("onClick", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.bExport.setIconSclass("z-icon-Export");
        } else {
            this.bExport.setImage(ThemeManager.getThemeResource("images/Export16.png"));
        }
        this.bExport.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Export")));
        this.bExport.addEventListener("onClick", this);
        this.bExport.setVisible(false);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.southPanel, "5");
        Grid southLeftGrid = new Grid();
        southLeftGrid.setSclass("grid-layout");
        this.southPanel.appendChild((Component)southLeftGrid);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)southLeftGrid, "4");
        rows = southLeftGrid.newRows();
        Row southLeft = rows.newRow();
        Hlayout repostLayout = new Hlayout();
        southLeft.appendChild((Component)repostLayout);
        repostLayout.appendChild((Component)this.bRePost);
        repostLayout.appendChild((Component)new Separator());
        repostLayout.appendChild((Component)this.forcePost);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)repostLayout, "1");
        southLeft.appendChild((Component)this.statusLine);
        Grid southRight = new Grid();
        southRight.setSclass("grid-layout");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)southRight, "1");
        this.southPanel.appendChild((Component)southRight);
        Panel southRightPanel = new Panel();
        southRightPanel.appendChild((Component)this.bZoom);
        southRightPanel.appendChild((Component)this.bExport);
        southRightPanel.appendChild((Component)this.bQuery);
        rows = southRight.newRows();
        row = rows.newRow();
        row.setAlign("right");
        row.appendChild((Component)southRightPanel);
        this.resultPanel = new Borderlayout();
        this.resultPanel.setStyle("position: absolute");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.resultPanel, "99%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.resultPanel, "99%");
        this.result.appendChild((Component)this.resultPanel);
        Center resultCenter = new Center();
        this.resultPanel.appendChild((Component)resultCenter);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.table, "1");
        ZKUpdateUtil.setVflex(this.table, true);
        resultCenter.appendChild((Component)this.table);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.table, "1");
        this.table.addEventListener("onDoubleClick", this);
        if (ClientInfo.isMobile()) {
            this.table.setSizedByContent(true);
        }
        this.pagingPanel = new South();
        this.resultPanel.appendChild((Component)this.pagingPanel);
        this.pagingPanel.appendChild((Component)this.paging);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.result, "1");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.result, "100%");
        this.result.setStyle("position: relative");
        this.paging.addEventListener("onPaging", (EventListener)this);
        this.paging.setAutohide(true);
        this.paging.setDetailed(true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.query, "1");
        this.query.appendChild((Component)boxQueryPanel);
        this.tabQuery.addEventListener("onSelect", this);
        this.tabQuery.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ViewerQuery").replaceAll("[&]", ""));
        this.tabResult.addEventListener("onSelect", this);
        this.tabResult.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ViewerResult").replaceAll("[&]", ""));
        this.tabs.appendChild((Component)this.tabQuery);
        this.tabs.appendChild((Component)this.tabResult);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabpanels, "1");
        this.tabpanels.appendChild((Component)this.query);
        this.tabpanels.appendChild((Component)this.result);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabbedPane, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbedPane, "1");
        this.tabbedPane.appendChild((Component)this.tabs);
        this.tabbedPane.appendChild((Component)this.tabpanels);
        Borderlayout layout = new Borderlayout();
        layout.setParent((Component)this);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)layout, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, "100%");
        layout.setStyle("background-color: transparent; margin: 0; position: relative; padding: 0;");
        Center center = new Center();
        center.setParent((Component)layout);
        center.setStyle("background-color: transparent; padding: 2px;");
        this.tabbedPane.setParent((Component)center);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabbedPane, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbedPane, "1");
        South south = new South();
        south.setParent((Component)layout);
        south.setStyle("background-color: transparent");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)south, "36px");
        this.southPanel.setParent((Component)south);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.southPanel, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.southPanel, "1");
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)TITLE));
        this.setClosable(true);
        this.setStyle("position: relative; width: 100%; height: 100%;");
        this.setSizable(true);
        this.setMaximizable(true);
    }

    private void dynInit(int AD_Table_ID, int Record_ID) {
        this.m_data.validateAcctSchemas(Record_ID);
        this.m_data.fillAcctSchema(this.selAcctSchema);
        this.selAcctSchema.addEventListener("onSelect", this);
        this.selAcctSchema.setSelectedIndex(0);
        this.actionAcctSchema();
        this.m_data.fillTable(this.selTable);
        this.selTable.addEventListener("onSelect", this);
        if (ThemeManager.isUseFontIconForImage()) {
            this.selRecord.setIconSclass("z-icon-Find");
        } else {
            this.selRecord.setImage(ThemeManager.getThemeResource("images/Find16.png"));
        }
        this.selRecord.addEventListener("onClick", this);
        this.selRecord.setLabel("");
        this.m_data.fillPostingType(this.selPostingType);
        this.selPostingType.setSelectedIndex(0);
        this.m_data.fillOrg(this.selOrg);
        this.selAcct.setName("Account_ID");
        this.selAcct.addEventListener("onClick", this);
        this.selAcct.setLabel("");
        if (ThemeManager.isUseFontIconForImage()) {
            this.selAcct.setIconSclass("z-icon-Find");
        } else {
            this.selAcct.setImage(ThemeManager.getThemeResource("images/Find16.png"));
        }
        this.statusLine.setValue(" " + Msg.getMsg((Properties)Env.getCtx(), (String)"ViewerOptions"));
        this.selOrg.setSelectedIndex(0);
        this.sortBy1.setSelectedIndex(0);
        this.sortBy2.setSelectedIndex(0);
        this.sortBy3.setSelectedIndex(0);
        this.sortBy4.setSelectedIndex(0);
        boolean haveDoc = AD_Table_ID != 0 && Record_ID != 0;
        this.selDocument.setChecked(haveDoc);
        this.actionDocument();
        if (!haveDoc) {
            this.selTable.setSelectedIndex(0);
            this.actionTable();
        } else if (this.setSelectedTable(AD_Table_ID, Record_ID)) {
            this.actionQuery();
        } else {
            haveDoc = false;
            this.selDocument.setChecked(haveDoc);
            this.actionDocument();
            this.selTable.setSelectedIndex(0);
            this.actionTable();
        }
        if (this.tabResult.isSelected()) {
            this.stateChanged();
        }
    }

    private boolean setSelectedTable(int AD_Table_ID, int Record_ID) {
        int cnt = this.selTable.getItemCount();
        ValueNamePair vp = null;
        int i = 0;
        while (i < cnt) {
            ListItem listitem = this.selTable.getItemAtIndex(i);
            vp = (ValueNamePair)listitem.getValue();
            int tableId = this.m_data.tableInfo.get(vp.getValue());
            if (tableId == AD_Table_ID) {
                this.selTable.setSelectedIndex(i);
                this.m_data.AD_Table_ID = AD_Table_ID;
                this.m_data.Record_ID = Record_ID;
                this.selRecord.setLabel("");
                this.selRecord.setName(vp.getValue() + "_ID");
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void dispose() {
        this.m_data.dispose();
        this.m_data = null;
        this.detach();
    }

    public void stateChanged() {
        boolean visible = this.m_data.documentQuery && this.tabResult.isSelected();
        this.bRePost.setVisible(visible && !Env.isReadOnlySession());
        this.bExport.setVisible(this.tabResult.isSelected());
        this.bZoom.setVisible(this.tabResult.isSelected());
        this.forcePost.setVisible(visible && !Env.isReadOnlySession());
    }

    public void onEvent(Event e) throws Exception {
        Component source = e.getTarget();
        if (source == this.tabResult) {
            this.stateChanged();
        } else if (source == this.tabQuery) {
            this.stateChanged();
        } else if (source == this.selAcctSchema) {
            this.actionAcctSchema();
        } else if (source == this.bQuery) {
            this.actionQuery();
        } else if (source == this.selDocument) {
            this.actionDocument();
        } else if (source == this.selTable) {
            this.actionTable();
        } else if (source == this.bRePost) {
            this.actionRePost();
        } else if (source == this.bExport) {
            this.actionExport();
        } else if (source == this.bZoom) {
            this.actionZoom();
        } else if (source instanceof Button) {
            this.actionButton((Button)source);
        } else if (source == this.paging) {
            int pgno = this.paging.getActivePage();
            int start = pgno * 1000;
            int end = start + 1000;
            if (end > this.paging.getTotalSize()) {
                end = this.paging.getTotalSize();
            }
            List<ArrayList<Object>> list = this.m_queryData.subList(start, end);
            ListModelTable model = new ListModelTable(list);
            this.table.setModel((ListModel)model);
        } else if ("onDoubleClick".equals(e.getName()) && source instanceof Listbox && source == this.table) {
            this.actionZoomFactAcct();
        } else if (e.getName().equals("onCtrlKey")) {
            KeyEvent keyEvent = (KeyEvent)e;
            if (LayoutUtils.isReallyVisible((Component)this)) {
                this.onCtrlKeyEvent(keyEvent);
            }
        } else if ("onCloseWindowShortcut".equals(e.getName())) {
            IDesktop desktop = SessionManager.getAppDesktop();
            if (this.m_windowNo > 0 && desktop.isCloseTabWithShortcut()) {
                desktop.closeWindow(this.m_windowNo);
            } else {
                desktop.setCloseTabWithShortcut(true);
            }
        }
    }

    private void actionExport() {
        if (this.m_rmodel != null && this.m_rmodel.getRowCount() > 0) {
            RModelExcelExporter exporter = new RModelExcelExporter(this.m_rmodel);
            try {
                File file = new File(FileUtil.getTempMailName((String)Msg.getMsg((Properties)Env.getCtx(), (String)TITLE), (String)".xlsx"));
                exporter.export(file, Env.getLanguage((Properties)Env.getCtx()));
                AMedia media = new AMedia(file.getName(), null, Medias.EXCEL_XML_MIME_TYPE, file, true);
                IMediaView view = Extensions.getMediaView(Medias.EXCEL_XML_MIME_TYPE, "xlsx", ClientInfo.isMobile());
                Map uploadServicesMap = MAuthorizationAccount.getUserUploadServices();
                if (view != null || uploadServicesMap.size() > 0) {
                    WMediaOptions options = new WMediaOptions(media, view != null ? () -> {
                        Window viewWindow = new Window();
                        viewWindow.setWidth("100%");
                        viewWindow.setHeight("100%");
                        viewWindow.setTitle(media.getName());
                        viewWindow.setAttribute("mode", Window.Mode.EMBEDDED);
                        AEnv.showWindow(viewWindow);
                        view.renderMediaView((Component)viewWindow, media, false);
                    } : null, uploadServicesMap);
                    options.setPage(this.getPage());
                    options.doHighlighted();
                } else {
                    Filedownload.save((File)file, (String)Medias.EXCEL_XML_MIME_TYPE);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void actionAcctSchema() {
        ListItem listitem = this.selAcctSchema.getSelectedItem();
        KeyNamePair kp = null;
        if (listitem != null) {
            kp = (KeyNamePair)listitem.getValue();
        }
        if (kp == null) {
            return;
        }
        this.m_data.C_AcctSchema_ID = kp.getKey();
        this.m_data.ASchema = MAcctSchema.get((Properties)Env.getCtx(), (int)this.m_data.C_AcctSchema_ID);
        if (log.isLoggable(Level.INFO)) {
            log.info(this.m_data.ASchema.toString());
        }
        this.sortBy1.getChildren().clear();
        this.sortBy2.getChildren().clear();
        this.sortBy3.getChildren().clear();
        this.sortBy4.getChildren().clear();
        this.sortAddItem(new ValueNamePair("", ""));
        this.sortAddItem(new ValueNamePair("DateAcct", Msg.translate((Properties)Env.getCtx(), (String)"DateAcct")));
        this.sortAddItem(new ValueNamePair("DateTrx", Msg.translate((Properties)Env.getCtx(), (String)"DateTrx")));
        this.sortAddItem(new ValueNamePair("C_Period_ID", Msg.translate((Properties)Env.getCtx(), (String)"C_Period_ID")));
        Label[] labels = new Label[]{this.lsel1, this.lsel2, this.lsel3, this.lsel4, this.lsel5, this.lsel6, this.lsel7, this.lsel8};
        Button[] buttons = new Button[]{this.sel1, this.sel2, this.sel3, this.sel4, this.sel5, this.sel6, this.sel7, this.sel8};
        int selectionIndex = 0;
        MAcctSchemaElement[] elements = this.m_data.ASchema.getAcctSchemaElements();
        int i = 0;
        while (i < elements.length && selectionIndex < labels.length) {
            MAcctSchemaElement ase = elements[i];
            String columnName = ase.getColumnName();
            String displayColumnName = ase.getDisplayColumnName();
            this.sortAddItem(new ValueNamePair(columnName, Msg.translate((Properties)Env.getCtx(), (String)displayColumnName)));
            if (!ase.isElementType("OO") && !ase.isElementType("AC")) {
                labels[selectionIndex].setValue(Msg.translate((Properties)Env.getCtx(), (String)displayColumnName));
                labels[selectionIndex].setVisible(true);
                buttons[selectionIndex].setName(columnName);
                buttons[selectionIndex].addEventListener("onClick", this);
                if (ThemeManager.isUseFontIconForImage()) {
                    buttons[selectionIndex].setIconSclass("z-icon-Find");
                } else {
                    buttons[selectionIndex].setImage(ThemeManager.getThemeResource("images/Find16.png"));
                }
                buttons[selectionIndex].setLabel("");
                buttons[selectionIndex].setVisible(true);
                ++selectionIndex;
            }
            ++i;
        }
        while (selectionIndex < labels.length) {
            labels[selectionIndex].setVisible(false);
            buttons[selectionIndex++].setVisible(false);
        }
    }

    private void sortAddItem(ValueNamePair vn) {
        this.sortBy1.appendItem(vn.getName(), vn);
        this.sortBy2.appendItem(vn.getName(), vn);
        this.sortBy3.appendItem(vn.getName(), vn);
        this.sortBy4.appendItem(vn.getName(), vn);
    }

    private void actionQuery() {
        StringBuilder para = new StringBuilder();
        this.m_data.C_AcctSchema_ID = 0;
        this.m_data.AD_Org_ID = 0;
        ListItem listitem = this.selAcctSchema.getSelectedItem();
        Object kp = null;
        if (listitem != null) {
            kp = (KeyNamePair)listitem.getValue();
        }
        if (kp != null) {
            this.m_data.C_AcctSchema_ID = kp.getKey();
        }
        para.append("C_AcctSchema_ID=").append(this.m_data.C_AcctSchema_ID);
        listitem = this.selPostingType.getSelectedItem();
        ValueNamePair vp = null;
        if (listitem == null) {
            return;
        }
        vp = (ValueNamePair)listitem.getValue();
        this.m_data.PostingType = vp.getValue();
        para.append(", PostingType=").append(this.m_data.PostingType);
        this.m_data.documentQuery = this.selDocument.isChecked();
        para.append(", DocumentQuery=").append(this.m_data.documentQuery);
        if (this.selDocument.isChecked()) {
            if (this.m_data.AD_Table_ID == 0 || this.m_data.Record_ID == 0) {
                return;
            }
            para.append(", AD_Table_ID=").append(this.m_data.AD_Table_ID).append(", Record_ID=").append(this.m_data.Record_ID);
        } else {
            this.m_data.DateFrom = this.selDateFrom.getValue() != null ? new Timestamp(this.selDateFrom.getValue().getTime()) : null;
            para.append(", DateFrom=").append(this.m_data.DateFrom);
            this.m_data.DateTo = this.selDateTo.getValue() != null ? new Timestamp(this.selDateTo.getValue().getTime()) : null;
            para.append(", DateTo=").append(this.m_data.DateTo);
            listitem = this.selOrg.getSelectedItem();
            kp = listitem != null ? (KeyNamePair)listitem.getValue() : null;
            if (kp != null) {
                this.m_data.AD_Org_ID = kp.getKey();
            }
            para.append(", AD_Org_ID=").append(this.m_data.AD_Org_ID);
            Iterator<String> it = this.m_data.whereInfo.values().iterator();
            while (it.hasNext()) {
                para.append(", ").append(it.next());
            }
        }
        this.m_data.displayQty = this.displayQty.isChecked();
        para.append(" - Display Qty=").append(this.m_data.displayQty);
        this.m_data.displaySourceAmt = this.displaySourceAmt.isChecked();
        para.append(", Source=").append(this.m_data.displaySourceAmt);
        this.m_data.displayDocumentInfo = this.displayDocumentInfo.isChecked();
        para.append(", Doc=").append(this.m_data.displayDocumentInfo);
        listitem = this.sortBy1.getSelectedItem();
        vp = null;
        if (listitem != null && (vp = (ValueNamePair)listitem.getValue()).getName() != null && vp.getName().trim().length() > 0) {
            this.m_data.sortBy1 = vp.getValue();
            this.m_data.group1 = this.group1.isChecked();
            para.append(" - Sorting: ").append(this.m_data.sortBy1).append("/").append(this.m_data.group1);
        }
        listitem = this.sortBy2.getSelectedItem();
        vp = null;
        if (listitem != null && (vp = (ValueNamePair)listitem.getValue()).getName() != null && vp.getName().trim().length() > 0) {
            this.m_data.sortBy2 = vp.getValue();
            this.m_data.group2 = this.group2.isChecked();
            para.append(", ").append(this.m_data.sortBy2).append("/").append(this.m_data.group2);
        }
        listitem = this.sortBy3.getSelectedItem();
        vp = null;
        if (listitem != null && (vp = (ValueNamePair)listitem.getValue()).getName() != null && vp.getName().trim().length() > 0) {
            this.m_data.sortBy3 = vp.getValue();
            this.m_data.group3 = this.group3.isChecked();
            para.append(", ").append(this.m_data.sortBy3).append("/").append(this.m_data.group3);
        }
        listitem = this.sortBy4.getSelectedItem();
        vp = null;
        if (listitem != null && (vp = (ValueNamePair)listitem.getValue()).getName() != null && vp.getName().trim().length() > 0) {
            this.m_data.sortBy4 = vp.getValue();
            this.m_data.group4 = this.group4.isChecked();
            para.append(", ").append(this.m_data.sortBy4).append("/").append(this.m_data.group4);
        }
        this.bQuery.setEnabled(false);
        this.statusLine.setValue(" " + Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
        if (log.isLoggable(Level.CONFIG)) {
            log.config(para.toString());
        }
        this.tabbedPane.setSelectedIndex(1);
        this.stateChanged();
        this.m_rmodel = this.m_data.query();
        this.m_queryData = this.m_rmodel.getRows();
        List<ArrayList<Object>> list = null;
        this.paging.setPageSize(1000);
        if (this.m_queryData.size() > 1000) {
            list = this.m_queryData.subList(0, 1000);
            this.paging.setTotalSize(this.m_queryData.size());
            this.pagingPanel.setVisible(true);
        } else {
            list = this.m_queryData;
            this.paging.setTotalSize(this.m_queryData.size());
            this.pagingPanel.setVisible(false);
        }
        this.paging.setActivePage(0);
        ListModelTable listmodeltable = new ListModelTable(list);
        if (this.table.getListhead() == null) {
            Listhead listhead = new Listhead();
            listhead.setSizable(true);
            int i = 0;
            while (i < this.m_rmodel.getColumnCount()) {
                Listheader listheader = new Listheader(this.m_rmodel.getColumnName(i));
                listheader.setTooltiptext(this.m_rmodel.getColumnName(i));
                if (!this.m_data.displayDocumentInfo) {
                    if ("AD_Table_ID".equals(this.m_rmodel.getRColumn(i).getColumnName())) {
                        listheader.setVisible(false);
                    } else if ("Record_ID".equals(this.m_rmodel.getRColumn(i).getColumnName())) {
                        listheader.setVisible(false);
                    } else if ("Fact_Acct_ID".equals(this.m_rmodel.getRColumn(i).getColumnName())) {
                        listheader.setVisible(false);
                    }
                }
                listhead.appendChild((Component)listheader);
                ++i;
            }
            this.table.appendChild((Component)listhead);
        } else {
            Listhead listhead = this.table.getListhead();
            listhead.getChildren().clear();
            int i = 0;
            while (i < this.m_rmodel.getColumnCount()) {
                Listheader listheader = new Listheader(this.m_rmodel.getColumnName(i));
                if (!this.m_data.displayDocumentInfo) {
                    if ("AD_Table_ID".equals(this.m_rmodel.getRColumn(i).getColumnName())) {
                        listheader.setVisible(false);
                    } else if ("Record_ID".equals(this.m_rmodel.getRColumn(i).getColumnName())) {
                        listheader.setVisible(false);
                    }
                }
                listhead.appendChild((Component)listheader);
                ++i;
            }
        }
        this.table.getItems().clear();
        this.table.setItemRenderer(new WListItemRenderer());
        this.table.setModel((ListModel)listmodeltable);
        this.table.setSizedByContent(true);
        this.resultPanel.invalidate();
        this.bQuery.setEnabled(true);
        this.statusLine.setValue(" " + Msg.getMsg((Properties)Env.getCtx(), (String)"ViewerOptions"));
    }

    private void actionDocument() {
        boolean doc = this.selDocument.isChecked();
        this.selTable.setEnabled(doc);
        this.selRecord.setEnabled(doc);
        this.selDateFrom.setReadWrite(!doc);
        this.selDateTo.setReadWrite(!doc);
        this.selOrg.setEnabled(!doc);
        this.selAcct.setEnabled(!doc);
        this.sel1.setEnabled(!doc);
        this.sel2.setEnabled(!doc);
        this.sel3.setEnabled(!doc);
        this.sel4.setEnabled(!doc);
        this.sel5.setEnabled(!doc);
        this.sel6.setEnabled(!doc);
        this.sel7.setEnabled(!doc);
        this.sel8.setEnabled(!doc);
    }

    private void actionTable() {
        ListItem listitem = this.selTable.getSelectedItem();
        ValueNamePair vp = null;
        if (listitem == null) {
            return;
        }
        vp = (ValueNamePair)listitem.getValue();
        this.m_data.AD_Table_ID = this.m_data.tableInfo.get(vp.getValue());
        if (log.isLoggable(Level.CONFIG)) {
            log.config(vp.getValue() + " = " + this.m_data.AD_Table_ID);
        }
        this.m_data.Record_ID = 0;
        this.selRecord.setLabel("");
        this.selRecord.setName(vp.getValue() + "_ID");
    }

    private void actionButton(final Button button) throws Exception {
        String tableName;
        InfoPanel info;
        final String keyColumn = button.getName();
        Object whereClause = "(IsSummary='N' OR IsSummary IS NULL)";
        String lookupColumn = keyColumn;
        if ("Account_ID".equals(keyColumn)) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.m_data.ASchema.getAcctSchemaElement("AC");
            if (ase != null) {
                whereClause = (String)whereClause + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if ("User1_ID".equals(keyColumn)) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.m_data.ASchema.getAcctSchemaElement("U1");
            if (ase != null) {
                whereClause = (String)whereClause + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if ("User2_ID".equals(keyColumn)) {
            lookupColumn = "C_ElementValue_ID";
            ase = this.m_data.ASchema.getAcctSchemaElement("U2");
            if (ase != null) {
                whereClause = (String)whereClause + " AND C_Element_ID=" + ase.getC_Element_ID();
            }
        } else if (keyColumn.equals("AD_OrgTrx_ID")) {
            lookupColumn = "AD_Org_ID";
        } else if (keyColumn.equals("UserElement1_ID")) {
            ase = this.m_data.ASchema.getAcctSchemaElement("X1");
            lookupColumn = MColumn.getColumnName((Properties)Env.getCtx(), (int)ase.getAD_Column_ID());
            whereClause = "";
        } else if (keyColumn.equals("UserElement2_ID")) {
            ase = this.m_data.ASchema.getAcctSchemaElement("X2");
            lookupColumn = MColumn.getColumnName((Properties)Env.getCtx(), (int)ase.getAD_Column_ID());
            whereClause = "";
        } else if (keyColumn.equals("M_Product_ID")) {
            whereClause = "";
        } else if (this.selDocument.isChecked()) {
            whereClause = "";
        }
        if (!(info = InfoPanel.create(this.m_data.WindowNo, tableName = lookupColumn.substring(0, lookupColumn.length() - 3), lookupColumn, "", false, (String)whereClause)).loadedOK()) {
            button.setLabel("");
            this.m_data.whereInfo.put(keyColumn, "");
            return;
        }
        info.setVisible(true);
        final String lookupColumnRef = lookupColumn;
        info.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                String selectSQL = info.getSelectedSQL();
                Integer key = (Integer)info.getSelectedKey();
                if (selectSQL == null || selectSQL.length() == 0 || key == null) {
                    button.setLabel("");
                    WAcctViewer.this.m_data.whereInfo.put(keyColumn, "");
                    return;
                }
                if (log.isLoggable(Level.CONFIG)) {
                    log.config(keyColumn + " - " + String.valueOf(key));
                }
                if (button == WAcctViewer.this.selRecord) {
                    WAcctViewer.this.m_data.Record_ID = key;
                } else {
                    WAcctViewer.this.m_data.whereInfo.put(keyColumn, keyColumn + "=" + key);
                }
                button.setLabel(WAcctViewer.this.m_data.getButtonText(tableName, lookupColumnRef, selectSQL));
            }
        });
        AEnv.showWindow(info);
    }

    private void actionRePost() {
        if (this.m_data.documentQuery && this.m_data.AD_Table_ID != 0 && this.m_data.Record_ID != 0) {
            if (!MPeriod.isOpen((Properties)Env.getCtx(), (int)this.m_data.AD_Table_ID, (int)this.m_data.Record_ID, null, (boolean)true)) {
                Dialog.error(0, "Error", Msg.getMsg((Properties)Env.getCtx(), (String)"PeriodClosed"));
                return;
            }
            Dialog.ask(this.m_data.WindowNo, "PostImmediate?", new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        boolean force = WAcctViewer.this.forcePost.isChecked();
                        String error = AEnv.postImmediate(WAcctViewer.this.m_data.WindowNo, WAcctViewer.this.m_data.AD_Client_ID, WAcctViewer.this.m_data.AD_Table_ID, WAcctViewer.this.m_data.Record_ID, force);
                        if (error != null) {
                            Dialog.error(0, "PostingError-N", error);
                        }
                        WAcctViewer.this.actionQuery();
                    }
                }
            });
        }
    }

    private void actionZoom() {
        int selected = this.table.getSelectedIndex();
        if (selected == -1) {
            return;
        }
        int tableIdColumn = this.m_rmodel.getColumnIndex("AD_Table_ID");
        int recordIdColumn = this.m_rmodel.getColumnIndex("Record_ID");
        ListModelTable model = (ListModelTable)this.table.getListModel();
        KeyNamePair tabknp = (KeyNamePair)model.getDataAt(selected, tableIdColumn);
        Integer recint = (Integer)model.getDataAt(selected, recordIdColumn);
        if (tabknp != null && recint != null) {
            int AD_Table_ID = tabknp.getKey();
            int Record_ID = recint;
            AEnv.zoom(AD_Table_ID, Record_ID);
        }
    }

    private void actionZoomFactAcct() {
        int selected = this.table.getSelectedIndex();
        if (selected == -1) {
            return;
        }
        int factAcctIdColumn = this.m_rmodel.getColumnIndex("Fact_Acct_ID");
        ListModelTable model = (ListModelTable)this.table.getListModel();
        Integer faint = (Integer)model.getDataAt(selected, factAcctIdColumn);
        if (faint != null) {
            int fact_acct_ID = faint;
            AEnv.zoom(270, fact_acct_ID);
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            SessionManager.getAppDesktop().updateHelpContext("H", 0);
        }
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltKey() && keyEvent.getKeyCode() == 88 || keyEvent.getKeyCode() == 27 && this.isUseEscForTabClosing) {
            keyEvent.stopPropagation();
            Events.echoEvent((Event)new Event("onCloseWindowShortcut", (Component)this));
        }
    }
}

