/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.sys.IdGenerator;

public class AdempiereIdGenerator
implements IdGenerator {
    public static final String ZK_LOCATOR_ATTRIBUTE = "_zk_locator";

    public String nextComponentUuid(Desktop desktop, Component comp, ComponentInfo compInfo) {
        AdempiereIdGenerator.buildLocatorAttribute(comp);
        Object uuid = comp.getId();
        boolean useIdSpace = true;
        if (Util.isEmpty((String)uuid)) {
            useIdSpace = false;
            String attribute = comp.getClientAttribute("instanceName");
            if (!Util.isEmpty((String)attribute)) {
                String widgetName = AdempiereIdGenerator.getWidgetName(comp.getWidgetClass());
                uuid = widgetName + "0" + attribute;
            }
        }
        if (Util.isEmpty((String)uuid)) {
            uuid = AdempiereIdGenerator.getWidgetName(comp.getWidgetClass());
        }
        StringBuilder builder = new StringBuilder((String)uuid);
        if (useIdSpace) {
            Component parent = comp.getParent();
            while (parent != null) {
                if (parent instanceof IdSpace) {
                    builder.insert(0, "_");
                    builder.insert(0, parent.getUuid());
                    break;
                }
                parent = parent.getParent();
            }
        } else if (comp.getParent() != null) {
            builder.insert(0, "_");
            builder.insert(0, comp.getParent().getUuid());
        }
        uuid = AdempiereIdGenerator.escapeId(builder.toString());
        if (desktop.getComponentByUuidIfAny((String)uuid) == null) {
            return uuid;
        }
        IdSpace idspace = comp.getSpaceOwner();
        String number = (String)idspace.getAttribute("uid.sequence");
        if (number == null) {
            number = "0";
            idspace.setAttribute("uid.sequence", (Object)number);
        }
        int i = Integer.parseInt(number);
        idspace.setAttribute("uid.sequence", (Object)String.valueOf(++i));
        return (String)uuid + "_" + i;
    }

    private static String getWidgetName(String widgetClass) {
        String name = widgetClass.substring(widgetClass.lastIndexOf(".") + 1);
        return name.toLowerCase();
    }

    public static String escapeId(String prefix) {
        Pattern pattern = Pattern.compile("[^a-zA-Z_0-9]");
        Matcher matcher = pattern.matcher(prefix);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_");
        }
        matcher.appendTail(sb);
        prefix = sb.toString();
        return prefix;
    }

    public String nextDesktopId(Desktop desktop) {
        HttpServletRequest req = (HttpServletRequest)Executions.getCurrent().getNativeRequest();
        String dtid = req.getParameter("tdtid");
        return dtid == null ? null : dtid;
    }

    public String nextPageUuid(Page page) {
        return null;
    }

    public static void updateZkLocatorAttribute(Component comp) {
        AdempiereIdGenerator.buildLocatorAttribute(comp);
        List childs = comp.getChildren();
        if (childs != null && !childs.isEmpty()) {
            for (Component child : childs) {
                AdempiereIdGenerator.updateZkLocatorAttribute(child);
            }
        }
    }

    private static void buildLocatorAttribute(Component comp) {
        String id = comp.getId();
        StringBuilder locatorBuilder = new StringBuilder();
        if (!Util.isEmpty((String)id)) {
            if (id.indexOf(" ") > 0) {
                String widgetName = AdempiereIdGenerator.getWidgetName(comp.getWidgetClass());
                locatorBuilder.append("@").append(widgetName).append("[id").append("='").append(id).append("']");
            } else {
                locatorBuilder.append("$").append(id);
            }
        }
        if (Util.isEmpty((String)id)) {
            String attribute = comp.getClientAttribute("instanceName");
            if (attribute != null && attribute.length() > 0) {
                String widgetName = AdempiereIdGenerator.getWidgetName(comp.getWidgetClass());
                locatorBuilder.append("@").append(widgetName).append("[").append("instanceName").append("='").append(attribute).append("']");
            } else {
                locatorBuilder.append("@").append(AdempiereIdGenerator.getWidgetName(comp.getWidgetClass()));
            }
        }
        Component parent = comp.getParent();
        while (parent != null) {
            String parentLocator;
            if ((Util.isEmpty((String)id) || parent instanceof IdSpace) && (parentLocator = parent.getClientAttribute(ZK_LOCATOR_ATTRIBUTE)) != null && parentLocator.trim().length() > 0) {
                locatorBuilder.insert(0, parentLocator + " ");
                break;
            }
            parent = parent.getParent();
        }
        comp.setClientAttribute(ZK_LOCATOR_ATTRIBUTE, locatorBuilder.toString());
    }
}

