/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.StringWriter;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.session.SessionManager;
import org.compiere.model.GridTab;
import org.compiere.model.X_AD_CtxHelpMsg;
import org.compiere.util.Env;
import org.idempiere.ui.zk.annotation.Form;
import org.outerj.daisy.diff.DaisyDiff;
import org.springframework.web.util.HtmlUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.zkforge.ckez.CKeditor;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.Timer;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.Window;

@Form
public class CompareCtxHelpSuggestion
extends ADForm {
    private static final String NEW_VALUE_ATTR = "newValue";
    private static final long serialVersionUID = -100362034024824442L;
    private Grid grid;
    private ConfirmPanel confirmPanel;
    private Cell helpDiff;
    private CKeditor helpTextbox;
    private X_AD_CtxHelpMsg ctxHelpMsg;
    private String AD_Language;
    private Timer helpTimer;

    @Override
    protected void initForm() {
        this.setWidth("90%");
        this.setHeight("700px");
        this.setSizable(true);
        Vlayout layout = new Vlayout();
        layout.setHflex("1");
        layout.setVflex("1");
        this.appendChild((Component)layout);
        this.grid = new Grid();
        this.grid.setVflex(true);
        this.grid.setHflex("1");
        layout.appendChild((Component)this.grid);
        Div div = new Div();
        div.setSclass("dialog-footer");
        this.confirmPanel = new ConfirmPanel(true);
        this.confirmPanel.setStyle("padding: 8px 16px;");
        this.confirmPanel.setHflex("1");
        this.confirmPanel.setVflex("min");
        div.appendChild((Component)this.confirmPanel);
        layout.appendChild((Component)div);
        this.confirmPanel.addActionListener(this);
        this.helpTimer = new Timer();
        this.helpTimer.setDelay(1000);
        this.helpTimer.setRepeats(false);
        this.appendChild((Component)this.helpTimer);
        this.helpTimer.stop();
        this.helpTimer.addEventListener("onTimer", (EventListener)this);
        this.renderGrid();
    }

    private void renderGrid() {
        Component c = SessionManager.getAppDesktop().getActiveWindow();
        ADWindow adwindow = ADWindow.findADWindow(c);
        GridTab gridTab = adwindow.getADWindowContent().getActiveGridTab();
        int AD_CtxHelpMsg_ID = (Integer)gridTab.getValue("AD_CtxHelpMsg_ID");
        this.ctxHelpMsg = new X_AD_CtxHelpMsg(Env.getCtx(), AD_CtxHelpMsg_ID, null);
        this.AD_Language = (String)gridTab.getValue("AD_Language");
        Columns columns = new Columns();
        this.grid.appendChild((Component)columns);
        Column column = new Column();
        column.setLabel("Original Text");
        column.setValign("top");
        columns.appendChild((Component)column);
        column = new Column();
        column.setLabel("Changed Text");
        column.setValign("top");
        columns.appendChild((Component)column);
        column = new Column();
        column.setLabel("Difference");
        column.setValign("top");
        columns.appendChild((Component)column);
        Rows rows = this.grid.newRows();
        Row row = rows.newRow();
        String original = this.ctxHelpMsg.get_Translation("MsgText", this.AD_Language);
        if (original != null) {
            original = this.removeHeaderTag(original);
        }
        row.appendCellChild((Component)new Html(original));
        String changed = (String)gridTab.getValue("MsgText");
        if (changed != null) {
            changed = this.removeHeaderTag(changed);
        }
        this.helpTextbox = new CKeditor();
        this.helpTextbox.setCustomConfigurationsPath("/js/ckeditor/config-min.js");
        this.helpTextbox.setToolbar("MyToolbar");
        row.appendCellChild((Component)this.helpTextbox);
        this.helpTextbox.addEventListener("onChange", (EventListener)this);
        this.helpTextbox.addEventListener("onChanging", (EventListener)this);
        this.helpTextbox.setHeight("400px");
        this.helpTextbox.setHflex("1");
        this.helpTextbox.setValue(changed);
        Html html = this.diff(original, changed);
        this.helpDiff = new Cell();
        this.helpDiff.appendChild((Component)html);
        row.appendChild((Component)this.helpDiff);
        this.addEventListener("onOK", this);
    }

    private Html diff(String original, String changed) {
        if (original == null) {
            original = "";
        }
        if (changed == null) {
            changed = "";
        }
        String diff = this.htmlDiff(original, changed);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int length = diff.length();
        while (i < length) {
            int end;
            int start = diff.indexOf("<span class=\"diff-tag-html\">", i);
            if (start < 0) break;
            if (start > i) {
                String s = diff.substring(i, start);
                s = HtmlUtils.htmlUnescape((String)s);
                builder.append(s);
            }
            if ((end = diff.indexOf("</span>", i = start + "<span class=\"diff-tag-html\">".length())) > i) {
                String s = diff.substring(i, end);
                s = HtmlUtils.htmlUnescape((String)s);
                builder.append(s);
                i = end + "</span>".length();
                continue;
            }
            throw new RuntimeException("Missing </span> tag");
        }
        if (i < length) {
            String s = diff.substring(i, length);
            s = HtmlUtils.htmlUnescape((String)s);
            builder.append(s);
        }
        String s = builder.toString();
        s = s.replace("class=\"diff-tag-removed\"", "style=\"font-size: 100%;text-decoration: line-through;background-color: #fdc6c6;\"");
        s = s.replace("class=\"diff-tag-added\"", "style=\"font-size: 100%;background-color: #ccffcc;\"");
        Html html = new Html(s);
        return html;
    }

    @Override
    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.detach();
        } else if (event.getTarget() == this.confirmPanel.getButton("Ok")) {
            this.applyChanges();
            this.detach();
        } else if (event.getTarget() == this.helpTextbox) {
            if (event.getName().equals("onChanging")) {
                InputEvent inputEvent = (InputEvent)event;
                this.helpTimer.setAttribute(NEW_VALUE_ATTR, (Object)inputEvent.getValue());
                if (this.helpTimer.isRunning()) {
                    return;
                }
                this.helpTimer.start();
            } else {
                this.onHelpChanged(this.helpTextbox.getValue());
                if (this.helpTimer.isRunning()) {
                    this.helpTimer.stop();
                }
            }
        } else if (event.getTarget() == this.helpTimer) {
            this.onHelpChanged((String)this.helpTimer.removeAttribute(NEW_VALUE_ATTR));
        } else {
            super.onEvent(event);
        }
    }

    private void onHelpChanged(String text) {
        this.helpDiff.getChildren().clear();
        Html html = this.diff(this.ctxHelpMsg.get_Translation("MsgText", this.AD_Language), text);
        this.helpDiff.appendChild((Component)html);
    }

    private void applyChanges() {
        Component c = SessionManager.getAppDesktop().getActiveWindow();
        ADWindow adwindow = ADWindow.findADWindow(c);
        GridTab gridTab = adwindow.getADWindowContent().getActiveGridTab();
        String help = this.helpTextbox.getValue();
        gridTab.setValue("MsgText", (Object)help);
        gridTab.dataSave(false);
    }

    @Override
    public Window.Mode getWindowMode() {
        return Window.Mode.HIGHLIGHTED;
    }

    private String removeHeaderTag(String htmlString) {
        htmlString = htmlString.replace("<html>", "").replace("</html>", "").replace("<body>", "").replace("</body>", "").replace("<head>", "").replace("</head>", "");
        return htmlString;
    }

    private String htmlDiff(String s1, String s2) {
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            TransformerHandler result = tf.newTransformerHandler();
            StringWriter resultWriter = new StringWriter();
            result.setResult(new StreamResult(resultWriter));
            result.startDocument();
            String tag = Long.toString(System.currentTimeMillis(), 3);
            result.startElement("", tag, tag, new AttributesImpl());
            DaisyDiff.diffTag((String)s1, (String)s2, (ContentHandler)result);
            result.endDocument();
            result.endElement("", tag, tag);
            String string = resultWriter.toString();
            return string.substring(string.indexOf("<" + tag + ">") + tag.length() + 2, string.indexOf("</" + tag + ">"));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

