/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.activation.DataSource;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.component.AttachmentItem;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.FeedbackManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.apache.commons.io.IOUtils;
import org.compiere.model.Lookup;
import org.compiere.model.MAttachment;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRequest;
import org.compiere.model.MRole;
import org.compiere.util.ByteArrayDataSource;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.South;

public class FeedbackRequestWindow
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 8586980192148533197L;
    private static final CLogger log = CLogger.getCLogger(FeedbackRequestWindow.class);
    protected WTableDirEditor requestTypeField;
    protected WTableDirEditor priorityField;
    protected WTableDirEditor salesRepField;
    protected Textbox txtSummary;
    protected ConfirmPanel confirmPanel;
    protected List<DataSource> attachments = new ArrayList<DataSource>();
    protected Div attachmentBox;

    public FeedbackRequestWindow() {
        boolean readOnly;
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"RequestNew"));
        this.setAttribute("mode", "highlighted");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 400);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 600);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setSclass("popup-dialog feedback-request-dialog");
        this.setBorder("normal");
        this.setShadow(true);
        this.setClosable(true);
        this.setMaximizable(true);
        boolean bl = readOnly = !MRole.getDefault().canUpdate(Env.getAD_Client_ID((Properties)Env.getCtx()), Env.getAD_Org_ID((Properties)Env.getCtx()), 417, 0, false);
        if (readOnly) {
            throw new RuntimeException(Msg.getMsg((Properties)Env.getCtx(), (String)"AccessTableNoUpdate"));
        }
        Label lblRequestType = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"R_RequestType_ID"));
        Label lblPriority = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Priority"));
        Label lblSummary = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"Summary"));
        Label lblSalesRep = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"SalesRep_ID"));
        int columnID = MColumn.getColumn_ID((String)"R_Request", (String)"R_RequestType_ID");
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)columnID, (int)19);
        this.requestTypeField = new WTableDirEditor("R_RequestType_ID", true, false, true, (Lookup)lookup);
        this.requestTypeField.setValue(Env.getContext((Properties)Env.getCtx(), (String)"P232|R_RequestType_ID"));
        if ((this.requestTypeField.getValue() == null || this.requestTypeField.getValue().equals("")) && this.requestTypeField.getComponent().getItemCount() > 1) {
            this.requestTypeField.setValue(this.requestTypeField.getComponent().getItemAtIndex(1).getValue());
        }
        columnID = MColumn.getColumn_ID((String)"R_Request", (String)"Priority");
        lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)columnID, (int)17);
        this.priorityField = new WTableDirEditor("Priority", true, false, true, (Lookup)lookup);
        this.priorityField.setValue(Env.getContext((Properties)Env.getCtx(), (String)"P232|Priority"));
        if ((this.priorityField.getValue() == null || this.priorityField.getValue().equals("")) && this.priorityField.getComponent().getItemCount() > 1) {
            this.priorityField.setValue(this.priorityField.getComponent().getItemAtIndex(1).getValue());
        }
        columnID = MColumn.getColumn_ID((String)"R_Request", (String)"SalesRep_ID");
        lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)0, (int)0, (int)columnID, (int)19);
        this.salesRepField = new WTableDirEditor("SalesRep_ID", true, false, true, (Lookup)lookup);
        this.salesRepField.setValue(Env.getContextAsInt((Properties)Env.getCtx(), (String)"SalesRep_ID"));
        if ((this.salesRepField.getValue() == null || this.salesRepField.getValue().equals("0")) && this.salesRepField.getComponent().getItemCount() > 1) {
            this.salesRepField.setValue(this.salesRepField.getComponent().getItemAtIndex(1).getValue());
        }
        this.txtSummary = new Textbox();
        this.txtSummary.setRows(10);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtSummary, "95%");
        this.confirmPanel = new ConfirmPanel(true);
        this.confirmPanel.addActionListener(this);
        Grid grid = GridFactory.newGridLayout();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)grid, "1");
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = rows.newRow();
        row.setStyle("padding: 4px 4px 0px 6px");
        row.appendChild((Component)lblRequestType);
        row = rows.newRow();
        row.setStyle("padding: 0px 4px 4px 6px");
        row.appendChild((Component)this.requestTypeField.getComponent());
        row = rows.newRow();
        row.setStyle("padding: 4px 4px 0px 6px");
        row.appendChild((Component)lblPriority);
        row = rows.newRow();
        row.setStyle("padding: 0px 4px 4px 6px");
        row.appendChild((Component)this.priorityField.getComponent());
        row = rows.newRow();
        row.setStyle("padding: 4px 4px 0px 6px");
        row.appendChild((Component)lblSummary);
        row = rows.newRow();
        row.setStyle("padding: 0px 4px 4px 6px");
        row.appendChild((Component)this.txtSummary);
        row = rows.newRow();
        row.setStyle("padding: 4px 4px 0px 6px");
        row.appendChild((Component)lblSalesRep);
        row = rows.newRow();
        row.setStyle("padding: 0px 4px 4px 6px");
        row.appendChild((Component)this.salesRepField.getComponent());
        row = rows.newRow();
        row.setStyle("padding: 4px 4px 0px 6px");
        row.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Attachment")));
        this.attachmentBox = new Div();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.attachmentBox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.attachmentBox, "1");
        row = rows.newRow();
        row.setStyle("padding: 0px 4px 4px 6px");
        row.appendChild((Component)this.attachmentBox);
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)borderlayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)borderlayout, "1");
        Center centerPane = new Center();
        centerPane.setSclass("dialog-content");
        centerPane.setAutoscroll(true);
        borderlayout.appendChild((Component)centerPane);
        centerPane.appendChild((Component)grid);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)grid, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)grid, "1");
        South southPane = new South();
        southPane.setSclass("dialog-footer");
        borderlayout.appendChild((Component)southPane);
        southPane.appendChild((Component)this.confirmPanel);
        Button btn = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            btn.setIconSclass("z-icon-Attachment");
        } else {
            btn.setImage(ThemeManager.getThemeResource("images/Attachment24.png"));
        }
        btn.setUpload(AdempiereWebUI.getUploadSetting());
        btn.addEventListener("onUpload", this);
        btn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Attachment"));
        this.confirmPanel.addComponentsLeft(btn);
        this.confirmPanel.getButton("Ok").setWidgetListener("onClick", "zAu.cmd0.showBusy(null)");
        this.addAttachment(FeedbackManager.getLogAttachment(false), false);
    }

    public void onEvent(Event e) throws Exception {
        UploadEvent ue;
        Media media;
        if (e.getTarget() == this.confirmPanel.getButton("Ok")) {
            Clients.clearBusy();
            if (this.requestTypeField.getValue() == null || this.requestTypeField.getValue().equals("0")) {
                throw new WrongValueException((Component)this.requestTypeField.getComponent(), Msg.translate((Properties)Env.getCtx(), (String)"FillMandatory"));
            }
            if (this.priorityField.getValue() == null || this.priorityField.getValue().equals("")) {
                throw new WrongValueException((Component)this.priorityField.getComponent(), Msg.translate((Properties)Env.getCtx(), (String)"FillMandatory"));
            }
            if (this.txtSummary.getText() == null || this.txtSummary.getText().equals("")) {
                throw new WrongValueException((Component)this.txtSummary, Msg.translate((Properties)Env.getCtx(), (String)"FillMandatory"));
            }
            if (this.salesRepField.getValue() == null || this.salesRepField.getValue().equals("0")) {
                throw new WrongValueException((Component)this.salesRepField.getComponent(), Msg.translate((Properties)Env.getCtx(), (String)"FillMandatory"));
            }
            this.saveRequest();
            this.detach();
        } else if (e.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.detach();
        } else if (e instanceof UploadEvent && (media = (ue = (UploadEvent)e).getMedia()) != null) {
            byte[] data = this.getMediaData(media);
            ByteArrayDataSource dataSource = new ByteArrayDataSource(data, media.getContentType());
            dataSource.setName(media.getName());
            this.addAttachment((DataSource)dataSource, true);
        }
    }

    protected void saveRequest() throws IOException {
        trx.setDisplayName(this.getClass().getName() + "_saveRequest");
        try (Trx trx = Trx.get((String)Trx.createTrxName((String)"SaveNewRequest"), (boolean)true);){
            trx.start();
            MRequest request = this.createMRequest(trx);
            boolean success = request.save();
            if (success) {
                MAttachment attachment = null;
                for (DataSource ds : this.attachments) {
                    if (attachment == null) {
                        attachment = new MAttachment(Env.getCtx(), 0, request.get_TrxName());
                        attachment.setAD_Table_ID(request.get_Table_ID());
                        attachment.setRecord_ID(request.get_ID());
                    }
                    attachment.addEntry(ds.getName(), IOUtils.toByteArray((InputStream)ds.getInputStream()));
                }
                if (attachment != null) {
                    success = attachment.save();
                }
                if (success) {
                    success = trx.commit();
                }
            }
            if (success) {
                Dialog.info(0, Msg.getMsg((Properties)Env.getCtx(), (String)"Saved"));
            } else {
                trx.rollback();
                Dialog.error(0, Msg.getMsg((Properties)Env.getCtx(), (String)"SaveError"));
            }
        }
    }

    protected MRequest createMRequest(Trx trx) {
        MRequest request = new MRequest(Env.getCtx(), 0, trx.getTrxName());
        request.setAD_Org_ID(Env.getAD_Org_ID((Properties)Env.getCtx()));
        request.setR_RequestType_ID(((Integer)this.requestTypeField.getValue()).intValue());
        request.setPriority((String)this.priorityField.getValue());
        request.setSummary(this.txtSummary.getText());
        request.setSalesRep_ID(((Integer)this.salesRepField.getValue()).intValue());
        return request;
    }

    public void addAttachment(DataSource dataSource, boolean removable) {
        this.attachments.add(dataSource);
        AttachmentItem item = new AttachmentItem(dataSource, this.attachments, removable);
        this.attachmentBox.appendChild((Component)item);
        this.getFirstChild().invalidate();
    }

    private byte[] getMediaData(Media media) {
        byte[] bytes = null;
        try {
            if (media.inMemory()) {
                bytes = media.isBinary() ? media.getByteData() : media.getStringData().getBytes(this.getCharset(media.getContentType()));
            } else {
                InputStream is = media.getStreamData();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[1000];
                int byteread = 0;
                while ((byteread = is.read(buf)) != -1) {
                    baos.write(buf, 0, byteread);
                }
                bytes = baos.toByteArray();
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            throw new IllegalStateException(e.getLocalizedMessage());
        }
        return bytes;
    }

    private String getCharset(String contentType) {
        String cs;
        int j;
        if (contentType != null && (j = contentType.indexOf("charset=")) >= 0 && (cs = contentType.substring(j + 8).trim()).length() > 0) {
            return cs;
        }
        return "UTF-8";
    }
}

