/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ServerContext;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MNote;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstanceLog;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class BackgroundJobCallable
implements Callable<ProcessInfo> {
    private final ProcessInfo processInfo;
    private Properties m_ctx;
    private IProcessUI processUI;
    private static final CLogger log = CLogger.getCLogger(BackgroundJobCallable.class);

    public BackgroundJobCallable(Properties ctx, ProcessInfo processInfo) {
        this(ctx, processInfo, null);
    }

    public BackgroundJobCallable(Properties ctx, ProcessInfo processInfo, IProcessUI processUI) {
        this.processInfo = processInfo;
        this.processUI = processUI;
        this.m_ctx = new Properties();
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (String)ctx.getProperty("#AD_Client_ID"));
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Org_ID", (String)ctx.getProperty("#AD_Org_ID"));
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Role_ID", (String)ctx.getProperty("#AD_Role_ID"));
        Env.setContext((Properties)this.m_ctx, (String)"#M_Warehouse_ID", (String)ctx.getProperty("#M_Warehouse_ID"));
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Language", (String)ctx.getProperty("#AD_Language"));
        Env.setContext((Properties)this.m_ctx, (String)"#AD_User_ID", (String)ctx.getProperty("#AD_User_ID"));
        Env.setContext((Properties)this.m_ctx, (String)"#Date", (String)ctx.getProperty("#Date"));
        Env.setContext((Properties)this.m_ctx, (String)"#AD_Session_ID", (String)ctx.getProperty("#AD_Session_ID"));
    }

    @Override
    public ProcessInfo call() {
        try {
            ServerContext.setCurrentInstance((Properties)this.m_ctx);
            ProcessInfo processInfo = this.doRun();
            return processInfo;
        }
        finally {
            ServerContext.dispose();
        }
    }

    private ProcessInfo doRun() {
        this.processInfo.setIsBatch(true);
        this.processInfo.setPrintPreview(true);
        MPInstance instance = new MPInstance(this.m_ctx, this.processInfo.getAD_PInstance_ID(), null);
        String notificationType = instance.getNotificationType();
        if (notificationType == null) {
            notificationType = "N";
        }
        boolean sendEmail = notificationType.equals("E") || notificationType.equals("B");
        boolean createNotice = notificationType.equals("N") || notificationType.equals("B");
        int AD_Client_ID = Env.getAD_Client_ID((Properties)this.m_ctx);
        int AD_User_ID = Env.getAD_User_ID((Properties)this.m_ctx);
        try {
            try {
                MProcess process = new MProcess(this.m_ctx, this.processInfo.getAD_Process_ID(), null);
                if (process.isReport() && process.getJasperReport() != null && !Util.isEmpty((String)process.getJasperReport())) {
                    this.processInfo.setExport(true);
                    if ("HTML".equals(this.processInfo.getReportType())) {
                        this.processInfo.setExportFileExtension("html");
                    } else if ("CSV".equals(this.processInfo.getReportType())) {
                        this.processInfo.setExportFileExtension("csv");
                    } else if ("XLS".equals(this.processInfo.getReportType())) {
                        this.processInfo.setExportFileExtension("xls");
                    } else if ("XLSX".equals(this.processInfo.getReportType())) {
                        this.processInfo.setExportFileExtension("xlsx");
                    } else {
                        this.processInfo.setExportFileExtension("pdf");
                    }
                }
                ArrayList<File> downloadFiles = new ArrayList<File>();
                ServerProcessCtl.process((ProcessInfo)this.processInfo, null);
                ProcessInfoUtil.setLogFromDB((ProcessInfo)this.processInfo);
                if (!this.processInfo.isError()) {
                    boolean isReport;
                    boolean bl = isReport = process.isReport() || process.getAD_ReportView_ID() > 0 || process.getJasperReport() != null || process.getAD_PrintFormat_ID() > 0;
                    if (isReport && this.processInfo.getPDFReport() != null) {
                        downloadFiles.add(this.processInfo.getPDFReport());
                        if (this.processUI != null) {
                            this.processUI.download(this.processInfo.getPDFReport());
                        }
                    }
                    if (this.processInfo.isExport() && this.processInfo.getExportFile() != null) {
                        downloadFiles.add(this.processInfo.getExportFile());
                        if (this.processUI != null) {
                            this.processUI.download(this.processInfo.getExportFile());
                        }
                    }
                }
                if (sendEmail) {
                    MClient client = MClient.get((Properties)this.m_ctx, (int)AD_Client_ID);
                    client.sendEMailAttachments(AD_User_ID, process.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx())), this.processInfo.getSummary() + " " + this.processInfo.getLogInfo(), downloadFiles);
                }
                if (createNotice) {
                    String log;
                    MNote note = new MNote(this.m_ctx, "BackgroundJob", AD_User_ID, null);
                    note.setTextMsg(process.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx())) + "\n" + this.processInfo.getSummary());
                    note.setRecord(282, this.processInfo.getAD_PInstance_ID());
                    note.saveEx();
                    MAttachment attachment = null;
                    if (downloadFiles.size() > 0) {
                        attachment = note.createAttachment();
                        for (File downloadFile : downloadFiles) {
                            attachment.addEntry(downloadFile);
                        }
                    }
                    if ((log = this.processInfo.getLogInfo(true)) != null && log.trim().length() > 0) {
                        if (attachment == null) {
                            attachment = note.createAttachment();
                        }
                        attachment.addEntry("ProcessLog.html", log.getBytes("UTF-8"));
                    }
                    if (attachment != null) {
                        attachment.saveEx();
                    }
                    MPInstanceLog il = instance.addLog(null, 0, null, Msg.parseTranslation((Properties)this.m_ctx, (String)("@Created@ @AD_Note_ID@ " + note.getAD_Note_ID())), 389, note.getAD_Note_ID());
                    il.saveEx();
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                if (instance.getAD_PInstance_ID() > 0) {
                    MPInstanceLog il = instance.addLog(null, 0, null, e.getLocalizedMessage());
                    il.save();
                }
                instance.setIsProcessing(false);
                instance.saveEx();
                MPInstance.publishChangedEvent((int)AD_User_ID);
            }
        }
        finally {
            instance.setIsProcessing(false);
            instance.saveEx();
            MPInstance.publishChangedEvent((int)AD_User_ID);
        }
        return this.processInfo;
    }
}

