/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Properties;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.layout.PrintElement;

public class BoxElement
extends PrintElement {
    private static final long serialVersionUID = -1956804687979601523L;
    private MPrintFormatItem m_item = null;
    private Color m_color = Color.BLACK;

    public BoxElement(MPrintFormatItem item, Color color) {
        if (item != null && item.isTypeBox()) {
            this.m_item = item;
            this.m_color = color;
        }
    }

    @Override
    protected boolean calculateSize() {
        this.p_width = 0.0f;
        this.p_height = 0.0f;
        if (this.m_item == null) {
            return true;
        }
        return true;
    }

    @Override
    public void paint(Graphics2D g2D, int pageNo, Point2D pageStart, Properties ctx, boolean isView) {
        if (this.m_item == null) {
            return;
        }
        g2D.setColor(this.m_color);
        BasicStroke s = new BasicStroke(this.m_item.getLineWidth());
        g2D.setStroke(s);
        Point2D.Double location = this.getAbsoluteLocation(pageStart);
        int x = (int)location.x;
        int y = (int)location.y;
        int width = this.m_item.getMaxWidth();
        int height = this.m_item.getMaxHeight();
        if (this.m_item.getPrintFormatType().equals("L")) {
            g2D.drawLine(x, y, x + width, y + height);
        } else {
            String type = this.m_item.getShapeType();
            if (type == null) {
                type = "";
            }
            if (this.m_item.isFilledRectangle()) {
                if (type.equals("3")) {
                    g2D.fill3DRect(x, y, width, height, true);
                } else if (type.equals("O")) {
                    g2D.fillOval(x, y, width, height);
                } else if (type.equals("R")) {
                    g2D.fillRoundRect(x, y, width, height, this.m_item.getArcDiameter(), this.m_item.getArcDiameter());
                } else {
                    g2D.fillRect(x, y, width, height);
                }
            } else if (type.equals("3")) {
                g2D.draw3DRect(x, y, width, height, true);
            } else if (type.equals("O")) {
                g2D.drawOval(x, y, width, height);
            } else if (type.equals("R")) {
                g2D.drawRoundRect(x, y, width, height, this.m_item.getArcDiameter(), this.m_item.getArcDiameter());
            } else {
                g2D.drawRect(x, y, width, height);
            }
        }
    }
}

