/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.I_S_Resource;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_S_ResourceUnAvailable;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MResourceUnAvailable
extends X_S_ResourceUnAvailable {
    private static final long serialVersionUID = 1087763356022282086L;

    public static boolean isUnAvailable(I_S_Resource r, Timestamp dateTime) {
        Timestamp date = TimeUtil.trunc(dateTime, "D");
        Properties ctx = r instanceof PO ? ((PO)((Object)r)).getCtx() : Env.getCtx();
        return new Query(ctx, "S_ResourceUnAvailable", "S_Resource_ID=? AND AD_Client_ID=? AND TRUNC(DateFrom) <= ? AND TRUNC(DateTo) >= ?", null).setParameters(r.getS_Resource_ID(), r.getAD_Client_ID(), date, date).match();
    }

    public MResourceUnAvailable(Properties ctx, String S_ResourceUnAvailable_UU, String trxName) {
        super(ctx, S_ResourceUnAvailable_UU, trxName);
    }

    public MResourceUnAvailable(Properties ctx, int S_ResourceUnAvailable_ID, String trxName) {
        super(ctx, S_ResourceUnAvailable_ID, trxName);
    }

    public MResourceUnAvailable(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateTo() == null) {
            this.setDateTo(this.getDateFrom());
        }
        if (this.getDateFrom().after(this.getDateTo())) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@DateTo@ > @DateFrom@"));
            return false;
        }
        return true;
    }

    public boolean isUnAvailable(Timestamp dateTime) {
        Timestamp date = TimeUtil.trunc(dateTime, "D");
        Timestamp dateFrom = this.getDateFrom();
        Timestamp dateTo = this.getDateTo();
        if (dateFrom != null && date.before(dateFrom)) {
            return false;
        }
        return dateTo == null || !date.after(dateTo);
    }
}

