/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event.delegate;

import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.base.annotation.EventTopicDelegate;
import org.adempiere.base.annotation.ModelEventTopic;
import org.adempiere.base.event.annotations.ModelEventDelegate;
import org.adempiere.base.event.annotations.po.BeforeChange;
import org.adempiere.base.event.annotations.po.BeforeNew;
import org.compiere.model.MAddressValidation;
import org.compiere.model.MLocation;
import org.compiere.model.MSysConfig;
import org.compiere.model.X_C_AddressValidation;
import org.osgi.service.event.Event;

@EventTopicDelegate
@ModelEventTopic(modelClass=MLocation.class)
public class AddressValidationEventDelegate
extends ModelEventDelegate<MLocation> {
    public AddressValidationEventDelegate(MLocation po, Event event) {
        super(po, event);
    }

    @BeforeNew
    @BeforeChange
    public void beforeCreateOrUpdate() {
        Object value;
        MLocation location = (MLocation)this.getModel();
        if (this.getEvent().containsProperty(this.getClass().getName()) && (value = this.getEvent().getProperty(this.getClass().getName())) instanceof AtomicInteger) {
            ((AtomicInteger)value).set(1);
        }
        String addressValidation = MSysConfig.getValue("ADDRESS_VALIDATION", null, location.getAD_Client_ID());
        boolean isEnabled = false;
        if (addressValidation != null && addressValidation.trim().length() > 0 && location.getCountry() != null) {
            StringTokenizer st = new StringTokenizer(addressValidation, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (!token.equals(location.getCountry().getCountryCode().trim())) continue;
                isEnabled = true;
                break;
            }
        }
        if (!isEnabled) {
            return;
        }
        X_C_AddressValidation validation = null;
        if (location.getC_AddressValidation_ID() > 0) {
            validation = new MAddressValidation(location.getCtx(), location.getC_AddressValidation_ID(), location.get_TrxName());
        }
        if (validation == null) {
            validation = MAddressValidation.getDefaultAddressValidation(location.getCtx(), location.getAD_Client_ID(), location.get_TrxName());
        }
        if (validation != null) {
            location.processOnline(validation.getC_AddressValidation_ID());
        }
    }
}

