/******************************************************************************
 * Product: Adempiere ERP & CRM Smart Business Solution                       *
 * Copyright (C) 1999-2006 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software; you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;

/**
 *	Dunning Model
 *	
 *  @author Jorg Janke
 *  @version $Id: MDunning.java,v 1.3 2006/07/30 00:51:05 jjanke Exp $
 */
public class MDunning extends X_C_Dunning
{
	/**
	 * generated serial id
	 */
	private static final long serialVersionUID = -3844081441218291895L;

    /**
     * UUID based Constructor
     * @param ctx  Context
     * @param C_Dunning_UU  UUID key
     * @param trxName Transaction
     */
    public MDunning(Properties ctx, String C_Dunning_UU, String trxName) {
        super(ctx, C_Dunning_UU, trxName);
    }

	/**
	 * 	Standard Constructor
	 *	@param ctx context
	 *	@param C_Dunning_ID id
	 *	@param trxName transaction
	 */
	public MDunning (Properties ctx, int C_Dunning_ID, String trxName)
	{
		super (ctx, C_Dunning_ID, trxName);
	}	//	MDunning

	/**
	 * 	Load Constructor
	 *	@param ctx context
	 *	@param rs result set
	 *	@param trxName transaction
	 */
	public MDunning (Properties ctx, ResultSet rs, String trxName)
	{
		super(ctx, rs, trxName);
	}	//	MDunning

	/**
	 * @param ctx
	 * @param C_Dunning_ID
	 * @param trxName
	 * @param virtualColumns
	 */
	public MDunning(Properties ctx, int C_Dunning_ID, String trxName, String... virtualColumns) {
		super(ctx, C_Dunning_ID, trxName, virtualColumns);
	}

	/**
     * 	String Representation
     *	@return info
     */
    @Override
	public String toString()
    {
	    StringBuilder sb = new StringBuilder("MDunning[").append(get_ID())
	        .append("-").append(getName());
	    sb.append("]");
	    return sb.toString();
    }	//	toString
	
}	//	MDunning
