/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.NegativeInventoryDisallowedException;
import org.adempiere.exceptions.PeriodClosedException;
import org.adempiere.model.DocActionDelegate;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostHistory;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MTransaction;
import org.compiere.model.X_C_ProjectIssue;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MProjectIssue
extends X_C_ProjectIssue
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -3899186445864400047L;
    private DocActionDelegate<MProjectIssue> docActionDelegate = null;
    private MProject m_parent = null;

    public MProjectIssue(Properties ctx, String C_ProjectIssue_UU, String trxName) {
        super(ctx, C_ProjectIssue_UU, trxName);
        if (Util.isEmpty(C_ProjectIssue_UU)) {
            this.setInitialDefaults();
        }
        this.init();
    }

    public MProjectIssue(Properties ctx, int C_ProjectIssue_ID, String trxName) {
        super(ctx, C_ProjectIssue_ID, trxName);
        if (C_ProjectIssue_ID == 0) {
            this.setInitialDefaults();
        }
        this.init();
    }

    private void setInitialDefaults() {
        this.setMovementQty(Env.ZERO);
        this.setPosted(false);
        this.setProcessed(false);
    }

    public MProjectIssue(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.init();
    }

    public MProjectIssue(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setClientOrg(project.getAD_Client_ID(), project.getAD_Org_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setLine(this.getNextLine());
        this.m_parent = project;
        this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        this.setMovementQty(Env.ZERO);
        this.setPosted(false);
        this.setProcessed(false);
        this.init();
    }

    private void init() {
        this.docActionDelegate = new DocActionDelegate<MProjectIssue>(this);
        this.docActionDelegate.setActionCallable("CO", () -> this.doComplete());
        this.docActionDelegate.setActionCallable("RC", () -> this.doReverse(false));
        this.docActionDelegate.setActionCallable("RA", () -> this.doReverse(true));
    }

    private int getNextLine() {
        return DB.getSQLValue(this.get_TrxName(), "SELECT COALESCE(MAX(Line),0)+10 FROM C_ProjectIssue WHERE C_Project_ID=?", this.getC_Project_ID());
    }

    public void setMandatory(int M_Locator_ID, int M_Product_ID, BigDecimal MovementQty) {
        this.setM_Locator_ID(M_Locator_ID);
        this.setM_Product_ID(M_Product_ID);
        this.setMovementQty(MovementQty);
    }

    public MProject getParent() {
        if (this.m_parent == null && this.getC_Project_ID() != 0) {
            this.m_parent = new MProject(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Deprecated
    public boolean process() {
        this.saveEx();
        return this.doComplete() == null;
    }

    private String doComplete() {
        Timestamp t;
        MProduct product;
        if (this.getM_Product_ID() == 0) {
            this.log.log(Level.SEVERE, "No Product");
            return "No Product";
        }
        if (!this.isReversal()) {
            try {
                this.periodClosedCheckForBackDateTrx(null);
            }
            catch (PeriodClosedException e) {
                return e.getLocalizedMessage();
            }
        }
        if (!(product = MProduct.get(this.getCtx(), this.getM_Product_ID())).isStocked()) {
            this.setProcessed(true);
            this.saveEx();
            return null;
        }
        MTransaction mTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "W+", this.getM_Locator_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
        mTrx.setC_ProjectIssue_ID(this.getC_ProjectIssue_ID());
        Timestamp dateMPolicy = this.getMovementDate();
        if (this.getM_AttributeSetInstance_ID() > 0 && (t = MStorageOnHand.getDateMaterialPolicy(this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.get_TrxName())) != null) {
            dateMPolicy = t;
        }
        boolean ok = true;
        try {
            if (this.getMovementQty().negate().signum() < 0) {
                String MMPolicy = product.getMMPolicy();
                Timestamp minGuaranteeDate = this.getMovementDate();
                int M_Warehouse_ID = this.getM_Locator_ID() > 0 ? this.getM_Locator().getM_Warehouse_ID() : this.getC_Project().getM_Warehouse_ID();
                MStorageOnHand[] storages = MStorageOnHand.getWarehouse(this.getCtx(), M_Warehouse_ID, this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, this.getM_Locator_ID(), this.get_TrxName(), true);
                BigDecimal qtyToIssue = this.getMovementQty();
                MStorageOnHand[] mStorageOnHandArray = storages;
                int n = storages.length;
                int n2 = 0;
                while (n2 < n) {
                    MStorageOnHand storage = mStorageOnHandArray[n2];
                    if (storage.getQtyOnHand().compareTo(qtyToIssue) >= 0) {
                        storage.addQtyOnHand(qtyToIssue.negate());
                        qtyToIssue = BigDecimal.ZERO;
                    } else {
                        qtyToIssue = qtyToIssue.subtract(storage.getQtyOnHand());
                        storage.addQtyOnHand(storage.getQtyOnHand().negate());
                    }
                    if (qtyToIssue.signum() == 0) break;
                    ++n2;
                }
                if (qtyToIssue.signum() > 0) {
                    ok = MStorageOnHand.add(this.getCtx(), this.getM_Locator_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), qtyToIssue.negate(), dateMPolicy, this.get_TrxName());
                }
            } else {
                ok = MStorageOnHand.add(this.getCtx(), this.getM_Locator_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getMovementQty().negate(), dateMPolicy, this.get_TrxName());
            }
        }
        catch (NegativeInventoryDisallowedException e) {
            this.log.severe(e.getMessage());
            StringBuilder error = new StringBuilder();
            error.append(Msg.getElement(this.getCtx(), "Line")).append(" ").append(this.getLine()).append(": ");
            error.append(e.getMessage()).append("\n");
            throw new AdempiereException(error.toString());
        }
        if (!ok) {
            this.log.log(Level.SEVERE, "Storage not updated");
            return "Storage not updated";
        }
        mTrx.saveEx(this.get_TrxName());
        return null;
    }

    private String doReverse(boolean accrual) {
        Timestamp reversalDate = accrual ? new Timestamp(System.currentTimeMillis()) : this.getMovementDate();
        try {
            this.periodClosedCheckForBackDateTrx(reversalDate);
        }
        catch (PeriodClosedException e) {
            return "Reversal ERROR: " + e.getLocalizedMessage();
        }
        MProject project = this.getParent();
        MProjectIssue reversal = new MProjectIssue(project);
        reversal.set_TrxName(this.get_TrxName());
        reversal.setM_Locator_ID(this.getM_Locator_ID());
        reversal.setM_Product_ID(this.getM_Product_ID());
        reversal.setM_AttributeSetInstance_ID(this.getM_AttributeSetInstance_ID());
        reversal.setMovementQty(this.getMovementQty().negate());
        reversal.setMovementDate(reversalDate);
        reversal.setDescription("Reversal for Line No " + this.getLine() + "<" + this.getC_ProjectIssue_ID() + ">");
        reversal.setReversal_ID(this.getC_ProjectIssue_ID());
        reversal.saveEx(this.get_TrxName());
        try {
            if (!reversal.processIt("CO")) {
                return "Reversal ERROR: " + reversal.getProcessMsg();
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new AdempiereException(e);
        }
        reversal.closeIt();
        reversal.setProcessing(false);
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        this.setReversal_ID(reversal.getC_ProjectIssue_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        return null;
    }

    public boolean isReversal() {
        return this.getReversal_ID() > 0 && (this.getC_ProjectIssue_ID() > this.getReversal_ID() || this.getC_ProjectIssue_ID() == 0);
    }

    @Override
    public void setDocStatus(String newStatus) {
        this.docActionDelegate.setDocStatus(newStatus);
    }

    @Override
    public String getDocStatus() {
        return this.docActionDelegate.getDocStatus();
    }

    @Override
    public boolean processIt(String action) throws Exception {
        return this.docActionDelegate.processIt(action);
    }

    @Override
    public boolean unlockIt() {
        return this.docActionDelegate.unlockIt();
    }

    @Override
    public boolean invalidateIt() {
        return this.docActionDelegate.invalidateIt();
    }

    @Override
    public String prepareIt() {
        return this.docActionDelegate.prepareIt();
    }

    @Override
    public boolean approveIt() {
        return this.docActionDelegate.approveIt();
    }

    @Override
    public boolean rejectIt() {
        return this.docActionDelegate.rejectIt();
    }

    @Override
    public String completeIt() {
        return this.docActionDelegate.completeIt();
    }

    @Override
    public boolean voidIt() {
        return this.docActionDelegate.voidIt();
    }

    @Override
    public boolean closeIt() {
        return this.docActionDelegate.closeIt();
    }

    @Override
    public boolean reverseCorrectIt() {
        return this.docActionDelegate.reverseCorrectIt();
    }

    @Override
    public boolean reverseAccrualIt() {
        return this.docActionDelegate.reverseAccrualIt();
    }

    @Override
    public boolean reActivateIt() {
        return false;
    }

    @Override
    public String getSummary() {
        Object summary = this.getDocumentInfo();
        if (this.getM_Product_ID() > 0) {
            summary = (String)summary + "|" + MProduct.get(this.getM_Product_ID()).getValue() + "|" + this.getMovementQty().toPlainString();
        }
        return summary;
    }

    @Override
    public String getDocumentNo() {
        return this.getParent().getValue() + "|" + this.getLine();
    }

    @Override
    public String getDocumentInfo() {
        return this.getParent().getValue() + "|" + this.getParent().getName() + "|" + this.getLine();
    }

    @Override
    public File createPDF() {
        return this.docActionDelegate.createPDF();
    }

    @Override
    public String getProcessMsg() {
        return this.docActionDelegate.getProcessMsg();
    }

    @Override
    public int getDoc_User_ID() {
        return this.getParent().getSalesRep_ID();
    }

    @Override
    public int getC_Currency_ID() {
        return this.docActionDelegate.getC_Currency_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.docActionDelegate.getApprovalAmt();
    }

    @Override
    public String getDocAction() {
        return this.docActionDelegate.getDocAction();
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == this.get_Table_ID() && docStatus.equals("CO")) {
            boolean periodOpen = MPeriod.isOpen(Env.getCtx(), this.getMovementDate(), "PJI", this.getAD_Org_ID());
            boolean isBackDateTrxAllowed = MAcctSchema.isBackDateTrxAllowed(Env.getCtx(), this.getMovementDate(), this.get_TrxName());
            if (periodOpen && isBackDateTrxAllowed) {
                options[index++] = "RC";
            }
            options[index++] = "RA";
        }
        return index;
    }

    private boolean periodClosedCheckForBackDateTrx(Timestamp reversalDate) {
        MCostDetail cd;
        MClientInfo info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        MAcctSchema as = info.getMAcctSchema1();
        if (!"A".equals(as.getCostingMethod()) && !"I".equals(as.getCostingMethod())) {
            return true;
        }
        if (as.getBackDateDay() == 0) {
            return true;
        }
        Timestamp dateAcct = reversalDate != null ? reversalDate : this.getMovementDate();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(*) FROM M_CostDetail ");
        sql.append("WHERE M_Product_ID IN (SELECT M_Product_ID FROM C_ProjectIssue WHERE C_ProjectIssue_ID=?) ");
        sql.append("AND Processed='Y' ");
        sql.append(reversalDate != null ? "AND DateAcct>=? " : "AND DateAcct>? ");
        int no = DB.getSQLValueEx(this.get_TrxName(), sql.toString(), this.get_ID(), this.get_ID(), dateAcct);
        if (no <= 0) {
            return true;
        }
        int AD_Org_ID = this.getAD_Org_ID();
        int M_AttributeSetInstance_ID = this.getM_AttributeSetInstance_ID();
        if ("C".equals(as.getCostingLevel())) {
            AD_Org_ID = 0;
            M_AttributeSetInstance_ID = 0;
        } else if ("O".equals(as.getCostingLevel())) {
            M_AttributeSetInstance_ID = 0;
        } else if ("B".equals(as.getCostingLevel())) {
            AD_Org_ID = 0;
        }
        MCostElement ce = MCostElement.getMaterialCostElement(this.getCtx(), as.getCostingMethod(), AD_Org_ID);
        int M_CostDetail_ID = 0;
        int C_ProjectIssue_ID = this.getC_ProjectIssue_ID();
        if (this.getReversal_ID() > 0 && this.get_ID() > this.getReversal_ID()) {
            C_ProjectIssue_ID = this.getReversal_ID();
        }
        if ((cd = MCostDetail.getProjectIssue(as, this.getM_Product_ID(), M_AttributeSetInstance_ID, C_ProjectIssue_ID, 0, this.get_TrxName())) != null) {
            M_CostDetail_ID = cd.getM_CostDetail_ID();
        } else {
            MCostHistory history = MCostHistory.get(this.getCtx(), this.getAD_Client_ID(), AD_Org_ID, this.getM_Product_ID(), as.getM_CostType_ID(), as.getC_AcctSchema_ID(), ce.getCostingMethod(), ce.getM_CostElement_ID(), M_AttributeSetInstance_ID, dateAcct, this.get_TrxName());
            if (history != null) {
                M_CostDetail_ID = history.getM_CostDetail_ID();
            }
        }
        if (M_CostDetail_ID > 0) {
            MCostDetail.periodClosedCheckForDocsAfterBackDateTrx(this.getAD_Client_ID(), as.getC_AcctSchema_ID(), this.getM_Product_ID(), M_CostDetail_ID, dateAcct, this.get_TrxName());
        }
        return true;
    }
}

