/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPeriod;
import org.compiere.model.MPeriodControl;
import org.compiere.model.MProcessPara;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;

@Process
public class PeriodStatus
extends SvrProcess {
    private List<Integer> p_C_Period_IDs = null;
    private List<Integer> p_C_PeriodControl_IDs = null;
    private String p_PeriodAction = null;
    private int p_C_DocBaseGroup_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("PeriodAction")) {
                    this.p_PeriodAction = (String)para[i].getParameter();
                } else if (name.equals("C_DocBaseGroup_ID")) {
                    this.p_C_DocBaseGroup_ID = para[i].getParameterAsInt();
                } else if (!name.equals("*RecordIDs*")) {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_C_Period_IDs = this.getRecord_IDs();
        if (this.p_C_Period_IDs == null || this.p_C_Period_IDs.size() == 0) {
            if (this.getRecord_ID() == 0) {
                int[] ids = DB.getIDsEx((String)this.get_TrxName(), (String)"SELECT T_Selection_ID FROM T_Selection WHERE AD_PInstance_ID=?", (Object[])new Object[]{this.getAD_PInstance_ID()});
                if (ids.length > 0) {
                    this.p_C_PeriodControl_IDs = new ArrayList<Integer>();
                    int[] nArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int id = nArray[n2];
                        this.p_C_PeriodControl_IDs.add(id);
                        ++n2;
                    }
                }
            } else {
                this.p_C_Period_IDs = new ArrayList<Integer>();
                this.p_C_Period_IDs.add(this.getRecord_ID());
            }
        }
    }

    protected String doIt() throws Exception {
        int no = 0;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info((this.p_C_PeriodControl_IDs != null ? "C_PeriodControl_ID=" + String.valueOf(this.p_C_PeriodControl_IDs) : "C_Period_ID=" + String.valueOf(this.p_C_Period_IDs)) + ", PeriodAction=" + this.p_PeriodAction);
        }
        if (!(this.p_C_PeriodControl_IDs != null && this.p_C_PeriodControl_IDs.size() != 0 || this.p_C_Period_IDs != null && this.p_C_Period_IDs.size() != 0)) {
            throw new AdempiereUserError("@FillMandatory@ @C_Period_ID@");
        }
        if (Util.isEmpty((String)this.p_PeriodAction) || "N".equals(this.p_PeriodAction)) {
            return "-";
        }
        if (("C".equalsIgnoreCase(this.p_PeriodAction) || "P".equalsIgnoreCase(this.p_PeriodAction)) && MSysConfig.getBooleanValue((String)"FORCE_POSTING_PRIOR_TO_PERIOD_CLOSE", (boolean)true, (int)this.getAD_Client_ID())) {
            if (this.p_C_Period_IDs != null) {
                for (int periodID : this.p_C_Period_IDs) {
                    MPeriod p = MPeriod.get((int)periodID);
                    if (!p.hasUnpostedDocs()) continue;
                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"PostUnpostedDocs"));
                }
            } else {
                for (int periodControlID : this.p_C_PeriodControl_IDs) {
                    MPeriodControl pc = new MPeriodControl(this.getCtx(), periodControlID, this.get_TrxName());
                    MPeriod p = MPeriod.get((int)pc.getC_Period_ID());
                    if (!p.hasUnpostedDocs(periodControlID)) continue;
                    throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"PostUnpostedDocs"));
                }
            }
        }
        StringBuilder sql = new StringBuilder("UPDATE C_PeriodControl SET PeriodStatus=?, PeriodAction='N', Updated=getDate(), UpdatedBy=? WHERE ");
        StringBuilder wherepc = new StringBuilder();
        if (this.p_C_Period_IDs != null && this.p_C_Period_IDs.size() > 0) {
            wherepc.append("C_Period_ID IN (");
            boolean addComma = false;
            for (int id : this.p_C_Period_IDs) {
                if (addComma) {
                    wherepc.append(",");
                } else {
                    addComma = true;
                }
                wherepc.append(id);
            }
        } else if (this.p_C_PeriodControl_IDs != null && this.p_C_PeriodControl_IDs.size() > 0) {
            wherepc.append("C_PeriodControl_ID IN (");
            boolean addComma = false;
            for (int id : this.p_C_PeriodControl_IDs) {
                if (addComma) {
                    wherepc.append(",");
                } else {
                    addComma = true;
                }
                wherepc.append(id);
            }
        }
        wherepc.append(") AND PeriodStatus<>'P' AND PeriodStatus<>?");
        if (this.p_C_DocBaseGroup_ID > 0) {
            wherepc.append(" AND DocBaseType IN (").append(" SELECT gl.DocBaseType FROM C_DocBaseGroupLine gl WHERE gl.C_DocBaseGroup_ID = ").append(this.p_C_DocBaseGroup_ID).append(")");
        }
        sql.append((CharSequence)wherepc);
        StringBuilder sqlPeriods = new StringBuilder("SELECT DISTINCT C_Period_ID FROM C_PeriodControl WHERE ").append((CharSequence)wherepc);
        int[] periods = DB.getIDsEx((String)this.get_TrxName(), (String)sqlPeriods.toString(), (Object[])new Object[]{this.p_PeriodAction});
        no += DB.executeUpdateEx((String)sql.toString(), (Object[])new Object[]{this.p_PeriodAction, this.getAD_User_ID(), this.p_PeriodAction}, (String)this.get_TrxName());
        if (periods != null && periods.length > 0) {
            int[] nArray = periods;
            int n = periods.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                CacheMgt.get().reset("C_Period", id);
                ++n2;
            }
        }
        if (this.p_C_PeriodControl_IDs != null && this.p_C_PeriodControl_IDs.size() > 0) {
            for (int id : this.p_C_PeriodControl_IDs) {
                CacheMgt.get().reset("C_PeriodControl", id);
            }
        }
        StringBuilder msgreturn = new StringBuilder("@Updated@ #").append(no);
        return msgreturn.toString();
    }
}

