/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTab;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Util;

@Process
public class TabCreateFields
extends SvrProcess {
    private int p_AD_Tab_ID = 0;
    private String p_EntityType = null;
    private Timestamp p_CreatedSince = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("EntityType")) {
                    this.p_EntityType = (String)para[i].getParameter();
                } else if (name.equals("CreatedSince")) {
                    this.p_CreatedSince = para[i].getParameterAsTimestamp();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_AD_Tab_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        int count;
        block39: {
            MTab tab = new MTab(this.getCtx(), this.p_AD_Tab_ID, this.get_TrxName());
            if (this.p_AD_Tab_ID == 0 || tab == null || tab.get_ID() == 0) {
                throw new AdempiereSystemError("@NotFound@: @AD_Tab_ID@ " + this.p_AD_Tab_ID);
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info(tab.toString());
            }
            count = 0;
            Object sql = "SELECT * FROM AD_Column c WHERE NOT EXISTS (SELECT * FROM AD_Field f WHERE c.AD_Column_ID=f.AD_Column_ID AND c.AD_Table_ID=? AND f.AD_Tab_ID=?) AND AD_Table_ID=? AND NOT (Name LIKE 'Created%' OR Name LIKE 'Updated%') AND IsActive='Y' ";
            if (!Util.isEmpty((String)this.p_EntityType)) {
                sql = (String)sql + " AND c.entitytype = ? ";
            }
            if (this.p_CreatedSince != null) {
                sql = (String)sql + " AND c.created >= ? ";
            }
            sql = (String)sql + " ORDER  BY CASE             WHEN c.ColumnName = 'AD_Client_ID' THEN -100             WHEN c.ColumnName = 'AD_Org_ID' THEN -90             WHEN c.IsParent = 'Y' THEN -85             WHEN c.ColumnName = 'Value' THEN -80             WHEN c.ColumnName = 'Name' THEN -70             WHEN c.ColumnName = 'Description' THEN -60             WHEN c.ColumnName = 'Help' THEN -50             WHEN c.ColumnName = 'IsActive' THEN 1000000000             ELSE c.AD_Column_ID           END ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            int seqno = DB.getSQLValue(null, (String)"SELECT MAX(SeqNo) FROM AD_Field WHERE AD_Tab_ID=?", (int)tab.getAD_Tab_ID());
            int seqnogrid = DB.getSQLValue(null, (String)"SELECT MAX(SeqNoGrid) FROM AD_Field WHERE AD_Tab_ID=?", (int)tab.getAD_Tab_ID());
            seqno += 10;
            seqnogrid += 10;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, tab.getAD_Table_ID());
                    pstmt.setInt(2, tab.getAD_Tab_ID());
                    pstmt.setInt(3, tab.getAD_Table_ID());
                    int i = 4;
                    if (!Util.isEmpty((String)this.p_EntityType)) {
                        pstmt.setString(i++, this.p_EntityType);
                    }
                    if (this.p_CreatedSince != null) {
                        pstmt.setTimestamp(i++, this.p_CreatedSince);
                    }
                    rs = pstmt.executeQuery();
                    String uuidcolname = PO.getUUIDColumnName((String)tab.getAD_Table().getTableName());
                    while (rs.next()) {
                        MColumn column = new MColumn(this.getCtx(), rs, this.get_TrxName());
                        MField field = new MField(tab);
                        field.setColumn(column);
                        if ("D".equals(column.getEntityType())) {
                            field.setEntityType(tab.getEntityType());
                        } else {
                            field.setEntityType(column.getEntityType());
                        }
                        if (column.isKey() || uuidcolname.equalsIgnoreCase(field.getName())) {
                            field.setIsDisplayed(false);
                            field.setIsDisplayedGrid(false);
                        }
                        if (column.getAD_Reference_ID() == 28 || column.getAD_Reference_ID() == 20) {
                            field.setXPosition(2);
                        }
                        field.setColumnSpan(2);
                        if (column.getFieldLength() >= 60) {
                            field.setColumnSpan(5);
                        }
                        if (column.getAD_Reference_ID() == 14) {
                            field.setNumLines(3);
                        } else if (column.getAD_Reference_ID() == 36 || column.getAD_Reference_ID() == 200267) {
                            field.setNumLines(5);
                        } else if (column.getAD_Reference_ID() == 34) {
                            field.setNumLines(8);
                        }
                        String accessLevel = tab.getAD_Table().getAccessLevel();
                        if (column.getColumnName().equals("AD_Org_ID")) {
                            field.setXPosition(4);
                            if (accessLevel.equals("2") || accessLevel.equals("4") || accessLevel.equals("6")) {
                                field.setIsDisplayedGrid(false);
                            }
                        }
                        if (column.getColumnName().equals("AD_Client_ID") && !accessLevel.equals("7") && !accessLevel.equals("6")) {
                            field.setIsDisplayedGrid(false);
                        }
                        if (field.isDisplayed()) {
                            field.setSeqNo(seqno);
                            seqno += 10;
                        }
                        if (field.isDisplayedGrid()) {
                            field.setSeqNoGrid(seqnogrid);
                            seqnogrid += 10;
                        }
                        if (column.getColumnName().equalsIgnoreCase("AD_OrgTrx_ID")) {
                            field.setDisplayLogic("@$Element_OT@=Y");
                        } else if (column.getColumnName().equalsIgnoreCase("C_Campaign_ID")) {
                            field.setDisplayLogic("@$Element_MC@=Y");
                        } else if (column.getColumnName().equalsIgnoreCase("C_Activity_ID")) {
                            field.setDisplayLogic("@$Element_AY@=Y");
                        } else if (column.getColumnName().equalsIgnoreCase("C_Project_ID")) {
                            field.setDisplayLogic("@$Element_PJ@=Y");
                        } else if (column.getColumnName().equalsIgnoreCase("User1_ID")) {
                            field.setDisplayLogic("@$Element_U1@=Y");
                        } else if (column.getColumnName().equalsIgnoreCase("User2_ID")) {
                            field.setDisplayLogic("@$Element_U2@=Y");
                        }
                        if (column.getColumnName().equalsIgnoreCase("IsApproved") || column.getColumnName().equalsIgnoreCase("DocStatus") || column.getColumnName().equalsIgnoreCase("Processed") || column.getColumnName().equalsIgnoreCase("ProcessedOn") || column.getColumnName().equalsIgnoreCase("Processing")) {
                            field.setIsReadOnly(true);
                        }
                        if (!field.save()) continue;
                        this.addLog(0, null, null, column.getName());
                        ++count;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, (String)sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block39;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        StringBuilder msgreturn = new StringBuilder("@Created@ #").append(count);
        return msgreturn.toString();
    }
}

