/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Sheet;
import io.keikai.model.CellRegion;
import io.keikai.ui.impl.undo.AbstractCellDataStyleAction;

public class ClearCellAction
extends AbstractCellDataStyleAction {
    private static final long serialVersionUID = 3441368688115033569L;
    private CellStyle[][] oldStyles = null;
    private String[][] oldEditTexts = null;
    private Type _type;

    public ClearCellAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, Type type) {
        super(label, sheet, row, column, lastRow, lastColumn, ClearCellAction.toReserveType(type));
        this._type = type;
    }

    private static int toReserveType(Type type) {
        switch (type) {
            case CONTENT: {
                return 1;
            }
            case STYLE: {
                return 6;
            }
            case ALL: {
                return 7;
            }
        }
        return 7;
    }

    @Override
    protected void applyAction() {
        Range r = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
        switch (this._type) {
            case CONTENT: {
                CellOperationUtil.clearContents(r);
                break;
            }
            case STYLE: {
                CellOperationUtil.clearStyles(r);
                break;
            }
            case ALL: {
                CellOperationUtil.clearAll(r);
            }
        }
    }

    @Override
    protected boolean isSheetProtected() {
        return this.isAnyCellProtected(this._sheet, new CellRegion(this._row, this._column, this._lastRow, this._lastColumn));
    }

    public static enum Type {
        CONTENT,
        STYLE,
        ALL;

    }
}

