


zss.TopPanel = zk.$extends(zss.Panel, {
	widgetName: 'TopPanel',
	type: 'top',
	$o: zk.$void, 
	initHeaders_: function (sheet, start, end, data, isCorner) {
		var ary = [],
			headers = data.columnHeaders,
			type = zss.Header.HOR,
			topHeaders = isCorner ? sheet.tp.headers : null,
			j = 0;
		for (var i = start; i <= end; i++) {
			var h = new zss.Header(sheet, type, headers[i], topHeaders ? topHeaders[j++] : null);
			this.appendChild(h, true);
			ary.push(h);
		}
		return ary;
	},
	
	create_: function (dir, colStart, colEnd, frozenRowStart, frozenRowEnd, createFrozenOnly) {
		if (!createFrozenOnly)
			this.createHeaders_(dir, colStart, colEnd);

		var createFrozen = frozenRowStart >= 0 && frozenRowEnd >= 0;
		if ('jump' == dir && createFrozen) {
			var oldBlock = this.block;
			this.block = new zss.CellBlockCtrl(this.sheet, frozenRowStart, colStart, frozenRowEnd, colEnd, this.getFrozenData_(), 'top'); 
			oldBlock ? oldBlock.replaceWidget(this.block) : this.appendChild(this.block);
		} else if (this.block && createFrozen) {
			this.block.create_(dir, frozenRowStart, colStart, frozenRowEnd, colEnd, this.getFrozenData_());
		}
	},
	initFrozenBlock_: function (sheet, lCol, rCol, data) {
		var r = sheet.frozenRow;
		if (r > -1) {
			var b = new zss.CellBlockCtrl(sheet, 0, lCol, r, rCol, data, 'top');
			this.appendChild(b);
			return b;
		}
		return null;
	},
	getHeaderData_: function () {
		
		if(this.isCorner) {
			return this.sheet._wgt._cacheCtrl.getSelectedSheet().leftFrozen.columnHeaders;
		} else {
			return this.sheet._wgt._cacheCtrl.getSelectedSheet().columnHeaders;
		}
	},
	getFrozenData_: function () {
		var a = this.sheet._wgt._cacheCtrl.getSelectedSheet(),
			f = a.topFrozen;
		return f ? f : a;
	},
	getFrozenHeaderData_: function () {
		var topFrozen =  this.getFrozenData_();
		return topFrozen ? topFrozen.rowHeaders : null;
	},
	getHeaderType_: function () {
		return zss.Header.HOR;
	},
	isInsert_: function (dir) {
		return 'west' == dir;
	},
	bindFrozenCtrl_: function () {
		var sheet = this.sheet,
			selArea = this.$n('select'),
			selChg = selArea.nextSibling,
			focus = selChg.nextSibling,
			highlight = focus.nextSibling;
		
		this.selArea = new zss.SelAreaCtrlTop(sheet, selArea, sheet.initparm.selrange.clone());
		this.selChgArea = new zss.SelChgCtrlTop(sheet, selChg);
		this.focusMark = new zss.FocusMarkCtrlTop(sheet, focus, sheet.initparm.focus.clone());
		this.hlArea = new zss.HighlightTop(sheet, highlight, sheet.initparm.hlrange.clone(), "inner");
	},
	
	addEditorFocus_ : function(id, name, div) {
		if(!this.editorFocusMark)
			this.editorFocusMark = new Object();
		this.editorFocusMark[id] = new zss.FocusMarkCtrlTop(this.sheet, div, new zss.Pos(0, 0));
	},
	_getTopHeaderFontSize: function () {
		var head = this.$n('head'),
			col = head != null ? head.firstChild : null;
		if (col && col.getAttribute('zs.t') == 'STheader')
			return jq(col).css('font-size');
		return null;
	},
	bind_: function () {
		this.$supers(zss.TopPanel, 'bind_', arguments);
		var fontSize= this.isCorner && (zk.ie && zk.ie < 11) ? this._getTopHeaderFontSize() : null;
		if (fontSize)
			this.fontSize = fontSize;
	},
	unbind_: function () {
		this.$supers(zss.TopPanel, 'unbind_', arguments);
		this.fontSize = null;
	},
	getTypeAttr_: function () {
		return 'STopPanel';
	},
	removeChildFromStart_: function (size) {
		if (this.block) {
			this.block.removeColumnsFromStart_(size);
		}
		this.$supers(zss.TopPanel, 'removeChildFromStart_', arguments);
	},
	removeChildFromEnd_: function (size) {
		if (this.block) {
			this.block.removeColumnsFromEnd_(size);
		}
		this.$supers(zss.TopPanel, 'removeChildFromEnd_', arguments);
	},
	
	_getCornerHeaderFontSize: function () {
		return this.fontSize;
	},
	_updateWidth: function (width) {
		jq(this.comp).css('width', jq.px0(width));
		this.width = width;	
		this._updateBlockWidth();
	},
	_updateLeftPos: function (pos) {
		jq(this.icomp).css('left', jq.px(pos));
		jq(this.wpcomp).css('left', jq.px(pos-this.sheet.leftWidth));
		this.leftpos = pos;
		this._updateBlockWidth();
	},
	_updateLeftPadding: function (leftpad) {
		leftpad = leftpad - this.sheet.leftWidth;
		jq(this.icomp).css('padding-left', jq.px0(leftpad));
		this.leftpad = leftpad;
		this._updateBlockWidth();
	},
	_updateBlockWidth: function () {
		if (!this.block) return;
		var width = this.width,
			leftpos = this.leftpos,
			leftpad = this.leftpad;
		
		width = width - (leftpos ? leftpos : 0) - (leftpad ? leftpad : 0);		






		if (width < 0) width = 0;
		jq(this.block.comp).css('width', jq.px0(width));
	},
	
	updateSelectionCSS: function (from, to, remove) {
		var i = this.headers.length,
			header;
		while (i--) {
			header = this.headers[i];
			if (header.index >= from && header.index <= to)
				jq(header.comp)[remove ? 'removeClass' : 'addClass']("zstop-sel");
		}
	},
	
	appendZSW: function (col, zsw) {
		if (this.block)
			this.block.appendZSW(col, zsw);

		
		if(this.isEmptyHeader()) {
			return;
		}

		var left = this.headers[0].index,
			right = left + this.headers.length - 1;
		if (left > col || right < col) return;
		
		var index = col - left,
			header = this.headers[index];
		header.appendZSW(zsw);
	},
	
	appendZSH: function (row, zsh) {
		if (this.block)
			this.block.appendZSH(row, zsh);
	},
	
	insertNewColumn: function (col, size, extnm) {
		if (this.block)
			this.block.insertNewColumn(col, size);

		
		if(this.isEmptyHeader()) {
			return;
		}

		var left = this.headers[0].index,
			right = left + this.headers.length - 1; 
		if (col > (right + 1) || col < left) return;
		
		var index = col - left,
			ctrl,
			colHeaders = this.getHeaderData_(),
			type = zss.Header.HOR,
			fontSize = (zk.ie && zk.ie < 11) ? this._getCornerHeaderFontSize() : null;
			
		
		var sheet = this.sheet,
			selRange = sheet.selArea.lastRange;
		if (sheet.state != zss.SSheetCtrl.NOFOCUS && selRange) {
			var left = selRange.left,
				right = selRange.right;
			if (col <= right && (col+size-1) >= left)
				this.updateSelectionCSS(left, right, true);
		}
			
		for (var i = 0; i < size; i++) {
			var c = col + i;
			ctrl = new zss.Header(sheet, type, colHeaders[c]);
			



			
			this.insertHeader_(index + i, ctrl);
		}
		extnm = extnm.slice(size, extnm.length);
		this.shiftHeaderInfo(index + size, col + size,extnm);
	},
	
	insertNewRow: function (row, size) {
		if (this.block)
			this.block.insertNewRow(row,size);
	},
	
	shiftHeaderInfo: function (index, newcol, extnm) {
		var size = this.headers.length,
			j = 0;
		for (var i = index; i < size; i++) {
			if (!extnm[j]) zk.log("undefined header to assing>>"+(newrow+j),"always");
			this.headers[i].resetInfo(newcol + j, extnm[j]);
			j++;
		}
	},
	
	removeColumn: function (col, size, extnm) {
		if (this.block)
			this.block.removeColumn(col,size);

		
		if(this.isEmptyHeader()) {
			return;
		}

		var left = this.headers[0].index,
			right = left + this.headers.length -1; 
		if (col > (right+1) || col < left) return;
		
		var index = col - left;
		if ((col + size) > right)
			size = right - col + 1;
		this.removeHeader_(index, size);
		this.shiftHeaderInfo(index, col, extnm);
	},
	
	removeRow: function (row, size) {
		if (this.block)
			this.block.removeRow(row, size);
	},
	
	updateSelectionCSS_: function () {
		var sheet = this.sheet,
			wgt = sheet._wgt,
			selRange = sheet.selArea.lastRange;
		if (!wgt.isSheetCSSReady())
			return;
		
		if (selRange) {
			var left = selRange.left,
				right = selRange.right;
			this.updateSelectionCSS(left, right, false || sheet.state == zss.SSheetCtrl.NOFOCUS);
		}
	},
	_fixSize: function() {
		var sheet = this.sheet,
			wgt = sheet._wgt,
			th = sheet.topHeight,
			toph = th,
			fzr = sheet.frozenRow,
			name = wgt.getSelectorPrefix(),
			sid = wgt.getSheetCSSId();
		
		if (fzr > -1)
			toph = toph + sheet.custRowHeight.getStartPixel(fzr + 1);
		
		zcss.setRule(name + " .zstop", ["height"], [(fzr > -1 ? toph - 1: toph) + "px"], true, sid);
		zcss.setRule(name + " .zstopi", ["height"], [toph + "px"], true, sid);
	}
});