/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import io.keikai.ui.Spreadsheet;
import java.io.Serializable;
import java.lang.ref.WeakReference;

public class Focus
implements Serializable {
    private static final long serialVersionUID = 2401696322103952998L;
    private final String id;
    private String name;
    private String color;
    private int row;
    private int col;
    private String sheetId;
    private final transient WeakReference<Spreadsheet> ss;

    public Focus(String id, String name, String color, String sheetId, int row, int col, Spreadsheet ss) {
        this.id = id;
        this.name = name;
        this.color = color;
        this.row = row;
        this.col = col;
        this.sheetId = sheetId;
        this.ss = new WeakReference<Spreadsheet>(ss);
    }

    public String getId() {
        return this.id;
    }

    public String getSheetId() {
        return this.sheetId;
    }

    public String getName() {
        return this.name;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.col;
    }

    public void setPosition(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public void setSheetId(String sheetId) {
        this.sheetId = sheetId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isDetached() {
        try {
            return this.ss == null || this.ss.get() == null || ((Spreadsheet)this.ss.get()).getDesktop() == null || !((Spreadsheet)this.ss.get()).getDesktop().isAlive();
        }
        catch (Exception x) {
            return true;
        }
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Focus)) {
            return false;
        }
        return this.id.equals(((Focus)other).id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Focus[id:").append(this.id).append(",name:").append(this.name).append(",color:").append(this.color).append(",sheetId:").append(this.sheetId).append(",row:").append(this.row).append(",column:").append(this.col).append("]");
        return sb.toString();
    }

    public void setColor(String color) {
        this.color = color;
    }
}

