/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import io.keikai.model.SBook;
import io.keikai.model.sys.formula.EvaluationContributor;
import java.io.Serializable;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;

public class ComponentEvaluationContributor
implements EvaluationContributor,
Serializable {
    private static final long serialVersionUID = 1L;
    private Component comp;

    public ComponentEvaluationContributor(Component comp) {
        this.comp = comp;
    }

    private boolean isBelowDesktopScope(SBook book) {
        String scope = book.getShareScope();
        return scope == null || "desktop".equals(scope);
    }

    private boolean checkAlive() {
        if (this.comp == null) {
            return false;
        }
        if (this.comp.getDesktop() == null) {
            this.comp = null;
            return false;
        }
        return true;
    }

    public FunctionMapper getFunctionMaper(SBook book) {
        if (!this.checkAlive() && !this.isBelowDesktopScope(book)) {
            return null;
        }
        return new FunctionMapper(){

            public Function resolveFunction(String prefix, String name) throws XelException {
                FunctionMapper mapper;
                Page page = ComponentEvaluationContributor.this.comp.getPage();
                if (page != null && (mapper = page.getFunctionMapper()) != null) {
                    return mapper.resolveFunction(prefix, name);
                }
                return null;
            }
        };
    }

    public VariableResolver getVariableResolver(SBook book) {
        if (!this.checkAlive() && !this.isBelowDesktopScope(book)) {
            return null;
        }
        return new VariableResolver(){

            public Object resolveVariable(String name) throws XelException {
                Object result = null;
                Page page = ComponentEvaluationContributor.this.comp.getPage();
                if (page != null) {
                    result = page.getZScriptVariable(ComponentEvaluationContributor.this.comp, name);
                }
                if (result == null) {
                    result = ComponentEvaluationContributor.this.comp.getAttributeOrFellow(name, true);
                }
                if (result == null && page != null) {
                    result = page.getXelVariable(null, null, (Object)name, true);
                }
                return result;
            }
        };
    }
}

