/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl;

import io.keikai.api.AreaRef;
import io.keikai.model.SSheet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ActiveRangeHelper
implements Serializable {
    private static final long serialVersionUID = 4594859931532849803L;
    private HashMap<SSheet, AreaRef> activeRanges = new HashMap();

    public void setActiveRange(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        AreaRef rect = this.activeRanges.get(sheet);
        if (rect == null) {
            rect = new AreaRef(tRow, lCol, bRow, rCol);
            this.activeRanges.put(sheet, rect);
        } else {
            rect.setArea(tRow, lCol, bRow, rCol);
        }
    }

    public AreaRef getArea(SSheet sheet) {
        return this.activeRanges.get(sheet);
    }

    public boolean containsSheet(SSheet sheet) {
        return this.activeRanges.containsKey(sheet);
    }

    public boolean contains(SSheet sheet, int row, int col) {
        return this.contains(sheet, row, col, row, col);
    }

    public boolean contains(SSheet sheet, int tRow, int lCol, int bRow, int rCol) {
        AreaRef rect = this.activeRanges.get(sheet);
        if (rect == null) {
            return false;
        }
        return rect.contains(tRow, lCol, bRow, rCol);
    }

    public AreaRef removeActiveRange(SSheet sheet) {
        return this.activeRanges != null ? this.activeRanges.remove(sheet) : null;
    }

    public Iterator<SSheet> sheetIterator() {
        return new ArrayList<SSheet>(this.activeRanges.keySet()).iterator();
    }
}

