/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Sheet;
import io.keikai.ui.CellSelectionType;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractCellHandler;
import io.keikai.ui.impl.undo.CellStyleAction;
import io.keikai.ui.sys.UndoableActionManager;
import org.zkoss.util.resource.Labels;

public class VerticalAlignHandler
extends AbstractCellHandler {
    private static final long serialVersionUID = -4843520864700871509L;
    CellStyle.VerticalAlignment _type;

    public VerticalAlignHandler(CellStyle.VerticalAlignment type) {
        this._type = type;
    }

    @Override
    protected boolean processAction(UserActionContext ctx) {
        Sheet sheet = ctx.getSheet();
        AreaRef selection = ctx.getSelection();
        CellSelectionType type = ctx.getSelectionType();
        Range range = Ranges.range(sheet, selection);
        if (range.isProtected() && !range.getSheetProtection().isFormatCellsAllowed()) {
            this.showProtectMessage();
            return true;
        }
        switch (type) {
            case ROW: {
                range = range.toRowRange();
                break;
            }
            case COLUMN: {
                range = range.toColumnRange();
                break;
            }
            case ALL: {
                range = range.toColumnRange();
            }
        }
        selection = new AreaRef(range.getRow(), range.getColumn(), range.getLastRow(), range.getLastColumn());
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        uam.doAction(new CellStyleAction(Labels.getLabel((String)"zss.undo.cellStyle"), sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), CellOperationUtil.getVerticalAligmentApplier(this._type)));
        return true;
    }
}

